/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Connection;
import sunw.jdt.cal.rpc.MaxResendException;
import sunw.jdt.cal.rpc.ProgNotRegException;
import sunw.jdt.cal.util.Debug;

public class CmsdClient {
    private static Hashtable connections = new Hashtable();

    public static Connection getConnection(String host, AuthUser authUser) throws CalendarException {
        Connection conn;
        String key = String.valueOf(authUser.getUserName()) + "@" + host;
        Hashtable hashtable = connections;
        synchronized (hashtable) {
            conn = (Connection)connections.get(key);
            if (conn == null) {
                if (Debug.on) {
                    System.err.println("new conn to " + host);
                }
                try {
                    conn = new Connection(host);
                    connections.put(key, conn);
                    if (Debug.on) {
                        System.err.println("got Connection for " + host);
                    }
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                    throw new CalendarException(6, "server problem");
                }
            }
        }
        try {
            if (Debug.on) {
                System.err.println("Before conn.connect()");
            }
            conn.connect(authUser);
            if (Debug.on) {
                System.err.println("After conn.connect()");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new CalendarException(30, "unknown host");
        }
        catch (ProgNotRegException e) {
            throw new CalendarException(31, e.getMessage());
        }
        catch (MaxResendException e) {
            throw new CalendarException(33, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CalendarException(6, "server problem");
        }
        return conn;
    }
}

