/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sunw.jdt.cal.csa.CalEvent;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.CsaEventHandler;
import sunw.jdt.cal.csa.ProxyClient;
import sunw.jdt.cal.util.Debug;

class ClientRegistry {
    String mcal;
    int mevents = 0;
    Hashtable mclients;
    int mversion;

    ClientRegistry(String cal, int version) {
        this.mcal = cal;
        this.mversion = version;
        this.mclients = new Hashtable(1);
    }

    void handleEvent(CalEvent evt) {
        String cal = evt.getCalendar();
        if (cal == null && this.mversion > 4 || cal != null && (this.mversion <= 4 || this.notForMe(evt))) {
            return;
        }
        Enumeration elems = this.mclients.elements();
        while (elems.hasMoreElements()) {
            CsaEventHandler h = (CsaEventHandler)elems.nextElement();
            if (Debug.on) {
                System.out.println("**** invoking handler: " + h.toString());
            }
            h.handleEvent(evt);
        }
    }

    boolean notForMe(CalEvent evt) {
        String ecal = evt.getCalendar();
        if (ecal == null) {
            return true;
        }
        int atIndex = this.mcal.indexOf("@");
        String mname = this.mcal.substring(0, atIndex);
        String mhost = this.mcal.substring(atIndex + 1);
        atIndex = ecal.indexOf("@");
        String ename = ecal.substring(0, atIndex);
        if (!ename.equals(mname)) {
            return true;
        }
        String ehost = evt.getHost();
        int mdotIndex = mhost.indexOf(".");
        int edotIndex = ehost.indexOf(".");
        if (mdotIndex == -1) {
            return edotIndex != -1;
        }
        if (edotIndex == -1) {
            return false;
        }
        StringTokenizer mst = new StringTokenizer(mhost, ".");
        StringTokenizer est = new StringTokenizer(ehost, ".");
        mst.nextToken();
        est.nextToken();
        while (mst.hasMoreTokens()) {
            String mtoken;
            if (!est.hasMoreTokens()) {
                return true;
            }
            String etoken = est.nextToken();
            if (etoken.equalsIgnoreCase(mtoken = mst.nextToken())) continue;
            return true;
        }
        return false;
    }

    void register(int events, CsaEventHandler h) throws CalendarException {
        int oldevents = this.mevents;
        int newevents = oldevents | events;
        if ((newevents ^ oldevents) != 0) {
            if (Debug.on) {
                System.out.println("register with proxy, event = " + newevents);
            }
            ProxyClient.registerWithServer(this.mcal, newevents);
            this.mevents = newevents;
        }
        this.mclients.put(h, h);
    }

    void registerAgain() {
        if (Debug.on) {
            System.out.println("registering cb again with " + this.mcal + " for " + this.mevents);
        }
        try {
            ProxyClient.registerWithServer(this.mcal, this.mevents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean unregister(CsaEventHandler h) {
        CsaEventHandler rh = (CsaEventHandler)this.mclients.remove(h);
        if (rh == null && Debug.on) {
            System.out.println("ClientRegistry.unregister: " + h.getCalendar() + " not in registry");
        }
        if (this.mclients.isEmpty()) {
            if (Debug.on) {
                System.out.println("ClientRegistry.unregister: all registers for " + this.mcal + " are gone");
            }
            try {
                try {
                    ProxyClient.unregisterWithServer(this.mcal, this.mevents);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            catch (Throwable throwable) {}
            return true;
        }
        return false;
    }
}

