/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.io.EOFException;
import java.net.SocketException;
import java.util.Date;
import sunw.jdt.cal.csa.AccessRights;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Connection;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.LookupCriteria;
import sunw.jdt.cal.csa.RegisterThread;
import sunw.jdt.cal.csa.ReminderRef;
import sunw.jdt.cal.csa.Scope;

abstract class CalendarConnection {
    static final int PID = 2;
    Connection mconn;
    Calendar mcal;
    int mserverVersion;
    int mdataVersion;
    AccessRights maccess;

    CalendarConnection() {
    }

    public abstract void createCalendar() throws CalendarException;

    public abstract void deleteEntry(Appointment var1, Scope var2) throws CalendarException;

    public abstract CsaAccessEntry[] getAccessList() throws CalendarException;

    public abstract ReminderRef[] getReminder(Date var1, String[] var2) throws CalendarException;

    void handleException(Exception e) {
        if (e instanceof EOFException || e instanceof SocketException) {
            this.registerCallback();
        }
    }

    public abstract Appointment insertEntry(Appointment var1) throws CalendarException;

    public abstract Appointment[] lookupEntries(LookupCriteria var1) throws CalendarException;

    public abstract Attribute[] openCalendar() throws CalendarException;

    void registerCallback() {
        RegisterThread t = new RegisterThread(this.mconn.mhost);
        t.start();
    }

    public abstract void setAccessList(CsaAccessEntry[] var1) throws CalendarException;

    public abstract Appointment updateEntry(Appointment var1, Scope var2) throws CalendarException;
}

