/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import sunw.jdt.cal.cmsd5.cms_reminder_ref;
import sunw.jdt.cal.csa.AccessEntry;
import sunw.jdt.cal.csa.AccessObject;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.csa.CalEvent;
import sunw.jdt.cal.csa.CalEventHandler;
import sunw.jdt.cal.csa.CalendarConnection;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.CmsdConnection;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.CsaEventHandler;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.LocaleXlateTable;
import sunw.jdt.cal.csa.LookupCriteria;
import sunw.jdt.cal.csa.OpaqueData;
import sunw.jdt.cal.csa.OpaqueDataValue;
import sunw.jdt.cal.csa.ProxyClient;
import sunw.jdt.cal.csa.ReminderRef;
import sunw.jdt.cal.csa.Scope;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.util.Debug;

public class Calendar
implements CsaEventHandler {
    String mloc;
    String mname;
    String maddr;
    CalendarConnection mconn;
    AuthUser authenticatedUser = null;
    boolean justCreated = false;
    boolean meditable = false;
    boolean mcbEnabled = false;
    Vector mNonEditors = null;
    Vector mEditors = null;
    AccessObject maccess = null;
    Hashtable mattrs = null;
    CalEventHandler mhandler = null;
    int mevents = 0;
    boolean mdoingInsert = false;
    Vector mInsertedIds = null;
    Vector mDeletedIds = null;
    Vector mUpdatedIds = null;
    Locale mLocale;
    String mcalLocale = null;
    String mlang = null;
    String mcountry = null;
    String mencoding = null;
    boolean msetEntryCharSet = false;

    public Calendar(String cal) throws CalendarException {
        if (cal == null) {
            throw new CalendarException(19, "calendar address is null");
        }
        int index = cal.indexOf(64);
        if (index < 0) {
            throw new CalendarException(19, "calendar address in incorrect format");
        }
        String loc = cal.substring(index + 1);
        String name = cal.substring(0, index);
        this.init(loc, name, false, null);
    }

    public Calendar(String name, String host) throws CalendarException {
        this.init(host, name, false, null);
    }

    public Calendar(String name, String host, AuthUser authUser) throws CalendarException {
        this.init(host, name, false, authUser);
    }

    public Calendar(String name, String host, boolean create) throws CalendarException {
        this.init(host, name, create, null);
    }

    synchronized void addDeletedId(int id) {
        if (Debug.on) {
            System.err.println("addDeletedId: add id " + id);
        }
        if (this.mDeletedIds == null) {
            this.mDeletedIds = new Vector(1);
        }
        this.mDeletedIds.addElement(new Integer(id));
    }

    synchronized void addInsertedId(int id) {
        if (Debug.on) {
            System.err.println("addInsertedId: add id " + id);
        }
        if (this.mInsertedIds == null) {
            this.mInsertedIds = new Vector(1);
        }
        this.mInsertedIds.addElement(new Integer(id));
    }

    synchronized void addUpdatedId(int id) {
        if (Debug.on) {
            System.err.println("addUpdatedId: add id " + id);
        }
        if (this.mUpdatedIds == null) {
            this.mUpdatedIds = new Vector(1);
        }
        this.mUpdatedIds.addElement(new Integer(id));
    }

    private void cacheAttrs(Attribute[] attrs) {
        if (attrs == null) {
            return;
        }
        if (this.mattrs == null) {
            this.mattrs = new Hashtable();
        } else {
            this.mattrs.clear();
        }
        if (Debug.on) {
            System.err.println("** cacheAttrs: " + attrs.length + " attributes");
        }
        int i = 0;
        while (i < attrs.length) {
            if (Debug.on) {
                attrs[i].print();
            }
            this.mattrs.put(attrs[i].getName(), attrs[i]);
            ++i;
        }
        Attribute attr = (Attribute)this.mattrs.get("-//XAPIA/CSA/CALATTR//NONSGML Character Set//EN");
        if (attr != null) {
            this.mcalLocale = ((StringValue)attr.getValue()).getString();
        }
        if (this.mcalLocale != null) {
            this.mlang = LocaleXlateTable.getLang(this.mcalLocale);
            this.mcountry = LocaleXlateTable.getCountry(this.mcalLocale);
            this.mencoding = LocaleXlateTable.getEncoding(this.mcalLocale);
            if (this.mlang != null && this.mlang.equals(this.mLocale.getLanguage())) {
                String myCountry = this.mLocale.getCountry();
                if (myCountry == null || myCountry.length() == 0) {
                    if (!LocaleXlateTable.isCountryOptional(this.mcalLocale)) {
                        this.msetEntryCharSet = true;
                    }
                } else if (!myCountry.equals(this.mcountry)) {
                    this.msetEntryCharSet = true;
                }
            } else {
                this.msetEntryCharSet = true;
            }
            if (Debug.on) {
                System.err.println("mcalLocale=" + this.mcalLocale + ",mLocale=" + this.mLocale + ";msetEntryCharSet=" + this.msetEntryCharSet);
            }
        }
    }

    public boolean canWrite() {
        return this.meditable;
    }

    synchronized boolean delDeletedId(int id) {
        if (this.mDeletedIds == null) {
            return false;
        }
        boolean found = this.mDeletedIds.removeElement(new Integer(id));
        if (Debug.on && found) {
            System.err.println("delDeletedId: removed id " + id);
        }
        return found;
    }

    synchronized boolean delInsertedId(int id) {
        if (this.mInsertedIds == null) {
            return false;
        }
        boolean found = this.mInsertedIds.removeElement(new Integer(id));
        if (Debug.on && found) {
            System.err.println("delInsertedId: removed id " + id);
        }
        return found;
    }

    synchronized boolean delUpdatedId(int id) {
        if (this.mUpdatedIds == null) {
            return false;
        }
        boolean found = this.mUpdatedIds.removeElement(new Integer(id));
        if (Debug.on && found) {
            System.err.println("delUpdatedId: removed id " + id);
        }
        return found;
    }

    public void deleteAppt(Appointment appt) throws CalendarException {
        this.deleteAppt(appt, new Scope(0));
    }

    public void deleteAppt(Appointment appt, Scope scope) throws CalendarException {
        if (!this.meditable) {
            throw new CalendarException(3, "No write access");
        }
        if (appt == null) {
            throw new CalendarException(19, "Appointment object cannot be null");
        }
        if (appt.getCookie() != this) {
            throw new CalendarException(19, "Appointment is not returned by this Calendar object.");
        }
        if (scope == null) {
            scope = new Scope(0);
        }
        this.addDeletedId(appt.getIdentifier());
        this.mconn.deleteEntry(appt, scope);
    }

    public void done() {
        if (this.mcbEnabled) {
            ProxyClient.unregister(this);
            this.mcbEnabled = false;
        }
    }

    public AccessEntry[] getAccessEntries() throws CalendarException {
        return this.getAccessObject().getAccessEntries();
    }

    synchronized AccessObject getAccessObject() throws CalendarException {
        CsaAccessEntry[] accessEntries = null;
        Object info = null;
        if (this.maccess == null) {
            accessEntries = this.mconn.getAccessList();
            this.maccess = new AccessObject(this, accessEntries);
        }
        if (!this.mcbEnabled && this.mconn.mserverVersion >= 5) {
            ProxyClient.register(4, this);
            this.mcbEnabled = true;
        }
        return this.maccess;
    }

    public String getAddress() {
        return this.maddr;
    }

    public AuthUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public String getCalendar() {
        return this.maddr;
    }

    public int getDataVersion() {
        return this.mconn.mdataVersion;
    }

    public String getEncoding() {
        return this.mencoding;
    }

    public String[] getHostsForOwnerAccess() throws CalendarException {
        return this.getAccessObject().getHostsForOwnerAccess();
    }

    public String getLocation() {
        return this.mloc;
    }

    public String getName() {
        return this.mname;
    }

    public ReminderRef[] getReminder(Date time) throws CalendarException {
        if (!this.isOwner()) {
            throw new CalendarException(3, "Not owner");
        }
        if (time == null) {
            throw new CalendarException(19, "the Date object cannot be null");
        }
        return this.mconn.getReminder(time, null);
    }

    public int getServerVersion() {
        return this.mconn.mserverVersion;
    }

    void handleCalAttrUpdated(CalEvent evt) {
        block5: {
            try {
                String[] names = evt.getNames();
                if (names == null) {
                    return;
                }
                int i = 0;
                while (i < names.length) {
                    if (names[i].equals("-//XAPIA/CSA/CALATTR//NONSGML Access List//EN")) {
                        this.resetAccessObject();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!Debug.on) break block5;
                e.printStackTrace();
            }
        }
    }

    void handleEntryAddedEvent(CalEvent evt) {
        LookupCriteria lc = new LookupCriteria();
        try {
            lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN", new OpaqueDataValue(new OpaqueData(this.toNullEndedByteArray(String.valueOf(evt.getId()).getBytes())))));
            Appointment[] appts = this.lookupAppointments(lc);
            if (appts == null) {
                if (Debug.on) {
                    System.err.println("handleEntryAddedEvent:no appt returned for id " + evt.getId());
                }
                return;
            }
            CalEvent newevt = new CalEvent(evt);
            newevt.setRepeats(appts[0].getRepeat().repeats());
            newevt.setTime((int)(appts[0].getStartDate().getTime() / 1000L));
            this.mhandler.entryAdded(newevt);
        }
        catch (CalendarException e) {
            e.printStackTrace();
        }
    }

    public void handleEvent(CalEvent evt) {
        if (Debug.on) {
            System.err.println(String.valueOf(String.valueOf(this)) + ":Calendar.handleEvent called for " + this.maddr);
        }
        if (this.mconn.mserverVersion <= 4) {
            this.handleV4Callback(evt);
        } else {
            this.handleV5Callback(evt);
        }
    }

    /*
     * Unable to fully structure code
     */
    void handleV4Callback(CalEvent evt) {
        done = false;
        if ((this.mevents & 56) != 0) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            System.err.println("doing insert, sleep");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception v0) {}
lbl9:
            // 3 sources

            ** while (this.mdoingInsert)
        }
lbl10:
        // 1 sources

        try {
            if (this.delInsertedId(evt.getId())) {
                done = true;
            } else if (!done && this.delDeletedId(evt.getId())) {
                done = true;
            } else if (!done && this.delUpdatedId(evt.getId())) {
                done = true;
            }
            if (done) {
                System.err.println("event triggered by us, ignored");
                return;
            }
            if ((this.mevents & 8) > 0) {
                System.err.println("handle ENTRY_ADDED for " + evt.getId());
                this.mhandler.entryAdded(evt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    void handleV5Callback(CalEvent evt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void init(String host, String name, boolean create, AuthUser authUser) throws CalendarException {
        if (host == null || host.equals("") || name == null || name.equals("")) {
            throw new CalendarException(19, "calendar address is null");
        }
        this.mloc = host;
        this.mname = name;
        this.authenticatedUser = authUser;
        this.maddr = String.valueOf(this.mname) + '@' + this.mloc;
        this.mLocale = Locale.getDefault();
        if (Debug.on) {
            System.err.println("Before getConnection in init");
        }
        this.mconn = CmsdConnection.getConnection(this.mloc, this);
        if (Debug.on) {
            System.err.println("After getConnection in init");
        }
        if (Debug.on) {
            System.err.println("Before open in init");
        }
        this.open(create);
        if (Debug.on) {
            System.err.println("After open in init");
        }
        if (Debug.on) {
            System.err.println("created Calendar object for " + this.mname + "@" + this.mloc);
        }
    }

    public Appointment insertAppt(Appointment appt) throws CalendarException {
        if (!this.meditable) {
            throw new CalendarException(3, "No write access");
        }
        if (appt == null) {
            throw new CalendarException(19, "Appointment object cannot be null");
        }
        if (this.msetEntryCharSet) {
            appt.setLocale(this.mLocale);
        }
        try {
            try {
                this.mdoingInsert = true;
                Appointment a = this.mconn.insertEntry(appt);
                if (a != null) {
                    this.addInsertedId(a.getIdentifier());
                }
                Appointment appointment = a;
                Object var4_5 = null;
                this.mdoingInsert = false;
                return appointment;
            }
            catch (Exception e) {
                if (e instanceof CalendarException) {
                    throw (CalendarException)e;
                }
                throw new CalendarException(0);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.mdoingInsert = false;
            throw throwable;
        }
    }

    public boolean isOwner() {
        return this.mconn.maccess.isOwner();
    }

    public boolean justCreated() {
        return this.justCreated;
    }

    public Appointment lookupAppointment(int id, Date day) throws CalendarException {
        if (id <= 0) {
            throw new CalendarException(19, "id<=0 specified as an argument");
        }
        if (day == null) {
            throw new CalendarException(19, "day=null specified as argument");
        }
        LookupCriteria lc = new LookupCriteria(2);
        lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN", new DateTimeValue(day)));
        lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN", new OpaqueDataValue(new OpaqueData(this.toNullEndedByteArray(Integer.toString(id).getBytes())))));
        int attempts = 5;
        Appointment[] appts = null;
        while ((appts == null || appts.length == 0) && attempts > 0) {
            appts = this.lookupAppointments(lc);
            --attempts;
        }
        return appts == null || appts.length == 0 ? null : appts[0];
    }

    public Appointment[] lookupAppointments(Date day) throws CalendarException {
        return this.lookupAppointments(day, TimeZone.getDefault());
    }

    public Appointment[] lookupAppointments(Date start, Date end) throws CalendarException {
        return this.lookupAppointments(start, end, TimeZone.getDefault());
    }

    public Appointment[] lookupAppointments(Date start, Date end, TimeZone tz) throws CalendarException {
        if (start == null || end == null) {
            throw new CalendarException(19, "null specified as arguments");
        }
        LookupCriteria lc = new LookupCriteria(3);
        lc.addCriterion(5, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN", new DateTimeValue(start, tz)));
        lc.addCriterion(6, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN", new DateTimeValue(end, tz)));
        return this.lookupAppointments(lc);
    }

    public Appointment[] lookupAppointments(Date day, TimeZone tz) throws CalendarException {
        java.util.Calendar start = java.util.Calendar.getInstance(tz);
        java.util.Calendar end = java.util.Calendar.getInstance(tz);
        start.setTime(day);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        end.setTime(day);
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        return this.lookupAppointments(start.getTime(), end.getTime(), tz);
    }

    public Appointment[] lookupAppointments(LookupCriteria lc) throws CalendarException {
        if (lc == null || lc.getSize() == 0) {
            throw new CalendarException(19, "must specify at least one criterion.");
        }
        LookupCriteria nlc = new LookupCriteria(lc);
        nlc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Type//EN", new Uint32Value(0L)));
        return this.mconn.lookupEntries(nlc);
    }

    public Appointment lookupApptById(int id) throws CalendarException {
        if (id <= 0) {
            throw new CalendarException(19, "null specified as arguments");
        }
        LookupCriteria lc = new LookupCriteria(2);
        lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN", new OpaqueDataValue(new OpaqueData(this.toNullEndedByteArray(Integer.toString(id).getBytes())))));
        Appointment[] appts = this.lookupAppointments(lc);
        if (appts == null || appts.length == 0) {
            return null;
        }
        return appts[0];
    }

    void open() throws CalendarException {
        Attribute[] attrs = this.mconn.openCalendar();
        this.cacheAttrs(attrs);
        this.meditable = this.mconn.maccess.isEditor();
    }

    void open(boolean create) throws CalendarException {
        try {
            this.open();
        }
        catch (CalendarException e) {
            if (e.mcode == 1 && create) {
                this.mconn.createCalendar();
                this.justCreated = true;
                this.open();
            }
            throw e;
        }
    }

    CsaAccessEntry removeEntry(Vector users, String name) {
        if (users == null || users.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < users.size()) {
            CsaAccessEntry entry = (CsaAccessEntry)users.elementAt(i);
            if (name.equals(entry.getUser())) {
                users.removeElement(entry);
                return entry;
            }
            ++i;
        }
        return null;
    }

    synchronized void resetAccessObject() {
        this.maccess = null;
    }

    public void setCalendarAccess(AccessEntry[] entries, String[] hosts) throws CalendarException {
        try {
            this.mconn.setAccessList(this.getAccessObject().getCsaAccessEntries(entries, hosts));
        }
        finally {
            Object var4_3 = null;
            this.resetAccessObject();
        }
    }

    public void setEventHandler(CalEventHandler h) throws CalendarException {
        int newevts = 0;
        if (Debug.on) {
            System.err.println("Calendar.setEventHandler: mhandler=" + (this.mhandler == null ? "null" : "not null") + ", mevents=" + this.mevents);
        }
        if (h == null) {
            if (Debug.on) {
                System.err.println("Calendar.setEventHandler: h = null");
            }
            if (this.mhandler != null) {
                if (!this.isOwner() || !this.mcbEnabled) {
                    ProxyClient.unregister(this);
                }
                this.mhandler = null;
                this.mevents = 0;
                if (Debug.on) {
                    System.err.println("Calendar: unregistered callback");
                }
            }
        } else {
            newevts = h.getEventsInterested();
            if (((this.mevents | newevts) ^ this.mevents) != 0) {
                ProxyClient.register(newevts, this);
                if (Debug.on) {
                    System.err.println("Calendar: registered events:" + newevts);
                }
            }
            this.mhandler = h;
            this.mevents = newevts;
        }
    }

    private byte[] toNullEndedByteArray(byte[] inarray) {
        int len = inarray.length;
        byte[] outarray = new byte[len + 1];
        int i = 0;
        while (i < len) {
            outarray[i] = inarray[i];
            ++i;
        }
        outarray[len] = 0;
        return outarray;
    }

    ReminderRef[] toReminderRef(cms_reminder_ref refs) throws CalendarException {
        Vector<ReminderRef> vf = new Vector<ReminderRef>(1);
        cms_reminder_ref ptr = refs;
        while (ptr != null) {
            cms_reminder_ref ptr2 = refs;
            while (ptr2 != ptr) {
                if (ptr.key.id.data == ptr2.key.id.data) break;
                ptr2 = ptr2.next;
            }
            if (ptr == ptr2) {
                LookupCriteria lc = new LookupCriteria();
                lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN", new OpaqueDataValue(new OpaqueData(this.toNullEndedByteArray(ptr.entryid.val.getBytes())))));
                lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN", new DateTimeValue(new Date((long)ptr.key.time.data * 1000L))));
                Appointment[] appts = this.lookupAppointments(lc);
                if (Debug.on && appts == null) {
                    System.err.println("toReminderRef: no appt returned for id " + ptr.entryid.val);
                }
                if (appts != null && appts.length > 0) {
                    ReminderRef remRef = new ReminderRef((long)ptr.runtime.data * 1000L);
                    remRef.setAppointment(appts[0]);
                    vf.addElement(remRef);
                    appts[0] = null;
                }
            }
            ptr = ptr.next;
        }
        if (vf.size() > 0) {
            Object[] array = new ReminderRef[vf.size()];
            vf.copyInto(array);
            return array;
        }
        return null;
    }

    public Appointment updateAppt(Appointment appt) throws CalendarException {
        return this.updateAppt(appt, new Scope(0));
    }

    public Appointment updateAppt(Appointment appt, Scope scope) throws CalendarException {
        if (!this.meditable) {
            throw new CalendarException(3, "No write access");
        }
        if (appt == null) {
            throw new CalendarException(19, "Appointment object cannot be null");
        }
        if (appt.getCookie() != this) {
            throw new CalendarException(19, "Appointment is not returned by this Calendar object.");
        }
        if (scope == null) {
            scope = new Scope(0);
        }
        this.addUpdatedId(appt.getIdentifier());
        return this.mconn.updateEntry(appt, scope);
    }
}

