/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.cmsd4.Registration;
import sunw.jdt.cal.cmsd4.Registration_Status;
import sunw.jdt.cal.cmsd5.cms_register_args;
import sunw.jdt.cal.cmsd5.cms_return_code;
import sunw.jdt.cal.cmsd5.int32;
import sunw.jdt.cal.cmsd5.uint32;
import sunw.jdt.cal.csa.CBListener;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.CmsdClient;
import sunw.jdt.cal.csa.Connection;
import sunw.jdt.cal.csa.CsaReturnCode;
import sunw.jdt.cal.csa.RpcCBHandler;
import sunw.jdt.cal.rpc.Buffer;

public class CalServer {
    static final int PID = 1;

    public static void V4Register(Connection conn, String calname, int events, RpcCBHandler h) throws CalendarException {
        Registration_Status res = new Registration_Status();
        CBListener l = CBListener.getListener(1, h);
        if (l == null) {
            throw new CalendarException(10, "no callback server");
        }
        Registration args = new Registration();
        args.target = new Buffer(calname);
        args.prognum = l.getProgNum();
        args.versnum = 1L;
        args.procnum = 1L;
        args.pid = 1;
        args.next = null;
        try {
            conn.svc4.register_callback(args, res);
            if (res.value != 0) {
                throw new CalendarException(10, "register_callback failed");
            }
        }
        catch (Exception e) {
            if (e instanceof CalendarException) {
                throw (CalendarException)e;
            }
            throw new CalendarException(10, "register_callback failed");
        }
    }

    public static void V4Unregister(Connection conn, String calname, int events, RpcCBHandler h) throws CalendarException {
        Registration_Status res = new Registration_Status();
        CBListener l = CBListener.getListener(1, h);
        if (l == null) {
            throw new CalendarException(10, "no callback server");
        }
        Registration args = new Registration();
        args.target = new Buffer(calname);
        args.prognum = l.getProgNum();
        args.versnum = 1L;
        args.procnum = 1L;
        args.pid = 1;
        args.next = null;
        try {
            conn.svc4.deregister_callback(args, res);
            if (res.value != 2) {
                throw new CalendarException(10, "register_callback failed");
            }
        }
        catch (Exception e) {
            if (e instanceof CalendarException) {
                throw (CalendarException)e;
            }
            throw new CalendarException(10, "register_callback failed");
        }
    }

    public static void V5Register(Connection conn, String calname, int events, RpcCBHandler h) throws CalendarException {
        cms_return_code res = new cms_return_code();
        CBListener l = CBListener.getListener(2, h);
        if (l == null) {
            throw new CalendarException(10, "no callback server");
        }
        cms_register_args args = new cms_register_args();
        args.cal = new Buffer(calname);
        args.update_type = new uint32(events);
        args.prognum = new uint32(l.getProgNum());
        args.versnum = new uint32(2L);
        args.procnum = new uint32(1L);
        args.pid = new int32(1);
        try {
            conn.svc5.CMS_REGISTER(args, res);
            if (res.data != 0L) {
                throw CsaReturnCode.toCalendarException((int)res.data);
            }
        }
        catch (Exception e) {
            if (e instanceof CalendarException) {
                throw (CalendarException)e;
            }
            throw new CalendarException(10, "CMS_REGISTER failed");
        }
    }

    public static void V5Unregister(Connection conn, String calname, int events, RpcCBHandler h) throws CalendarException {
        cms_return_code res = new cms_return_code();
        CBListener l = CBListener.getListener(2, h);
        if (l == null) {
            throw new CalendarException(10, "no callback server");
        }
        cms_register_args args = new cms_register_args();
        args.cal = new Buffer(calname);
        args.update_type = new uint32(events);
        args.prognum = new uint32(l.getProgNum());
        args.versnum = new uint32(2L);
        args.procnum = new uint32(1L);
        args.pid = new int32(1);
        try {
            conn.svc5.CMS_UNREGISTER(args, res);
            if (res.data != 0L) {
                throw CsaReturnCode.toCalendarException((int)res.data);
            }
        }
        catch (Exception e) {
            if (e instanceof CalendarException) {
                throw (CalendarException)e;
            }
            throw new CalendarException(10, "CMS_UNREGISTER failed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void register(String calname, int events, RpcCBHandler h) throws CalendarException {
        Connection conn = null;
        String server = calname.substring(calname.indexOf(64) + 1);
        try {
            try {
                conn = CmsdClient.getConnection(server, null);
                if (conn.svc5 != null) {
                    CalServer.V5Register(conn, calname, events, h);
                } else {
                    if (conn.svc4 == null) throw new CalendarException(10, "no server connection");
                    CalServer.V4Register(conn, calname, events, h);
                }
            }
            catch (Exception e) {
                if (!(e instanceof CalendarException)) throw new CalendarException(10, "failed to register with server");
                throw (CalendarException)e;
            }
            Object var6_8 = null;
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            conn.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unregister(String calname, int events, RpcCBHandler h) throws CalendarException {
        Connection conn = null;
        String server = calname.substring(calname.indexOf(64) + 1);
        try {
            try {
                conn = CmsdClient.getConnection(server, null);
                if (conn.svc5 != null) {
                    CalServer.V5Unregister(conn, calname, events, h);
                } else {
                    if (conn.svc4 == null) throw new CalendarException(10, "no server connection");
                    CalServer.V4Unregister(conn, calname, events, h);
                }
            }
            catch (Exception e) {
                if (!(e instanceof CalendarException)) throw new CalendarException(10, "failed to unregister with server");
                throw (CalendarException)e;
            }
            Object var6_8 = null;
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            conn.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

