/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import sunw.jdt.cal.csa.CalEventType;
import sunw.jdt.cal.csa.CalendarException;

public class CalEvent
implements CalEventType {
    String mhost;
    int mtype;
    String mname;
    String mcalendar;
    String muser;
    int mid;
    boolean mrepeats = false;
    int mnewid;
    String[] mattrs;
    int mscope;
    int mtime;
    int mversion;

    public CalEvent(String host, int version, int type, String cal, String user) {
        this.mhost = host;
        this.mversion = version;
        this.mtype = type;
        this.mcalendar = cal;
        this.muser = user;
        this.toEventName();
    }

    public CalEvent(CalEvent evt) {
        this.mversion = evt.mversion;
        this.mtype = evt.mtype;
        this.mname = evt.mname;
        this.mcalendar = evt.mcalendar;
        this.muser = evt.muser;
        this.mid = evt.mid;
        this.mrepeats = evt.mrepeats;
        this.mnewid = evt.mnewid;
        this.mscope = evt.mscope;
        this.mtime = evt.mtime;
        if (evt.mattrs != null) {
            this.mattrs = new String[evt.mattrs.length];
            int i = 0;
            while (i < evt.mattrs.length) {
                this.mattrs[i] = evt.mattrs[i];
                ++i;
            }
        }
    }

    public String getCalendar() {
        return this.mcalendar;
    }

    public Date getDate() throws CalendarException {
        if (this.mtype == 8 || this.mtype == 32 || this.mtype == 16) {
            return new Date((long)this.mtime * 1000L);
        }
        throw new CalendarException(18, "data does not exist for the event");
    }

    public int getEvent() {
        return this.mtype;
    }

    public String getEventName() {
        return this.mname;
    }

    public String getHost() {
        return this.mhost;
    }

    public int getId() throws CalendarException {
        if ((this.mtype & 0x38) > 0) {
            return this.mid;
        }
        throw new CalendarException(18, "data does not exist for the event");
    }

    public String[] getNames() throws CalendarException {
        if (this.mtype == 4) {
            return this.mattrs;
        }
        throw new CalendarException(18, "data does not exist for the event");
    }

    public int getNewId() throws CalendarException {
        if (this.mtype == 32) {
            return this.mnewid;
        }
        throw new CalendarException(18, "data does not exist for the event");
    }

    public boolean getRepeats() {
        return this.mrepeats;
    }

    public int getScope() throws CalendarException {
        if (this.mtype == 32 || this.mtype == 16) {
            return this.mscope;
        }
        throw new CalendarException(18, "data does not exist for the event");
    }

    public String getUser() {
        return this.muser;
    }

    public int getVersion() {
        return this.mversion;
    }

    public void print() {
        System.out.println("Calendar Event: " + this.mname + "(" + this.mtype + ")");
        System.out.println("calendar = " + this.mcalendar);
        System.out.println("user = " + this.muser);
        switch (this.mtype) {
            case 8: {
                System.out.println("id = " + this.mid);
                break;
            }
            case 16: {
                System.out.println("id = " + this.mid);
                System.out.println("scope = " + this.mscope);
                System.out.println("time = " + new Date((long)this.mtime * 1000L));
                break;
            }
            case 32: {
                System.out.println("old id = " + this.mid);
                System.out.println("new id = " + this.mnewid);
                System.out.println("scope = " + this.mscope);
                System.out.println("time = " + new Date((long)this.mtime * 1000L));
                break;
            }
        }
    }

    public void setId(int id) {
        this.mid = id;
    }

    public void setNames(String[] names) {
        this.mattrs = names;
    }

    public void setNewId(int id) {
        this.mnewid = id;
    }

    public void setRepeats(boolean r) {
        this.mrepeats = r;
    }

    public void setScope(int scope) {
        this.mscope = scope;
    }

    public void setTime(int time) {
        this.mtime = time;
    }

    void toEventName() {
        switch (this.mtype) {
            case 1: {
                this.mname = "CALENDAR_LOGON";
                break;
            }
            case 2: {
                this.mname = "CALENDAR_DELETED";
                break;
            }
            case 4: {
                this.mname = "CALENDAR_ATTRIBUTE_UPDATED";
                break;
            }
            case 8: {
                this.mname = "ENTRY_ADDED";
                break;
            }
            case 16: {
                this.mname = "ENTRY_DELETED";
                break;
            }
            case 32: {
                this.mname = "ENTRY_UPDATED";
                break;
            }
        }
    }
}

