/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import sunw.jdt.cal.csa.CBSvrV1;
import sunw.jdt.cal.csa.CBSvrV2;
import sunw.jdt.cal.csa.RpcCBHandler;
import sunw.jdt.cal.rpc.rpc_server_dg;
import sunw.jdt.cal.util.Debug;

public class CBListener {
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    public static final int PROCNUM = 1;
    static Hashtable servers = new Hashtable();
    int mprognum = 0x48000000;
    rpc_server_dg mserver = null;

    public CBListener(int version, RpcCBHandler h) throws IOException {
        while (true) {
            try {
                this.mserver = version == 1 ? new rpc_server_dg(this.mprognum, 1L, new CBSvrV1(h)) : new rpc_server_dg(this.mprognum, 2L, new CBSvrV2(h));
                this.mserver.start();
                if (!Debug.on) break;
                System.out.println("CBListener: prog number = " + this.mprognum);
            }
            catch (IOException e) {
                if (Debug.on) {
                    System.err.println("serv: got exception, " + e.toString());
                }
                if (e.getMessage().equals("pm_register.setport: failed")) {
                    if (Debug.on) {
                        System.err.println("retry with new program number");
                    }
                    ++this.mprognum;
                    continue;
                }
                if (Debug.on) {
                    System.err.println("no retry with new program number, throw exception");
                }
                throw e;
            }
            break;
        }
    }

    static void cleanup() {
        Hashtable hashtable = servers;
        synchronized (hashtable) {
            Enumeration e = servers.elements();
            while (e.hasMoreElements()) {
                CBListener l = (CBListener)e.nextElement();
                l.done();
            }
            servers.clear();
        }
    }

    void done() {
        this.mserver.stop();
    }

    public static CBListener getListener(int version, RpcCBHandler h) {
        Integer num = new Integer(version);
        Hashtable hashtable = servers;
        synchronized (hashtable) {
            CBListener l = (CBListener)servers.get(num);
            if (l == null) {
                if (Debug.on) {
                    System.out.println("invoking CBListener for version " + version);
                }
                try {
                    l = new CBListener(version, h);
                    servers.put(num, l);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CBListener cBListener = null;
                    Object var6_8 = null;
                    return cBListener;
                }
            }
            CBListener cBListener = l;
            Object var6_9 = null;
            return cBListener;
        }
    }

    public int getProgNum() {
        return this.mprognum;
    }
}

