/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.cmsd5.cms_attr_name;
import sunw.jdt.cal.cmsd5.cms_attribute;
import sunw.jdt.cal.cmsd5.cms_attribute_value;
import sunw.jdt.cal.csa.AccessListValue;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.BooleanValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.DateTimeListValue;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.OpaqueDataValue;
import sunw.jdt.cal.csa.ReminderValue;
import sunw.jdt.cal.csa.Sint32Value;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.csa.UserValue;
import sunw.jdt.cal.rpc.Buffer;
import sunw.jdt.cal.util.Debug;

public class Attribute
implements Cloneable {
    protected String mname;
    protected AttributeValue mvalue;

    public Attribute(String name) {
        this.mname = name;
    }

    public Attribute(String name, AttributeValue value) {
        this.mname = name;
        this.mvalue = value;
    }

    public Object clone() {
        Attribute v = new Attribute(this.mname, (AttributeValue)this.mvalue.clone());
        return v;
    }

    public String getName() {
        return this.mname;
    }

    public AttributeValue getValue() {
        return this.mvalue;
    }

    public void print() {
        System.out.println("name = " + this.mname);
        if (this.mvalue == null) {
            System.out.println("null value");
        } else {
            this.mvalue.print();
        }
    }

    public AttributeValue setValue(AttributeValue value) throws CalendarException {
        AttributeValue old = this.mvalue;
        this.mvalue = value;
        return old;
    }

    protected static Attribute toAttribute(cms_attribute cms) throws CalendarException {
        Attribute attr = new Attribute(cms.name.name.val);
        attr.setValue(Attribute.toAttributeValue(cms.value));
        return attr;
    }

    protected static AttributeValue toAttributeValue(cms_attribute_value v) throws CalendarException {
        if (v == null) {
            return null;
        }
        AttributeValue value = null;
        switch (v.type.value) {
            case 3: {
                value = new Sint32Value(v);
                break;
            }
            case 4: {
                value = new Uint32Value(v);
                break;
            }
            case 5: {
                value = new StringValue(v);
                break;
            }
            case 6: {
                value = new UserValue(v);
                break;
            }
            case 7: {
                value = new DateTimeValue(v);
                break;
            }
            case 0: {
                value = new BooleanValue(v);
                break;
            }
            case 14: {
                value = new OpaqueDataValue(v);
                break;
            }
            case 13: {
                value = new ReminderValue(v);
                break;
            }
            case 10: {
                value = new AccessListValue(v);
                break;
            }
            case 12: {
                value = new DateTimeListValue(v);
                break;
            }
            default: {
                if (!Debug.on) break;
                System.out.println(String.valueOf(v.type.value) + " not supported yet");
            }
        }
        return value;
    }

    public static Attribute[] toAttributes(cms_attribute[] cmsAttrs) throws CalendarException {
        if (cmsAttrs == null) {
            return null;
        }
        Attribute[] attrs = new Attribute[cmsAttrs.length];
        int i = 0;
        while (i < cmsAttrs.length) {
            if (cmsAttrs[i] != null) {
                attrs[i] = Attribute.toAttribute(cmsAttrs[i]);
            }
            ++i;
        }
        return attrs;
    }

    public cms_attribute toCmsAttribute() {
        cms_attribute cmsAttr = new cms_attribute();
        cmsAttr.name = new cms_attr_name();
        cmsAttr.name.num = 0;
        cmsAttr.name.name = new Buffer(this.mname);
        if (this.mvalue != null) {
            cmsAttr.value = this.mvalue.toCmsValue();
        }
        return cmsAttr;
    }
}

