/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Classification;
import sunw.jdt.cal.csa.DateTimeListValue;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.Entry;
import sunw.jdt.cal.csa.EntryAttribute;
import sunw.jdt.cal.csa.Iso8601;
import sunw.jdt.cal.csa.LocaleXlateTable;
import sunw.jdt.cal.csa.OpaqueDataValue;
import sunw.jdt.cal.csa.Reminder;
import sunw.jdt.cal.csa.ReminderValue;
import sunw.jdt.cal.csa.Repeat;
import sunw.jdt.cal.csa.Sint32Value;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.csa.UserValue;
import sunw.jdt.cal.csa.X_sun_ae_file_const;

public class Appointment
implements X_sun_ae_file_const {
    Entry mentry;
    Repeat mrepeat;
    Date mstart;
    Date mend = null;
    boolean mrepeatChanged = false;
    Locale _locale = null;

    Appointment() {
        this.mentry = null;
    }

    public Appointment(Date start) throws CalendarException {
        this(start, null);
    }

    public Appointment(Date start, Date end) throws CalendarException {
        if (start == null) {
            System.out.println("Appointment() - null start date!");
            Thread.currentThread();
            Thread.dumpStack();
            throw new CalendarException(19, "start date cannot take null value");
        }
        this.mentry = new Entry();
        this.mentry.setAttribute(new EntryAttribute(27, (AttributeValue)new Uint32Value(0L)));
        this.mentry.setAttribute(new EntryAttribute(24, (AttributeValue)new StringValue("-//XAPIA/CSA/SUBTYPE//NONSGML Subtype Appointment//EN")));
        this.mentry.setAttribute(new EntryAttribute(22, (AttributeValue)new DateTimeValue(start)));
        this.mentry.setAttribute(new EntryAttribute(2, (AttributeValue)new Uint32Value(0L)));
        this.mentry.setAttribute(new EntryAttribute(25, (AttributeValue)new StringValue("")));
        this.mentry.setAttribute(new EntryAttribute(28, (AttributeValue)new Sint32Value(1)));
        this.mentry.setAttribute(new EntryAttribute(29, (AttributeValue)new Sint32Value(0)));
        this.mrepeat = new Repeat();
        this.mstart = new Date(start.getTime());
        if (end != null) {
            this.setEndDate(end);
        }
    }

    Appointment(Entry entry) {
        int type;
        AttributeValue vtimes = null;
        this.mentry = entry;
        this.mstart = this.getStartDate();
        EntryAttribute a = this.mentry.getAttribute(7);
        if (a != null) {
            this.mend = ((DateTimeValue)a.getValue()).getDate();
        }
        if ((type = ((Sint32Value)this.mentry.getAttribute(29).getValue()).getInt()) == 0) {
            this.mrepeat = new Repeat();
            return;
        }
        AttributeValue vnum = this.mentry.getAttributeValue(13);
        if (vnum == null || type >= 10 && type <= 12) {
            vtimes = this.mentry.getAttributeValue(30);
        }
        int times = vtimes != null ? (int)((Uint32Value)vtimes).getLong() : (int)((Uint32Value)vnum).getLong();
        try {
            String rrString;
            StringValue rr;
            this.mrepeat = new Repeat(type, times);
            vnum = this.mentry.getAttributeValue("-//CDE_XAPIA_PRIVATE/CSA/ENTRYATTR//NONSGML Repeat Interval//EN");
            if (vnum != null) {
                this.mrepeat.setFrequency((int)((Uint32Value)vnum).getLong());
            }
            if (type == 4 && (rr = (StringValue)this.mentry.getAttributeValue(17)) != null && (rrString = rr.getString()) != null && rrString.indexOf("1-") != -1) {
                this.mrepeat.setLastWeek(true);
            }
        }
        catch (CalendarException e) {
            System.out.println(e.toString());
            System.out.println("invalid repeat info from back end");
        }
    }

    public Object clone() {
        Appointment appt;
        block2: {
            appt = new Appointment(new Entry(this.mentry));
            if (!this.mrepeatChanged) break block2;
            try {
                appt.setRepeat(new Repeat(this.mrepeat));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return appt;
    }

    String formatTime(Calendar cal) {
        int hr = cal.get(11);
        String time = hr == 0 ? "12:" + this.toMinString(cal.get(12)) + "am" : (hr < 12 ? String.valueOf(hr) + ":" + this.toMinString(cal.get(12)) + "am" : (hr == 12 ? String.valueOf(hr) + ":" + this.toMinString(cal.get(12)) + "pm" : String.valueOf(hr - 12) + ":" + this.toMinString(cal.get(12)) + "pm"));
        return time;
    }

    public Date getApptEndDate() {
        String dateStr;
        int sIndex;
        StringValue rr = (StringValue)this.mentry.getAttributeValue(17);
        if (rr == null) {
            return null;
        }
        String rrString = rr.getString();
        if (rrString.endsWith("Z") && ((sIndex = rrString.lastIndexOf("19")) != -1 || (sIndex = rrString.lastIndexOf("20")) != -1) && (dateStr = rrString.substring(sIndex)) != null && dateStr.length() == 16 && dateStr.indexOf("T") == 8) {
            Date date = null;
            try {
                date = Iso8601.toDate(dateStr);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(5, -1);
                cal.add(13, 2);
                date = cal.getTime();
            }
            catch (CalendarException e) {
                System.out.println(e.toString());
                System.out.println("cant convert UTC date to Date");
            }
            return date;
        }
        return null;
    }

    public String getCharset() {
        if (this.mentry != null) {
            return this.mentry.getCharset();
        }
        return null;
    }

    public Classification getClassification() {
        long value = ((Uint32Value)this.mentry.getAttribute(2).getValue()).getLong();
        try {
            return new Classification((int)value);
        }
        catch (CalendarException e) {
            System.out.println(e.toString());
            return new Classification();
        }
    }

    Object getCookie() {
        return this.mentry.mcal;
    }

    public Date getDateCreated() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(4);
        if (a != null && (v = a.getValue()) != null) {
            return ((DateTimeValue)v).getDate();
        }
        return null;
    }

    public Date getEndDate() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(7);
        if (a != null && (v = a.getValue()) != null) {
            return ((DateTimeValue)v).getDate();
        }
        return null;
    }

    public Vector getExceptionDates() {
        AttributeValue v;
        EntryAttribute a;
        Vector dates = null;
        if (this.mentry != null && (a = this.mentry.getAttribute(8)) != null && (v = a.getValue()) != null) {
            dates = ((DateTimeListValue)v).getDateVector();
        }
        return dates;
    }

    public int getIdentifier() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(19);
        if (a != null && (v = a.getValue()) != null) {
            byte[] b = ((OpaqueDataValue)a.getValue()).getOpaqueData().mbytes;
            String str = new String(b);
            int index = str.indexOf(":");
            return Integer.parseInt(str.substring(0, index));
        }
        return 0;
    }

    public String getMailId() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(36);
        if (a != null && (v = a.getValue()) != null) {
            return ((StringValue)v).getString();
        }
        return null;
    }

    public Date getModificationDate() {
        AttributeValue v;
        EntryAttribute a;
        if (this.mentry != null && (a = this.mentry.getAttribute(11)) != null && (v = a.getValue()) != null) {
            return ((DateTimeValue)v).getDate();
        }
        return null;
    }

    public String getOrganizer() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(14);
        if (a != null && (v = a.getValue()) != null) {
            return ((UserValue)v).getString();
        }
        return null;
    }

    public Reminder getReminder() {
        AttributeValue v;
        EntryAttribute a = this.mentry.getAttribute(1);
        if (a != null && (v = a.getValue()) != null) {
            return ((ReminderValue)v).getReminder();
        }
        a = this.mentry.getAttribute(15);
        if (a != null && (v = a.getValue()) != null) {
            return ((ReminderValue)v).getReminder();
        }
        return null;
    }

    public Repeat getRepeat() {
        return this.mrepeat;
    }

    public boolean getShowTime() {
        int value = ((Sint32Value)this.mentry.getAttribute(28).getValue()).getInt();
        return value != 0;
    }

    public Date getStartDate() {
        return ((DateTimeValue)this.mentry.getAttribute(22).getValue()).getDate();
    }

    public String getSummary() {
        return ((StringValue)this.mentry.getAttribute(25).getValue()).getString();
    }

    String massageSummary(String str) {
        int n = -1;
        int count = 1;
        StringBuffer buf = new StringBuffer(str);
        while ((n = str.indexOf("\n", n + 1)) != -1) {
            buf.insert(n + count++, '\t');
        }
        return buf.toString();
    }

    void prepareForInsert() throws CalendarException {
        String cdelocale = null;
        if (this.getCharset() != null) {
            cdelocale = this.getCharset();
        } else if (this._locale != null) {
            cdelocale = LocaleXlateTable.getCDELocale(this._locale);
        }
        if (cdelocale != null) {
            this.mentry.setAttribute(new EntryAttribute(35, (AttributeValue)new StringValue(cdelocale)));
            if (this.getSummary() != null) {
                this.setSummary(this.getSummary(), cdelocale);
            }
        }
        this.prepareYourself();
    }

    void prepareForUpdate() throws CalendarException {
        this.prepareYourself();
    }

    void prepareYourself() throws CalendarException {
        if (!this.mrepeatChanged) {
            return;
        }
        this.mentry.setAttributeValue(29, new Sint32Value(this.mrepeat.getType()));
        if (this.mrepeat.repeats()) {
            this.mentry.setAttributeValue(30, new Uint32Value(this.mrepeat.getTimes()));
            this.mentry.setAttributeValue(31, new Uint32Value(this.mrepeat.getFrequency()));
            if (this.mrepeat.getType() == 4 && this.mrepeat.mlastWeek) {
                this.mentry.setAttributeValue(32, new Sint32Value(-1));
            }
        }
    }

    public void print() {
        this.mentry.print();
    }

    public void setCharset(String charset) {
        if (this.mentry != null) {
            this.mentry.setCharset(charset);
        }
    }

    public Classification setClassification(Classification c) throws CalendarException {
        if (c == null) {
            throw new CalendarException(19, "classification cannot take null value");
        }
        AttributeValue v = this.mentry.setAttributeValue(2, new Uint32Value(c.getValue()));
        try {
            return new Classification((int)((Uint32Value)v).getLong());
        }
        catch (CalendarException calendarException) {
            return new Classification();
        }
    }

    public Date setEndDate(Date date) throws CalendarException {
        if (this.getShowTime() && date != null && date.before(this.mstart)) {
            throw new CalendarException(19, "Invalid End date.");
        }
        AttributeValue v = this.mentry.setAttributeValue(7, date != null ? new DateTimeValue(date) : null);
        this.mend = date != null ? new Date(date.getTime()) : null;
        if (v != null) {
            return ((DateTimeValue)v).getDate();
        }
        return null;
    }

    public void setExceptionDates(Date[] exceptionDates) throws CalendarException {
        if (this.mentry == null) {
            System.out.println("Appointment() - no appointment was created");
            Thread.currentThread();
            Thread.dumpStack();
            throw new CalendarException(29, "An instance of appointment has to be created first");
        }
        int ndate = exceptionDates.length;
        if (ndate > 0) {
            DateTimeValue[] dateTimeVals = new DateTimeValue[ndate];
            int i = 0;
            while (i < ndate) {
                dateTimeVals[i] = new DateTimeValue(exceptionDates[i]);
                ++i;
            }
            this.mentry.setAttribute(new EntryAttribute(8, (AttributeValue)new DateTimeListValue(dateTimeVals)));
        }
    }

    void setLocale(Locale locale) {
        this._locale = locale;
    }

    public String setMailId(String mailId) throws CalendarException {
        AttributeValue v = this.mentry.setAttributeValue(36, mailId != null ? new StringValue(mailId) : null);
        if (v != null) {
            return ((StringValue)v).getString();
        }
        return null;
    }

    public Reminder setReminder(Reminder reminder) throws CalendarException {
        AttributeValue old = this.mentry.setAttributeValue(1, reminder != null ? new ReminderValue(reminder) : null);
        AttributeValue v = this.mentry.setAttributeValue(15, reminder != null ? new ReminderValue(reminder) : null);
        if (old == null) {
            old = v;
        }
        if (old != null) {
            return ((ReminderValue)old).getReminder();
        }
        return null;
    }

    public Repeat setRepeat(Repeat r) throws CalendarException {
        if (r == null) {
            throw new CalendarException(19, "repeat information cannot take null value");
        }
        this.mrepeatChanged = true;
        Repeat old = this.mrepeat;
        this.mrepeat = r;
        return old;
    }

    public boolean setShowTime(boolean s) throws CalendarException {
        Sint32Value sv = new Sint32Value(s ? 1 : 0);
        int v = ((Sint32Value)this.mentry.setAttributeValue(28, sv)).getInt();
        return v != 0;
    }

    public void setStartAndEndDate(Date start, Date end) throws CalendarException {
        if (start == null) {
            throw new CalendarException(19, "start date cannot take null value");
        }
        if (end != null && end.before(start)) {
            throw new CalendarException(19, "Invalid End date.");
        }
        AttributeValue v = this.mentry.setAttributeValue(22, new DateTimeValue(start));
        this.mstart.setTime(start.getTime());
        v = this.mentry.setAttributeValue(7, end != null ? new DateTimeValue(end) : null);
        this.mend = end != null ? new Date(end.getTime()) : null;
    }

    public Date setStartDate(Date date) throws CalendarException {
        if (date == null) {
            throw new CalendarException(19, "start date cannot take null value");
        }
        if (this.getShowTime() && this.mend != null && date.after(this.mend)) {
            throw new CalendarException(19, "Invalid Start date.");
        }
        AttributeValue v = this.mentry.setAttributeValue(22, new DateTimeValue(date));
        this.mstart.setTime(date.getTime());
        return ((DateTimeValue)v).getDate();
    }

    public String setSummary(String s) throws CalendarException {
        return this.setSummary(s, null);
    }

    public String setSummary(String s, String charset) throws CalendarException {
        if (s == null) {
            s = "";
        }
        StringValue summary = new StringValue(s);
        StringValue oldValue = (StringValue)this.mentry.setAttributeValue(25, summary);
        if (charset == null) {
            charset = this.getCharset();
        }
        if (charset != null) {
            String encoding = LocaleXlateTable.getEncoding(charset, true);
            summary.setEncoding(encoding);
        }
        return oldValue.getString();
    }

    static Appointment[] toAppointments(Entry[] e) {
        if (e == null) {
            return null;
        }
        Appointment[] appts = new Appointment[e.length];
        int i = 0;
        while (i < e.length) {
            appts[i] = new Appointment(e[i]);
            ++i;
        }
        return appts;
    }

    String toMinString(int min) {
        if (min == 0) {
            return "00";
        }
        return Integer.toString(min);
    }

    public String to_X_sun_ae_file_string() {
        Calendar cal = Calendar.getInstance();
        StringBuffer buf = new StringBuffer("\n\n\t** Calendar Appointment **");
        cal.setTime(this.mstart);
        buf.append("\n\tDate: " + (cal.get(2) + 1) + "/" + cal.get(5) + "/" + cal.get(1));
        buf.append("\n\tStart: ");
        if (this.getShowTime()) {
            buf.append(this.formatTime(cal));
        }
        if (this.getShowTime() && this.mend != null) {
            cal.setTime(this.mend);
            buf.append("\n\tEnd: ");
            buf.append(this.formatTime(cal));
        }
        buf.append("\n\tRepeat: " + this.mrepeat.getTypeString());
        if (this.mrepeat.repeats()) {
            buf.append("\n\tFor: ");
            try {
                int times = this.mrepeat.getTimes();
                if (times == 0) {
                    buf.append("forever");
                } else {
                    buf.append(times);
                }
            }
            catch (Exception exception) {}
        }
        buf.append("\n\tWhat: " + this.massageSummary(this.getSummary()) + "\n\n");
        return buf.toString();
    }
}

