/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunw.jdt.cal.csa.AccessEntry;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.Util;
import sunw.jdt.cal.util.Debug;

class AccessObject {
    static final int _GETID = 0;
    static final int _GETUSER = 1;
    static final int _GETDESC = 2;
    Calendar cal;
    Hashtable viewerHash;
    Hashtable editorHash;
    Vector ownerV;
    Vector othersV;
    Vector viewerV;
    Vector editorV;
    String loginuser;

    AccessObject(Calendar cal, CsaAccessEntry[] arr) {
        block12: {
            this.loginuser = null;
            this.cal = cal;
            this.othersV = new Vector();
            this.ownerV = new Vector();
            this.viewerV = new Vector();
            this.editorV = new Vector();
            this.viewerHash = new Hashtable();
            this.editorHash = new Hashtable();
            if (arr == null) {
                return;
            }
            try {
                this.loginuser = System.getProperty("user.name", null);
            }
            catch (Exception exception) {
                if (!Debug.on) break block12;
                System.err.println("Calendar: failed to get user.name property");
            }
        }
        int i = 0;
        while (i < arr.length) {
            Vector userV;
            String user = arr[i].getUser();
            String login = Util.getUserFromAddr(user);
            if (this.loginuser != null && this.loginuser.equals(login) && arr[i].isOwner()) {
                this.ownerV.addElement(arr[i]);
            } else if (AccessEntry.hasEditAccess(arr[i])) {
                userV = (Vector)this.editorHash.get(login);
                if (userV == null) {
                    userV = new Vector();
                    this.editorHash.put(login, userV);
                }
                userV.addElement(arr[i]);
                this.editorV.addElement(arr[i]);
            } else if (AccessEntry.hasViewAccess(arr[i])) {
                userV = (Vector)this.viewerHash.get(login);
                if (userV == null) {
                    userV = new Vector();
                    this.viewerHash.put(login, userV);
                }
                userV.addElement(arr[i]);
                this.viewerV.addElement(arr[i]);
            } else {
                this.othersV.addElement(arr[i]);
            }
            ++i;
        }
    }

    void addEntries(Vector list, AccessEntry e) {
        if (e.mhosts == null || e.mhosts.length == 0) {
            CsaAccessEntry entry = this.createAccessEntry(e.mlogin, e);
            if (entry != null) {
                list.addElement(entry);
            }
        } else {
            int i = 0;
            while (i < e.mhosts.length) {
                CsaAccessEntry entry = this.createAccessEntry(String.valueOf(e.mlogin) + "@" + e.mhosts[i], e);
                if (entry != null) {
                    list.addElement(entry);
                }
                ++i;
            }
        }
    }

    CsaAccessEntry createAccessEntry(String name, AccessEntry e) {
        CsaAccessEntry entry = null;
        if (this.cal.mconn.mdataVersion >= 4) {
            entry = new CsaAccessEntry(name, e.maccess);
            entry.mdesc = e.mdesc;
            entry.mid = e.mid;
        } else if (e.maccess == 2) {
            entry = new CsaAccessEntry(name, 1L);
        } else if (e.maccess == 1022) {
            entry = new CsaAccessEntry(name, 7L);
        }
        return entry;
    }

    CsaAccessEntry createOwnerEntry(String name) {
        if (this.cal.mconn.mdataVersion >= 4) {
            return new CsaAccessEntry(name, 32768L);
        }
        return new CsaAccessEntry(name, 7L);
    }

    CsaAccessEntry findEntryFromOldList(String name) {
        CsaAccessEntry entry;
        int i;
        int size;
        CsaAccessEntry match = null;
        if (!this.viewerV.isEmpty()) {
            size = this.viewerV.size();
            i = 0;
            while (i < size) {
                entry = (CsaAccessEntry)this.viewerV.elementAt(i);
                if (entry.muser.equals(name)) {
                    this.viewerV.removeElementAt(i);
                    match = entry;
                    break;
                }
                ++i;
            }
        }
        if (match == null && !this.editorV.isEmpty()) {
            size = this.editorV.size();
            i = 0;
            while (i < size) {
                entry = (CsaAccessEntry)this.editorV.elementAt(i);
                if (entry.muser.equals(name)) {
                    this.editorV.removeElementAt(i);
                    match = entry;
                    break;
                }
                ++i;
            }
        }
        if (match == null && !this.othersV.isEmpty()) {
            size = this.othersV.size();
            i = 0;
            while (i < size) {
                entry = (CsaAccessEntry)this.othersV.elementAt(i);
                if (entry.muser.equals(name)) {
                    this.othersV.removeElementAt(i);
                    match = entry;
                    break;
                }
                ++i;
            }
        }
        return match;
    }

    void fixEntry(CsaAccessEntry e) {
        int mask = -1023;
        CsaAccessEntry olde = this.findEntryFromOldList(e.muser);
        if (olde != null) {
            e.mrights |= (long)mask & olde.mrights;
        }
    }

    synchronized AccessEntry[] getAccessEntries() {
        Vector userV;
        Enumeration elems;
        Vector<AccessEntry> aeV = new Vector<AccessEntry>();
        if (!this.viewerHash.isEmpty()) {
            elems = this.viewerHash.elements();
            while (elems.hasMoreElements()) {
                userV = (Vector)elems.nextElement();
                aeV.addElement(new AccessEntry(userV, 2));
            }
        }
        if (!this.editorHash.isEmpty()) {
            elems = this.editorHash.elements();
            while (elems.hasMoreElements()) {
                userV = (Vector)elems.nextElement();
                aeV.addElement(new AccessEntry(userV, 1022));
            }
        }
        if (aeV.isEmpty()) {
            return null;
        }
        Object[] res = new AccessEntry[aeV.size()];
        aeV.copyInto(res);
        return res;
    }

    synchronized CsaAccessEntry[] getCsaAccessEntries(AccessEntry[] entries, String[] hosts) {
        CsaAccessEntry entry;
        int i;
        Vector newlist = new Vector();
        if (hosts != null && hosts.length > 0 && this.loginuser != null) {
            i = 0;
            while (i < hosts.length) {
                entry = this.createOwnerEntry(String.valueOf(this.loginuser) + "@" + hosts[i]);
                newlist.addElement(entry);
                ++i;
            }
        } else if (!this.ownerV.isEmpty()) {
            String user = ((CsaAccessEntry)this.ownerV.elementAt((int)0)).muser;
            user = Util.getUserFromAddr(user);
            entry = this.createOwnerEntry(user);
            newlist.addElement(entry);
        }
        if (entries != null) {
            i = 0;
            while (i < entries.length) {
                this.addEntries(newlist, entries[i]);
                ++i;
            }
        }
        if (newlist.isEmpty()) {
            newlist = this.othersV;
        } else if (this.cal.mconn.mdataVersion >= 4) {
            int size = newlist.size();
            i = 0;
            while (i < size) {
                entry = (CsaAccessEntry)newlist.elementAt(i);
                this.fixEntry(entry);
                ++i;
            }
            if (!this.othersV.isEmpty()) {
                size = this.othersV.size();
                i = 0;
                while (i < size) {
                    newlist.addElement(this.othersV.elementAt(i));
                    ++i;
                }
            }
        }
        if (newlist.isEmpty()) {
            return null;
        }
        Object[] e = new CsaAccessEntry[newlist.size()];
        newlist.copyInto(e);
        return e;
    }

    synchronized String[] getHostsForOwnerAccess() {
        Object[] hosts = null;
        boolean nohost = false;
        if (this.ownerV.isEmpty()) {
            return null;
        }
        Vector<String> hostV = new Vector<String>();
        Enumeration elems = this.ownerV.elements();
        while (elems.hasMoreElements()) {
            CsaAccessEntry e = (CsaAccessEntry)elems.nextElement();
            String host = Util.getHostFromAddr(e.muser);
            if (host == null) {
                nohost = true;
                break;
            }
            hostV.addElement(host);
        }
        if (!nohost && !hostV.isEmpty()) {
            hosts = new String[hostV.size()];
            hostV.copyInto(hosts);
        }
        return hosts;
    }
}

