/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Vector;
import sunw.jdt.cal.cmsd5.attr_value_type;
import sunw.jdt.cal.cmsd5.cms_access_entry;
import sunw.jdt.cal.cmsd5.cms_attribute_value;
import sunw.jdt.cal.cmsd5.uint32;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.rpc.Buffer;

public class AccessListValue
extends AttributeValue {
    CsaAccessEntry[] mvalue;

    public AccessListValue(cms_attribute_value cms) throws CalendarException {
        if (cms.type.value != 10) {
            throw new CalendarException(4, "wrong type");
        }
        this.mtype = 21;
        Vector<CsaAccessEntry> v = new Vector<CsaAccessEntry>();
        cms_access_entry entry = cms.type__access_list_value;
        while (entry != null) {
            CsaAccessEntry item = new CsaAccessEntry(entry.user.val, entry.rights.data);
            v.addElement(item);
            entry = entry.next;
        }
        if (v.size() > 0) {
            this.mvalue = new CsaAccessEntry[v.size()];
            v.copyInto(this.mvalue);
        } else {
            this.mvalue = null;
        }
    }

    public AccessListValue(CsaAccessEntry[] accessEntries) {
        this.mtype = 21;
        this.mvalue = accessEntries;
    }

    public Object clone() {
        return null;
    }

    public CsaAccessEntry[] getAccessEntries() {
        return this.mvalue;
    }

    public void print() {
        System.out.print("AccessList:");
        if (this.mvalue == null) {
            System.out.println("null");
            return;
        }
        int i = 0;
        while (i < this.mvalue.length) {
            System.out.print("\n" + this.mvalue[i].getUser() + ":" + this.mvalue[i].getRights());
            ++i;
        }
        System.out.println("");
    }

    public cms_attribute_value toCmsValue() {
        cms_attribute_value cms = new cms_attribute_value();
        cms.type = new attr_value_type(10);
        if (this.mvalue == null) {
            cms.type__access_list_value = null;
            return cms;
        }
        int i = 0;
        cms_access_entry prev = null;
        cms_access_entry entry = null;
        while (i < this.mvalue.length) {
            entry = new cms_access_entry();
            entry.user = new Buffer(this.mvalue[i].getUser());
            entry.rights = new uint32(this.mvalue[i].getRights());
            entry.next = prev;
            prev = entry;
            ++i;
        }
        cms.type__access_list_value = entry;
        return cms;
    }
}

