/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Vector;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.Util;

public class AccessEntry {
    String mlogin = null;
    String mid = null;
    String mdesc = null;
    String[] mhosts = null;
    int maccess = 2;
    CsaAccessEntry[] mentries = null;
    public static final String WORLD = "world";
    public static final int VIEW_ACCESS = 2;
    public static final int EDIT_ACCESS = 1022;

    public AccessEntry(String login, String id, String desc) throws CalendarException {
        if (login == null || login.length() == 0) {
            throw new CalendarException(19, "The login argument cannot be null or empty string.");
        }
        if (login.indexOf("@") != -1) {
            throw new CalendarException(19, "login cannot contain the '@' charactor.");
        }
        this.mlogin = login;
        if (id != null && id.length() > 0 && desc != null && desc.length() > 0) {
            this.mid = id;
            this.mdesc = desc;
        }
    }

    AccessEntry(Vector entries, int right) {
        boolean nohost = false;
        this.mentries = new CsaAccessEntry[entries.size()];
        entries.copyInto(this.mentries);
        this.mlogin = Util.getUserFromAddr(this.mentries[0].muser);
        this.mid = this.mentries[0].getId();
        this.mdesc = this.mentries[0].getDesc();
        this.maccess = right;
        Vector<String> hostV = new Vector<String>();
        int i = 0;
        while (i < this.mentries.length) {
            String host = Util.getHostFromAddr(this.mentries[i].muser);
            if (host == null) {
                nohost = true;
                break;
            }
            hostV.addElement(host);
            ++i;
        }
        if (!nohost && !hostV.isEmpty()) {
            this.mhosts = new String[hostV.size()];
            hostV.copyInto(this.mhosts);
        }
    }

    public int getAccess() {
        return this.maccess;
    }

    public String getDescription() {
        return this.mdesc;
    }

    public String[] getHosts() {
        return this.mhosts;
    }

    public String getId() {
        return this.mid;
    }

    public String getLogin() {
        return this.mlogin;
    }

    static boolean hasEditAccess(CsaAccessEntry ae) {
        return ae.mcsa && ((ae.mrights & 0x8000L) > 0L || (ae.mrights & 0x3FEL) == 1022L) || !ae.mcsa && ((ae.mrights & 0x8000L) > 0L || (ae.mrights & 7L) == 7L);
    }

    static boolean hasViewAccess(CsaAccessEntry ae) {
        return ae.mcsa && (ae.mrights & 2L) > 0L || !ae.mcsa && (ae.mrights & 1L) > 0L;
    }

    public void setAccess(int access) throws CalendarException {
        if (access != 2 && access != 1022) {
            throw new CalendarException(19, "Invalid access value.");
        }
        this.maccess = access;
    }

    void setDesc(String desc) {
        this.mdesc = desc;
    }

    public void setHosts(String[] hosts) {
        if (hosts != null && hosts.length > 0) {
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i] != null && hosts[i].length() > 0) {
                    v.addElement(hosts[i]);
                }
                ++i;
            }
            if (!v.isEmpty()) {
                this.mhosts = new String[v.size()];
                v.copyInto(this.mhosts);
            }
        } else {
            this.mhosts = null;
        }
    }

    void setId(String id) {
        this.mid = id;
    }
}

