/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.cmsd4;

import java.io.IOException;
import sunw.jdt.cal.cmsd4.Access_Args;
import sunw.jdt.cal.cmsd4.Access_Status;
import sunw.jdt.cal.cmsd4.Registration;
import sunw.jdt.cal.cmsd4.Registration_Status;
import sunw.jdt.cal.cmsd4.Table_Args;
import sunw.jdt.cal.cmsd4.Table_Op_Args;
import sunw.jdt.cal.cmsd4.Table_Res;
import sunw.jdt.cal.cmsd4.Table_Status;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.rpc.clnt_service;
import sunw.jdt.cal.rpc.portmapper;
import sunw.jdt.cal.rpc.rpc_client;
import sunw.jdt.cal.rpc.rpc_client_dg;
import sunw.jdt.cal.rpc.rpc_client_vc;
import sunw.jdt.cal.rpc.xdrin_upcall;
import sunw.jdt.cal.rpc.xdrout_upcall;

public class Service
extends clnt_service {
    public static final long TABLEPROG = 100068L;
    public static final long TABLEVERS = 4L;
    public static final int RTABLE_NULL_PROC = 0;
    public static final int RTABLE_LOOKUP_PROC = 1;
    public static final int RTABLE_LOOKUP_RANGE_PROC = 4;
    public static final int RTABLE_INSERT_PROC = 6;
    public static final int RTABLE_DELETE_PROC = 7;
    public static final int RTABLE_CHANGE_PROC = 9;
    public static final int RTABLE_LOOKUP_NEXT_REMINDER_PROC = 11;
    public static final int RTABLE_REGISTER_CALLBACK_PROC = 15;
    public static final int RTABLE_UNREGISTER_CALLBACK_PROC = 16;
    public static final int RTABLE_SET_ACCESS_PROC = 17;
    public static final int RTABLE_GET_ACCESS_PROC = 18;
    public static final int RTABLE_CREATE_PROC = 21;
    String mhost;
    AuthUser authUser;
    boolean reconnect = false;

    public Service(String server) throws IOException {
        this(server, null);
    }

    public Service(String server, AuthUser aUser) throws IOException {
        this.mhost = server;
        this.authUser = aUser;
        this.connect();
    }

    public void clnt_call(int procno, xdrout_upcall ins, xdrin_upcall outs) throws IOException {
        try {
            if (this.reconnect) {
                this.reconnect();
                this.reconnect = false;
            }
            this.conn.clnt_call(procno, ins, outs);
        }
        catch (IOException e) {
            this.reconnect = true;
            throw e;
        }
    }

    public boolean clnt_call_with_retry(int procno, xdrout_upcall ins, xdrin_upcall outs) throws IOException {
        try {
            this.clnt_call(procno, ins, outs);
            return false;
        }
        catch (IOException iOException) {
            this.clnt_call(procno, ins, outs);
            return true;
        }
    }

    void connect() throws IOException {
        portmapper pm = new portmapper(this.mhost, false);
        int dg_port = pm.getport(100068L, 4L, false);
        rpc_client_dg dg = new rpc_client_dg(this.mhost, dg_port, 100068L, 4L, 1, this.authUser);
        ((rpc_client)dg).clnt_call(0, null, null);
        int stream_port = pm.getport(100068L, 4L, true);
        rpc_client_vc stream = new rpc_client_vc(this.mhost, stream_port, 100068L, 4L, 1, this.authUser);
        pm.close();
        if (stream != null) {
            this.conn = stream;
            dg.close();
        } else {
            this.conn = dg;
        }
    }

    public boolean deregister_callback(Registration ins, Registration_Status outs) throws IOException {
        return this.clnt_call_with_retry(16, ins, outs);
    }

    public void reconnect() throws IOException {
        this.cleanup();
        this.connect();
    }

    public boolean register_callback(Registration ins, Registration_Status outs) throws IOException {
        return this.clnt_call_with_retry(15, ins, outs);
    }

    public boolean rtable_change(Table_Args ins, Table_Res outs) throws IOException {
        this.clnt_call(9, ins, outs);
        return false;
    }

    public boolean rtable_create(Table_Op_Args ins, Table_Status outs) throws IOException {
        this.clnt_call(21, ins, outs);
        return false;
    }

    public boolean rtable_delete(Table_Args ins, Table_Res outs) throws IOException {
        this.clnt_call(7, ins, outs);
        return false;
    }

    public boolean rtable_get_access(Access_Args ins, Access_Args outs) throws IOException {
        return this.clnt_call_with_retry(18, ins, outs);
    }

    public boolean rtable_insert(Table_Args ins, Table_Res outs) throws IOException {
        this.clnt_call(6, ins, outs);
        return false;
    }

    public boolean rtable_lookup(Table_Args ins, Table_Res outs) throws IOException {
        return this.clnt_call_with_retry(1, ins, outs);
    }

    public boolean rtable_lookup_next_reminder(Table_Args ins, Table_Res outs) throws IOException {
        return this.clnt_call_with_retry(11, ins, outs);
    }

    public boolean rtable_lookup_range(Table_Args ins, Table_Res outs) throws IOException {
        return this.clnt_call_with_retry(4, ins, outs);
    }

    public void rtable_null_4() throws IOException {
        this.clnt_call(0, null, null);
    }

    public boolean rtable_set_access(Access_Args ins, Access_Status outs) throws IOException {
        return this.clnt_call_with_retry(17, ins, outs);
    }
}

