/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUtils;

import com.sun.pdasync.SyncUtils.SyncConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public final class SyncUtils {
    private static JFrame parentOfAllConduits;
    static int PortSpeed;

    static {
        PortSpeed = -1;
        System.loadLibrary("runtime");
    }

    public static int SyncGetHHOSVersion(int pwRomVMinor) {
        int wRomVMajor = 0;
        return wRomVMajor;
    }

    public static String convertToStringOfHex(byte[] bytes) {
        return SyncUtils.convertToStringOfHex(bytes, 0, bytes.length);
    }

    public static String convertToStringOfHex(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        String hexStr = "";
        int i = offset;
        while (i < length) {
            hexStr = hexStr.concat(String.valueOf(Integer.toHexString(0xFF & bytes[i])) + " ");
            ++i;
        }
        return hexStr;
    }

    public static int creatorStringToInt(String creatorID) {
        byte[] dbBytes = creatorID.getBytes();
        int dbInt = 0;
        int len = dbBytes.length;
        if (len > 4) {
            return 0;
        }
        int i = 0;
        while (i < len) {
            dbInt = dbBytes[i] << 8 * (len - 1 - i) | dbInt;
            ++i;
        }
        return dbInt;
    }

    public static void doStringSelectionSort(Vector strs) throws ArrayIndexOutOfBoundsException {
        int n = strs.size();
        int i = 0;
        while (i < n - 1) {
            String current = (String)strs.elementAt(i);
            int k = i;
            int j = i + 1;
            while (j <= n - 1) {
                if (current.compareTo((String)strs.elementAt(j)) > 0) {
                    k = j;
                    current = (String)strs.elementAt(k);
                }
                ++j;
            }
            strs.setElementAt(strs.elementAt(i), k);
            strs.setElementAt(current, i);
            ++i;
        }
    }

    public static void doStringSelectionSort(String[] strs) throws ArrayIndexOutOfBoundsException {
        int n = strs.length;
        int i = 0;
        while (i < n - 1) {
            String current = strs[i];
            int k = i;
            int j = i + 1;
            while (j <= n - 1) {
                if (current.compareTo(strs[j]) > 0) {
                    k = j;
                    current = strs[k];
                }
                ++j;
            }
            strs[k] = strs[i];
            strs[i] = current;
            ++i;
        }
    }

    public static int dtHostToPilotDWord(int dwordVal) {
        int platform = SyncConstants.gCurrentPlatform();
        if (platform == 0 || platform == 1 || platform == 2) {
            return SyncUtils.dtReverseDWord(dwordVal);
        }
        if (platform == 4 || platform == 3) {
            return dwordVal;
        }
        return dwordVal;
    }

    public static short dtHostToPilotWord(short wordVal) {
        int platform = SyncConstants.gCurrentPlatform();
        if (platform == 0 || platform == 1 || platform == 2) {
            return SyncUtils.dtReverseWord(wordVal);
        }
        if (platform == 4 || platform == 3) {
            return wordVal;
        }
        return wordVal;
    }

    public static int dtPilotToHostDWord(int dwordVal) {
        int platform = SyncConstants.gCurrentPlatform();
        if (platform == 0 || platform == 1 || platform == 2) {
            return SyncUtils.dtReverseDWord(dwordVal);
        }
        if (platform == 4 || platform == 3) {
            return dwordVal;
        }
        return dwordVal;
    }

    public static short dtPilotToHostWord(short wordVal) {
        int platform = SyncConstants.gCurrentPlatform();
        if (platform == 0 || platform == 1 || platform == 2) {
            return SyncUtils.dtReverseWord(wordVal);
        }
        if (platform == 4 || platform == 3) {
            return wordVal;
        }
        return wordVal;
    }

    public static int dtReverseDWord(int theDWord) {
        int[] bytes = new int[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = SyncUtils.getByteOfInt(theDWord, i);
            ++i;
        }
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3];
    }

    public static short dtReverseWord(short theWord) {
        int[] bytes = new int[2];
        int i = 0;
        while (i < 2) {
            bytes[i] = SyncUtils.getByteOfShort(theWord, i);
            ++i;
        }
        return (short)(bytes[0] << 8 | bytes[1]);
    }

    public static void fillArray(byte[] byteArray, byte theByte) {
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = theByte;
            ++i;
        }
    }

    public static void fillArray(char[] charArray, byte theByte) {
        int i = 0;
        while (i < charArray.length) {
            charArray[i] = (char)theByte;
            ++i;
        }
    }

    public static byte getByteOfInt(int someInt, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int aByte = someInt >> index * 8 & 0xFF;
        return (byte)aByte;
    }

    public static byte getByteOfLong(long someLong, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long aByte = someLong >> index * 8 & 0xFFL;
        return (byte)aByte;
    }

    public static byte getByteOfShort(short someShort, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short aByte = (byte)(someShort >> index * 8 & 0xFF);
        return (byte)aByte;
    }

    public static String getClassShortName(String fullName) {
        int i = fullName.lastIndexOf(46);
        if (i == -1 || i == fullName.length() - 1) {
            return fullName;
        }
        return fullName.substring(i + 1);
    }

    public static String getDefaultPrinter() {
        String printer = null;
        if (SyncConstants.gCurrentPlatform() == 4) {
            String command = "lpstat -d";
            try {
                int i;
                Process p = Runtime.getRuntime().exec(command);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String response = br.readLine();
                if (response != null && (i = response.lastIndexOf(58)) > 0 && i < response.length() - 1) {
                    printer = response.substring(i + 2);
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        }
        if (printer != null && (printer = printer.trim()).length() == 0) {
            printer = null;
        }
        return printer;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        ext = SyncUtils.getExtension(s);
        return ext;
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getFileShortName(String s) {
        String name = null;
        int i = s.lastIndexOf(47);
        name = i > 0 && i < s.length() - 1 ? s.substring(i + 1) : new String(s);
        return name;
    }

    public static int getMaxBaud() {
        if (PortSpeed == -1) {
            PortSpeed = 38400;
            Process p = null;
            String s = new String("/usr/dt/appconfig/sdtpdasync/lib/maxbaud.ksh");
            File f = new File(s);
            if (f.exists()) {
                try {
                    p = Runtime.getRuntime().exec(s);
                }
                catch (IOException iOException) {
                    return 38400;
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    return 38400;
                }
            }
            Date end = new Date();
            if (p != null && p.exitValue() == 3) {
                return 38400;
            }
            PortSpeed = 57600;
            return 57600;
        }
        return PortSpeed;
    }

    public static JFrame getParentOfAllConduits() {
        return parentOfAllConduits;
    }

    public static String getStringFromBytes(byte[] bytes) {
        String tmpString = new String(bytes);
        boolean hasNull = false;
        int i = 0;
        while (i < tmpString.length()) {
            if (tmpString.charAt(i) == '\u0000') {
                hasNull = true;
                break;
            }
            ++i;
        }
        if (!hasNull) {
            return tmpString;
        }
        return tmpString.substring(0, i);
    }

    public static long makeLong(short low, short high) {
        long newVal = (high & 0xFFFF) << 8 | low & 0xFFFF;
        return newVal;
    }

    public static String makeTabsString(int numTabs) {
        String tabs = "";
        int i = 0;
        while (i < numTabs) {
            tabs = tabs.concat("\t");
            ++i;
        }
        return tabs;
    }

    public static int millisecToSecond(long millisec) {
        return (int)((long)((double)millisec / 1000.0) & 0xFFFFFFFFFFFFFFFFL);
    }

    public static final synchronized boolean mkdirIfNotExist(String path) {
        File logDir = new File(path);
        if (logDir.exists()) {
            return true;
        }
        StringTokenizer tokenString = new StringTokenizer(path, SyncConstants.SEPARATOR);
        boolean success = false;
        StringBuffer fullpath = null;
        while (tokenString.hasMoreTokens()) {
            String someDir = tokenString.nextToken();
            if (fullpath == null) {
                fullpath = new StringBuffer(String.valueOf(SyncConstants.SEPARATOR) + someDir);
            } else {
                fullpath.append(String.valueOf(SyncConstants.SEPARATOR) + someDir);
            }
            File fullDir = new File(fullpath.toString());
            if (fullDir.exists() || fullDir.mkdir()) continue;
            return false;
        }
        return true;
    }

    public static void printFile(String printer, String number, String layout, String file) {
        block3: {
            if (SyncConstants.gCurrentPlatform() != 4) break block3;
            String command = "/usr/dt/bin/dtaction SDtPDAPrint " + printer + " " + number + " " + layout + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
            }
            catch (FileNotFoundException fne) {
                System.err.println(fne);
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        }
    }

    public static long secondToMillisec(int sec) {
        return (long)((double)sec * 1000.0);
    }

    public static native void setFilePermission(String var0, String var1);

    public static void setParentOfAllConduits(JFrame root) {
        parentOfAllConduits = root;
    }

    public static final String showFileChooserDialog(JFrame parent, String path, boolean makeIt, String title, String selectLabel) {
        String new_path = path;
        if (makeIt) {
            if (!SyncUtils.mkdirIfNotExist(new_path)) {
                return null;
            }
        } else {
            File logDir = new File(new_path);
            if (logDir.exists()) {
                new_path = SyncConstants.HOME_DIR;
            }
        }
        JFileChooser fc = new JFileChooser(new_path);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(title);
        if (fc.showDialog(parent, selectLabel) == 0) {
            File selectedFile = fc.getSelectedFile();
            if (selectedFile != null) {
                String newPath = selectedFile.getPath();
                return newPath;
            }
        } else {
            return null;
        }
        return null;
    }

    public static void touchFile(String path, String fname) throws IOException {
        String tFile = new String(path);
        FileOutputStream out = null;
        tFile = String.valueOf(tFile) + SyncConstants.SEPARATOR;
        tFile = String.valueOf(tFile) + fname;
        out = new FileOutputStream(tFile);
        out.close();
    }
}

