/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUtils;

import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import com.sun.pdasync.Transport.CTransportPAD;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;

public final class EraseDatebook {
    public static CTransportPAD transportPAD;
    public static byte[] fName;
    static int db;

    public static void main(String[] args) {
        boolean debug = false;
        String port = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port")) {
                if (i + 1 <= args.length) {
                    port = new String(args[i + 1]);
                    break;
                }
            } else {
                System.out.println("Usage: EraseDatebook [ -port <com port> ]");
                System.exit(1);
            }
            ++i;
        }
        if (port == null) {
            port = new String("/dev/term/a");
        }
        try {
            transportPAD = new CTransportPAD(false);
            long err = transportPAD.MakePlatformSerialPort(port);
            if (err != 0L) {
                System.out.println("Error Making Platform Serial Port: " + err);
                System.out.println("\nMake sure that your port is not in use by another application, such as PDASync!!\n");
                System.exit(1);
            }
            EraseDatebook.transportPAD.m_padState = (short)16384;
            String logfname = String.valueOf(SyncConstants.LOG_DIR_PATH) + SyncConstants.SEPARATOR + "EraseDatebook.txt";
            SyncUtils.mkdirIfNotExist(SyncConstants.LOG_DIR_PATH);
            System.out.println("Using " + port + " to connect. \n\tIf this is incorrect Hit ^C (control C) now and \n\tuse the PDASync sync options to change the value");
            System.out.println("\nOtherwise push the hotsync button on the cradle now...");
            while ((err = transportPAD.PollConnection()) != 0L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.exit(1);
                    System.out.println(e);
                }
            }
            err = transportPAD.EstablishConnection();
            if (err != 0L) {
                System.out.println("Connection NOT Established");
                System.exit(1);
            }
            SyncManager.sunwSyncInit((CTransportPAD)transportPAD);
            String filename = new String("MemoDB");
            fName = filename.getBytes();
            try {
                db = SyncManager.openDB((String)"DatebookDB", (int)0, (int)224);
            }
            catch (SyncException e) {
                if (e.errorCode == 16387) {
                    System.out.println("Datebook is empty.  No need to erase any data.");
                    SyncManager.sunwSyncEndOfSync((int)0);
                    System.exit(0);
                }
                System.out.println("Error in datebook erase - cannot open datebookDB.");
                System.exit(1);
            }
            SyncManager.purgeAllRecs((int)db);
            SyncManager.sunwSyncEndOfSync((int)0);
            System.out.println("Datebook erase Complete");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Error in datebook erase.");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

