/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUtils;

import com.sun.pdasync.SyncUtils.SizeOf;
import com.sun.pdasync.SyncUtils.SyncUtils;

public class BufferedBytes
implements Cloneable,
SizeOf {
    public byte[] bytes;
    public int index;

    public BufferedBytes() {
        this.bytes = null;
        this.index = 0;
    }

    public BufferedBytes(byte[] someBytes) {
        this.bytes = someBytes;
        this.index = 0;
    }

    public Object clone() {
        BufferedBytes obj = new BufferedBytes();
        obj.bytes = (byte[])this.clone();
        obj.index = this.index;
        return obj;
    }

    public void copyBytes(byte[] copiedBytes) {
        try {
            int len = Math.min(copiedBytes.length, this.bytes.length - this.index);
            System.arraycopy(copiedBytes, 0, this.bytes, this.index, len);
            this.index += copiedBytes.length;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyBytes(byte[] copiedBytes, int numToCopy) {
        try {
            System.arraycopy(copiedBytes, 0, this.bytes, this.index, numToCopy);
            this.index += numToCopy;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyBytesOfInt(int someInt) {
        try {
            int i = 0;
            while (i < 4) {
                this.bytes[this.index] = SyncUtils.getByteOfInt(someInt, i);
                ++i;
                ++this.index;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyBytesOfLong(long someLong) {
        try {
            int i = 0;
            while (i < 8) {
                this.bytes[this.index] = SyncUtils.getByteOfLong(someLong, i);
                ++i;
                ++this.index;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyBytesOfShort(short someShort) {
        try {
            int i = 0;
            while (i < 2) {
                this.bytes[this.index] = SyncUtils.getByteOfShort(someShort, i);
                ++i;
                ++this.index;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyBytesStartAt(byte[] copiedBytes, int atIndex) {
        try {
            int i = this.index;
            int j = atIndex;
            while (j < copiedBytes.length) {
                this.bytes[i] = copiedBytes[j];
                ++i;
                ++j;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyIntBytes(int someInt) {
        try {
            this.bytes[this.index] = (byte)(someInt >> 24);
            ++this.index;
            this.bytes[this.index] = (byte)(someInt >> 16);
            ++this.index;
            this.bytes[this.index] = (byte)(someInt >> 8);
            ++this.index;
            this.bytes[this.index] = (byte)someInt;
            ++this.index;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyIntBytesOfLong(long someLong) {
        try {
            this.bytes[this.index] = (byte)(someLong >> 24);
            ++this.index;
            this.bytes[this.index] = (byte)(someLong >> 16);
            ++this.index;
            this.bytes[this.index] = (byte)(someLong >> 8);
            ++this.index;
            this.bytes[this.index] = (byte)someLong;
            ++this.index;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void copyShortBytes(short someInt) {
        try {
            this.bytes[this.index] = (byte)(someInt >> 8);
            ++this.index;
            this.bytes[this.index] = (byte)someInt;
            ++this.index;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public boolean equals(Object obj) {
        if (((BufferedBytes)obj).bytes.length != this.bytes.length) {
            return false;
        }
        int i = 0;
        while (i < this.bytes.length) {
            if (((BufferedBytes)obj).bytes[i] != this.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void fillArrayOfBytes(byte[] copiedBytes, int len) {
        try {
            System.arraycopy(this.bytes, this.index, copiedBytes, 0, len);
            this.index += len;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void fillArrayOfBytesStartAt(byte[] copiedBytes, int len, int startIndex) {
        try {
            System.arraycopy(this.bytes, this.index, copiedBytes, startIndex, len);
            this.index += len;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public byte getByte() {
        return this.bytes[this.index];
    }

    public byte getByte(int ofIndex) {
        byte someByte = 0;
        try {
            someByte = this.bytes[ofIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return someByte;
    }

    public int getIndex() {
        return this.index;
    }

    public int getInt() {
        return this.bytes[this.index + 3] & 0xFF | (this.bytes[this.index + 2] & 0xFF) << 8 | (this.bytes[this.index + 1] & 0xFF) << 16 | (this.bytes[this.index] & 0xFF) << 24;
    }

    public long getLong() {
        return this.bytes[this.index + 7] & 0xFF | (this.bytes[this.index + 6] & 0xFF) << 8 | (this.bytes[this.index + 5] & 0xFF) << 16 | (this.bytes[this.index + 4] & 0xFF) << 24 | (this.bytes[this.index + 3] & 0xFF) << 32 | (this.bytes[this.index + 2] & 0xFF) << 40 | (this.bytes[this.index + 1] & 0xFF) << 48 | (this.bytes[this.index] & 0xFF) << 56;
    }

    public short getShort() {
        return (short)((this.bytes[this.index] & 0xFF) << 8 | this.bytes[this.index + 1] & 0xFF);
    }

    public void increment() {
        ++this.index;
    }

    public void increment(int inc) {
        this.index += inc;
    }

    public int index() {
        return this.index;
    }

    public void print() {
        Thread.currentThread();
        Thread.dumpStack();
        System.out.println(SyncUtils.convertToStringOfHex(this.bytes));
    }

    public void setBuffer(byte[] someBytes) {
        this.bytes = someBytes;
        this.index = 0;
    }

    public void setByte(byte someByte) {
        try {
            this.bytes[this.index] = someByte;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void setByte(int ofIndex, byte someByte) {
        try {
            this.bytes[ofIndex] = someByte;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int sizeOf() {
        return 2 + this.bytes.length;
    }
}

