/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SyncUI.ConduitButtons;
import com.sun.pdasync.SyncUI.ConduitListObjects;
import com.sun.pdasync.SyncUI.ConduitPane;
import com.sun.pdasync.SyncUI.LogButtons;
import com.sun.pdasync.SyncUI.LogPane;
import com.sun.pdasync.SyncUI.LogProperties;
import com.sun.pdasync.SyncUI.PDASyncProperties;
import com.sun.pdasync.SyncUI.PilotNameDlg;
import com.sun.pdasync.SyncUI.PilotPdDlg;
import com.sun.pdasync.SyncUI.SyncCmdButtons;
import com.sun.pdasync.SyncUI.SyncCmdPane;
import com.sun.pdasync.SyncUI.SyncTabsResourceReader;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SyncTabs
extends JPanel {
    protected SyncTabsResourceReader resourceReader = new SyncTabsResourceReader();
    protected ConduitListObjects cListObjs;
    public static SyncCmdPane cmdPane;
    public static LogPane logPane;
    public SyncCmdButtons syncBtns;
    public ConduitButtons conduitBtns;
    public LogButtons logBtns;
    private JTabbedPane syncTabs;
    private JPanel syncView;
    private ConduitPane conduitPane;
    private JPanel conduitView;
    private JPanel logView;
    private JFrame parentWin;
    private PilotNameDlg namePilotDlg;
    private PilotPdDlg pilotPdDlg;
    protected Vector propsChangeListeners;

    public SyncTabs(JFrame parent) {
        this(parent, null, null);
    }

    public SyncTabs(JFrame parent, PDASyncProperties syncProps, LogProperties logProps) {
        this.parentWin = parent;
        this.cListObjs = new ConduitListObjects();
        this.setLayout(new BorderLayout());
        this.syncTabs = new JTabbedPane();
        cmdPane = new SyncCmdPane(this.cListObjs);
        this.syncBtns = new SyncCmdButtons(this.cListObjs, syncProps);
        this.syncView = new CommandPane(cmdPane, this.syncBtns);
        this.syncTabs.addTab(this.resourceReader.uiRes.getString(" Synchronization "), this.syncView);
        this.conduitPane = new ConduitPane(this.cListObjs);
        this.conduitBtns = new ConduitButtons(this.cListObjs);
        this.conduitView = new CommandPane(this.conduitPane, this.conduitBtns);
        this.syncTabs.addTab(this.resourceReader.uiRes.getString(" Conduits "), this.conduitView);
        logPane = new LogPane(this.cListObjs);
        this.logBtns = new LogButtons(this.cListObjs, logProps);
        this.logView = new CommandPane(logPane, this.logBtns);
        this.syncTabs.addTab(this.resourceReader.uiRes.getString("     Log     "), this.logView);
        int bgColor = 178;
        this.syncTabs.setBackgroundAt(0, new Color(bgColor, bgColor, bgColor));
        this.syncTabs.setBackgroundAt(1, new Color(bgColor, bgColor, bgColor));
        this.syncTabs.setBackgroundAt(2, new Color(bgColor, bgColor, bgColor));
        this.add((Component)this.syncTabs, "Center");
        this.validate();
        this.namePilotDlg = new PilotNameDlg(this.parentWin);
        this.pilotPdDlg = new PilotPdDlg(this.parentWin);
        this.propsChangeListeners = new Vector();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propsChangeListeners.addElement(listener);
        this.syncBtns.addPropertyChangeListener(listener);
        this.conduitBtns.addPropertyChangeListener(listener);
        this.logBtns.addPropertyChangeListener(listener);
        this.namePilotDlg.addPropertyChangeListener(listener);
        this.pilotPdDlg.addPropertyChangeListener(listener);
    }

    public void askToUpdate() {
        Object[] objs = new Object[10];
        Object[] buttons = new Object[]{this.resourceReader.uiRes.getString("Abort"), this.resourceReader.uiRes.getString("Continue")};
        objs[0] = this.resourceReader.uiRes.getString("The device attached to the cradle");
        objs[1] = this.resourceReader.uiRes.getString("is different.  Its identification is");
        objs[2] = this.resourceReader.uiRes.getString("not the same as the identification of");
        objs[3] = this.resourceReader.uiRes.getString("the PDA you normally synchronize with.");
        objs[4] = new String("\n");
        objs[5] = this.resourceReader.uiRes.getString("You may end up synchronizing with");
        objs[6] = this.resourceReader.uiRes.getString("the wrong data.");
        objs[7] = new String("\n");
        objs[8] = this.resourceReader.uiRes.getString("Do you want to abort or continue with");
        objs[9] = this.resourceReader.uiRes.getString("the synchronization?");
        int ret = JOptionPane.showOptionDialog(this.parentWin, objs, this.resourceReader.uiRes.getString("PDA Synchronization Warning"), 0, 2, null, buttons, buttons[0]);
        if (ret != 1) {
            this.makePropChangeEvent(7, "usercancel");
            return;
        }
        objs[0] = this.resourceReader.uiRes.getString("Continuing with the synchronization");
        objs[1] = this.resourceReader.uiRes.getString("will permanently update the information");
        objs[2] = this.resourceReader.uiRes.getString("that keeps track of the PDA that you");
        objs[3] = this.resourceReader.uiRes.getString("synchronize with.");
        objs[5] = this.resourceReader.uiRes.getString("You may lose data on both the desktop");
        objs[6] = this.resourceReader.uiRes.getString("and the handheld.");
        ret = JOptionPane.showOptionDialog(this.parentWin, objs, this.resourceReader.uiRes.getString("PDA Synchronization Warning"), 0, 2, null, buttons, buttons[0]);
        if (ret == 1) {
            this.makePropChangeEvent(7, this.resourceReader.uiRes.getString("Continue"));
        } else {
            this.makePropChangeEvent(7, "usercancel");
        }
    }

    public void makePropChangeEvent(int type, Object msg) {
        Vector list = (Vector)this.propsChangeListeners.clone();
        PropertyChangeEvent pe = new PropertyChangeEvent(this, type, msg);
        int i = 0;
        while (i < list.size()) {
            PropertyChangeListener listener = (PropertyChangeListener)list.elementAt(i);
            listener.propertyChanged(pe);
            ++i;
        }
    }

    public void namePilot() {
        ((Component)this.namePilotDlg).setVisible(true);
    }

    public void pilotPd(int hasError) {
        if (hasError != 0) {
            this.pilotPdDlg.showErrorDlg();
        }
        ((Component)this.pilotPdDlg).setVisible(true);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propsChangeListeners.removeElement(listener);
        this.syncBtns.removePropertyChangeListener(listener);
        this.conduitBtns.removePropertyChangeListener(listener);
        this.logBtns.removePropertyChangeListener(listener);
        this.namePilotDlg.removePropertyChangeListener(listener);
        this.pilotPdDlg.removePropertyChangeListener(listener);
    }

    public void setInitialState() {
        if (this.resourceReader == null) {
            this.resourceReader = new SyncTabsResourceReader();
        }
        String feedback1 = this.resourceReader.uiRes.getString("To synchronize, put the PalmPilot in the cradle.");
        String feedback2 = this.resourceReader.uiRes.getString("Then, press the HotSync button on the cradle.");
        SyncTabs.cmdPane.userInfo.setText(feedback1);
        SyncTabs.cmdPane.userInfo2.setText(feedback2);
        cmdPane.hideCancelSync();
    }

    public void showAddConduitError() {
        ConduitButtons.showErrorDlg(this.parentWin, true);
    }

    public void update(String feedback1, String feedback2) {
        SyncTabs.cmdPane.userInfo.setText(feedback1);
        SyncTabs.cmdPane.userInfo2.setText(feedback2);
    }

    public void updateConduitList(Vector conduitList) {
        this.conduitPane.setConduitInfo(conduitList);
    }

    public void updateLogText(String logMessage) {
        SyncTabs.logPane.logText.append(logMessage);
    }

    public void updateProgress(int progress) {
        SyncTabs.cmdPane.syncProgress.setValue(progress);
        Rectangle progressRect = SyncTabs.cmdPane.syncProgress.getBounds();
        progressRect.x = 0;
        progressRect.y = 0;
        SyncTabs.cmdPane.syncProgress.paintImmediately(progressRect);
    }
}

