/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.CommPort.SerialPortCommunicator;
import com.sun.pdasync.Properties.UserProps;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import com.sun.pdasync.SyncUI.PDASyncProperties;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.AWTException;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SyncPropsUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    protected JComboBox serialCBox;
    protected JComboBox baudCBox;
    protected JCheckBox autoClose;
    protected PDASyncProperties userProps;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public SyncPropsUI(JFrame parent) {
        this(parent, (UserProps)null);
    }

    public SyncPropsUI(JFrame parent, UserProps initial) {
        super(parent, uiRes.getString("Synchronization Properties"));
        this.propsChangeListeners = new Vector();
        this.setDialogMessage(this.createPropsPanel());
        this.userProps = initial != null ? (PDASyncProperties)initial : new PDASyncProperties();
        this.userProperties = this.userProps;
        this.setDialogParameters();
        this.setContentPane(this.propsOptions);
        this.validate();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SyncPropsUI.this.propsChanged = false;
                SyncPropsUI.this.setDialogParameters();
            }
        });
    }

    private JPanel createPropsPanel() {
        HelpBroker helpBroker = null;
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel.setLayout(new GridBagLayout());
        JLabel port = new JLabel(uiRes.getString("Serial Port:"));
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, port, 0, gbcGridy, 1, 1, 3, 13, new Insets(5, 55, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.serialCBox = new JComboBox();
        Vector ports = SerialPortCommunicator.getNamesOfPorts();
        int i = 0;
        while (i < ports.size()) {
            this.serialCBox.addItem((String)ports.elementAt(i));
            ++i;
        }
        this.serialCBox.setEditable(false);
        try {
            CommandPane.addComponent(panel, this.serialCBox, 1, gbcGridy, 1, 1, 1, 17, new Insets(5, 5, 0, 70));
        }
        catch (AWTException aWTException) {}
        JLabel baud = new JLabel(uiRes.getString("Port Speed:"));
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, baud, 0, gbcGridy, 1, 1, 3, 13, new Insets(5, 55, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.baudCBox = new JComboBox();
        this.baudCBox.addItem(uiRes.getString("9600"));
        this.baudCBox.addItem(uiRes.getString("19,200"));
        this.baudCBox.addItem(uiRes.getString("38,400"));
        if (SyncUtils.getMaxBaud() > 38400) {
            this.baudCBox.addItem(uiRes.getString("57,600"));
        }
        this.baudCBox.addItem(uiRes.getString("As fast as possible"));
        this.baudCBox.setEditable(false);
        try {
            CommandPane.addComponent(panel, this.baudCBox, 1, gbcGridy, 1, 1, 1, 17, new Insets(5, 5, 0, 70));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        this.autoClose = new JCheckBox(uiRes.getString("Iconify application window after synchronization"));
        try {
            CommandPane.addComponent(panel, this.autoClose, 0, gbcGridy, 0, 1, 1, 17, new Insets(15, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.autoClose.setSelected(true);
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, new JSeparator(), 0, gbcGridy, 0, 1, 2, 10, new Insets(20, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        PropsUI.PropsUIChangeListener changed = new PropsUI.PropsUIChangeListener();
        this.serialCBox.addActionListener(changed);
        this.baudCBox.addActionListener(changed);
        this.autoClose.addItemListener(changed);
        this.propsChanged = false;
        helpBroker = PDASyncHelp.enableContextHelp(this.help, "pda_applicationProps");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        panel.validate();
        return panel;
    }

    public String getSelectedPort() {
        String port = null;
        if (this.serialCBox != null) {
            port = (String)this.serialCBox.getSelectedItem();
        }
        return port;
    }

    public void setDialogParameters() {
        String value;
        int i = 0;
        while (i < this.serialCBox.getItemCount()) {
            value = (String)this.serialCBox.getItemAt(i);
            if (value.equals(this.userProps.pdasyncPort)) {
                this.serialCBox.setSelectedIndex(i);
                i = this.serialCBox.getItemCount();
            }
            ++i;
        }
        i = 0;
        String baudRate = this.userProps.getPortSpeedString();
        while (i < this.baudCBox.getItemCount()) {
            value = (String)this.baudCBox.getItemAt(i);
            if (value.equals(baudRate)) {
                this.baudCBox.setSelectedIndex(i);
                i = this.baudCBox.getItemCount();
            }
            ++i;
        }
        this.autoClose.setSelected(this.userProps.pdasyncAutoClose);
    }

    public void updateFromUI() {
        this.userProps.pdasyncPort = new String((String)this.serialCBox.getSelectedItem());
        this.userProps.setPortSpeed((String)this.baudCBox.getSelectedItem());
        this.userProps.pdasyncAutoClose = this.autoClose.isSelected();
    }
}

