/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUI.ConduitListObjects;
import com.sun.pdasync.SyncUI.SyncTabsResourceReader;
import com.sun.pdasync.SyncUtils.UserInteractionEvent;
import com.sun.pdasync.SyncUtils.UserInteractionListener;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SyncCmdPane
extends JPanel {
    public JButton cancelSync;
    public JLabel userInfo;
    public JLabel userInfo2;
    public JPanel userInfoPane;
    public JProgressBar syncProgress;
    public JLabel syncAnimation;
    protected SyncTabsResourceReader resourceReader;
    protected ConduitListObjects cListObjs;
    protected Vector actionListeners;

    public SyncCmdPane(ConduitListObjects o) {
        this.cListObjs = o;
        SyncTabsResourceReader resourceReader = new SyncTabsResourceReader();
        this.actionListeners = new Vector();
        this.setLayout(new GridBagLayout());
        this.userInfo = new JLabel(resourceReader.uiRes.getString("To synchronize, put the PalmPilot in the cradle."));
        this.userInfo2 = new JLabel(resourceReader.uiRes.getString("Then, press the HotSync button on the cradle."));
        this.userInfoPane = new JPanel();
        this.userInfoPane.setLayout(new BoxLayout(this.userInfoPane, 1));
        this.userInfoPane.add(this.userInfo);
        this.userInfoPane.add(Box.createRigidArea(new Dimension(0, 5)));
        this.userInfoPane.add(this.userInfo2);
        Dimension fixedSize = this.userInfoPane.getMinimumSize();
        this.userInfoPane.setMinimumSize(fixedSize);
        this.userInfoPane.setMaximumSize(fixedSize);
        this.userInfoPane.setPreferredSize(fixedSize);
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(this, this.userInfoPane, 0, gbcGridy, 2, 1, 3, 10, new Insets(40, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.syncAnimation = new JLabel(SyncIcons.SYNC_STILL);
        this.syncProgress = new JProgressBar();
        this.syncProgress.setMinimum(0);
        this.syncProgress.setMaximum(100);
        Dimension pbSize = new Dimension(280, 18);
        this.syncProgress.setMinimumSize(pbSize);
        this.syncProgress.setPreferredSize(pbSize);
        this.syncProgress.setMaximumSize(pbSize);
        ++gbcGridy;
        try {
            CommandPane.addComponent(this, this.syncAnimation, 0, gbcGridy, 1, 1, 3, 10, new Insets(10, 15, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(this, this.syncProgress, 1, gbcGridy, 1, 1, 3, 10, new Insets(10, 10, 0, 36));
        }
        catch (AWTException aWTException) {}
        this.cancelSync = new JButton(resourceReader.uiRes.getString("Cancel Synchronization"));
        ++gbcGridy;
        try {
            CommandPane.addComponent(this, this.cancelSync, 0, gbcGridy, 2, 1, 3, 10, new Insets(25, 0, 8, 0));
        }
        catch (AWTException aWTException) {}
        String start = resourceReader.syncTabTips.getString("Press Synchronize to start.");
        String progress = resourceReader.syncTabTips.getString("Current synchronization progress.");
        this.cancelSync.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SyncCmdPane.this.sendViewerRequest(1, 0);
            }
        });
        this.validate();
    }

    public void addUserInteractionListener(UserInteractionListener l) {
        this.actionListeners.addElement(l);
    }

    public void fireEvent(UserInteractionEvent e) {
        Vector list = (Vector)this.actionListeners.clone();
        System.err.println("Num listeners in SyncCmdPane: " + list.size());
        int i = 0;
        while (i < list.size()) {
            UserInteractionListener listener = (UserInteractionListener)list.elementAt(i);
            System.err.println(listener);
            listener.answerViewerRequest(e);
            ++i;
        }
    }

    public void hideCancelSync() {
        this.syncAnimation.setIcon(SyncIcons.SYNC_STILL);
        this.cancelSync.setEnabled(false);
    }

    public void removeUserInteractionListener(UserInteractionListener l) {
        this.actionListeners.removeElement(l);
    }

    public void sendViewerRequest(int type, int urgency) {
        UserInteractionEvent uie = new UserInteractionEvent(this, type, urgency);
        this.fireEvent(uie);
    }

    public void showCancelSync() {
        this.syncAnimation.setIcon(SyncIcons.SYNC_ANIMATED);
        this.cancelSync.setEnabled(true);
    }
}

