/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUI.LogProperties;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PrintDlgUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle tips;
    protected LogProperties logProps;
    protected JLabel fileIconL;
    protected JLabel fileNameL;
    protected JLabel printerL;
    protected JTextField printerTF;
    protected JLabel copiesL;
    protected JTextField copiesTF;
    protected ButtonGroup formatBG;
    protected JRadioButton portraitRB;
    protected JRadioButton landscapeRB;
    protected JLabel portraitL;
    protected JLabel landscapeL;
    protected String fileShortName;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            tips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public PrintDlgUI(JFrame parent, LogProperties uprops) {
        super(parent, uiRes.getString("Print Log"));
        this.logProps = uprops;
        this.userProperties = this.logProps;
        this.setDialogMessage(this.createPropsPanel());
        this.setContentPane(this.propsOptions);
        this.validate();
        this.pack();
    }

    private Object createPropsPanel() {
        HelpBroker helpBroker = null;
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 10);
            }
        };
        panel.setLayout(new GridBagLayout());
        this.fileIconL = new JLabel(SyncIcons.PRINT);
        this.fileShortName = SyncUtils.getFileShortName(this.logProps.logFileFullName);
        this.fileNameL = new JLabel(this.fileShortName);
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, this.fileIconL, 0, gbcGridy, 1, 1, 0, 17, new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.fileNameL, 1, gbcGridy, 5, 1, 0, 17, new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.printerL = new JLabel(uiRes.getString("Printer:"));
        this.printerTF = new JTextField(10);
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.printerL, 1, gbcGridy, 2, 1, 1, 17, new Insets(5, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.printerTF, 3, gbcGridy, 2, 1, 1, 17, new Insets(5, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.copiesL = new JLabel(uiRes.getString("Copies:"));
        this.copiesTF = new JTextField("1", 2);
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.copiesL, 3, gbcGridy, 1, 1, 1, 13, new Insets(10, 40, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.copiesTF, 4, gbcGridy, 1, 1, 1, 13, new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.formatBG = new ButtonGroup();
        this.portraitRB = new JRadioButton();
        this.landscapeRB = new JRadioButton();
        this.portraitL = new JLabel(SyncIcons.PORTRAIT);
        this.landscapeL = new JLabel(SyncIcons.LANDSCAPE);
        this.formatBG.add(this.portraitRB);
        this.formatBG.add(this.landscapeRB);
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.portraitRB, 1, gbcGridy, 1, 1, 0, 17, new Insets(0, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.portraitL, 2, gbcGridy, 1, 1, 0, 17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.landscapeRB, 1, gbcGridy, 1, 1, 0, 17, new Insets(5, 5, 10, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.landscapeL, 2, gbcGridy, 1, 1, 0, 17, new Insets(5, 0, 10, 0));
        }
        catch (AWTException aWTException) {}
        this.portraitRB.setSelected(true);
        Object[] buttons = this.propsOptions.getOptions();
        JButton okBtn = (JButton)buttons[0];
        okBtn.setText(commonRes.getString("  Print  "));
        okBtn.setToolTipText(tips.getString("Print log file."));
        JButton cancelBtn = (JButton)buttons[1];
        ActionListener printFileL = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String number;
                String printer;
                boolean isPortrait = PrintDlgUI.this.portraitRB.isSelected();
                String tmpS = PrintDlgUI.this.printerTF.getText().trim();
                if (tmpS.length() > 0) {
                    printer = tmpS;
                } else {
                    printer = PrintDlgUI.this.logProps.logPrinter;
                    if (printer != null) {
                        PrintDlgUI.this.printerTF.setText(printer);
                    }
                }
                tmpS = PrintDlgUI.this.copiesTF.getText().trim();
                try {
                    int num = Integer.parseInt(tmpS);
                    number = tmpS;
                }
                catch (Exception exception) {
                    number = new String("1");
                    PrintDlgUI.this.copiesTF.setText(number);
                }
                String format = isPortrait ? new String("p") : new String("l");
                if (printer != null) {
                    SyncUtils.printFile(printer, number, format, PrintDlgUI.this.logProps.logFileFullName);
                }
                if (!number.equals("1")) {
                    PrintDlgUI.this.copiesTF.setText("1");
                }
                if (!isPortrait) {
                    PrintDlgUI.this.portraitRB.setSelected(true);
                }
            }
        };
        okBtn.addActionListener(printFileL);
        ActionListener cancelPrint = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PrintDlgUI.this.copiesTF.setText("1");
                PrintDlgUI.this.portraitRB.setSelected(true);
            }
        };
        cancelBtn.addActionListener(cancelPrint);
        helpBroker = PDASyncHelp.enableContextHelp(this.help, "pda_savePrintActivityLog");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        PropsUI.PropsUIChangeListener changed = new PropsUI.PropsUIChangeListener();
        this.printerTF.getDocument().addDocumentListener(changed);
        this.setDialogParameters();
        this.propsChanged = false;
        panel.validate();
        return panel;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Print Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        LogProperties logProps = new LogProperties();
        PrintDlgUI dlg = new PrintDlgUI(fr, logProps);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PrintDlgUI.this.show();
                PrintDlgUI.this.setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public void setDialogParameters() {
        this.printerTF.setText(this.logProps.logPrinter);
    }

    public void updateFromUI() {
        this.logProps.logPrinter = this.printerTF.getText();
    }
}

