/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PilotPdDlg
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle pdasyncTips;
    private static ResourceBundle commonTips;
    public JOptionPane pilotPasswordOptions;
    protected JPasswordField pilotPasswordText;
    protected JButton continueBtn;
    protected JButton cancelBtn;
    protected JButton helpBtn;
    protected String password;
    protected JFrame winParent;
    protected Vector propsChangeListeners;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            pdasyncTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncTips", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PilotPdDlg.java: can't find properties");
            System.err.println("PilotPdDlg.java:" + e.getMessage());
            System.exit(1);
        }
    }

    public PilotPdDlg(JFrame parent) {
        super(parent, uiRes.getString("PDA Password"), true);
        Properties userSettings = new Properties();
        this.winParent = parent;
        this.propsChangeListeners = new Vector();
        this.password = null;
        int btnCnt = 0;
        this.pilotPasswordOptions = new JOptionPane();
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel.setLayout(new GridBagLayout());
        JLabel info = new JLabel(uiRes.getString("Please enter your PalmPilot password."));
        JLabel pilotPasswordLabel = new JLabel(uiRes.getString("Password:"));
        this.pilotPasswordText = new JPasswordField(10);
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, info, 0, gbcGridy, 2, 1, 0, 17, new Insets(10, 0, 15, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, pilotPasswordLabel, 0, gbcGridy, 1, 1, 3, 17, new Insets(0, 30, 10, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.pilotPasswordText, 1, gbcGridy, 1, 1, 3, 17, new Insets(0, 10, 10, 0));
        }
        catch (AWTException aWTException) {}
        this.continueBtn = new JButton(uiRes.getString("Continue"));
        this.continueBtn.setMargin(new Insets(4, 4, 4, 4));
        this.continueBtn.setToolTipText(pdasyncTips.getString("Continue with synchronization."));
        this.continueBtn.setActionCommand("ContinueCmd");
        ++btnCnt;
        this.cancelBtn = new JButton(commonRes.getString("Cancel"));
        this.cancelBtn.setMargin(new Insets(4, 4, 4, 4));
        this.cancelBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
        this.cancelBtn.setActionCommand("CancelCmd");
        ++btnCnt;
        this.helpBtn = new JButton(SyncIcons.HELP);
        this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.helpBtn.setToolTipText(commonTips.getString("Display help."));
        this.helpBtn.setActionCommand("HelpCmd");
        ++btnCnt;
        HelpBroker helpBroker = PDASyncHelp.enableContextHelp(this.helpBtn, "pda_password");
        if (helpBroker == null) {
            this.helpBtn.setEnabled(false);
        } else {
            this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.pilotPasswordOptions.setMessage(panel);
        this.pilotPasswordOptions.setMessageType(-1);
        Object[] buttons = new Object[btnCnt];
        buttons[0] = this.continueBtn;
        buttons[1] = this.cancelBtn;
        buttons[2] = this.helpBtn;
        this.pilotPasswordOptions.setOptions(buttons);
        this.pilotPasswordOptions.setOptionType(-1);
        this.pilotPasswordOptions.setInitialValue(this.continueBtn);
        this.pilotPasswordOptions.validate();
        ActionListener enterPassword = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String cmd = ev.getActionCommand();
                if (cmd.equals("ContinueCmd")) {
                    char[] userVal = PilotPdDlg.this.pilotPasswordText.getPassword();
                    if (userVal.length == 0) {
                        PilotPdDlg.this.showErrorDlg();
                    } else {
                        PilotPdDlg.this.password = new String(userVal);
                        PilotPdDlg.this.makePropChangeEvent(6, PilotPdDlg.this.password);
                        ((Component)PilotPdDlg.this).setVisible(false);
                    }
                } else if (cmd.equals("CancelCmd")) {
                    PilotPdDlg.this.password = new String("usercancel");
                    PilotPdDlg.this.makePropChangeEvent(6, PilotPdDlg.this.password);
                    ((Component)PilotPdDlg.this).setVisible(false);
                }
            }
        };
        this.continueBtn.addActionListener(enterPassword);
        this.cancelBtn.addActionListener(enterPassword);
        this.helpBtn.addActionListener(enterPassword);
        this.setContentPane(this.pilotPasswordOptions);
        this.validate();
        this.pack();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.addElement(l);
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Password Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        PilotPdDlg dlg = new PilotPdDlg(fr);
        ActionListener showDlg = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PilotPdDlg.this.show();
                PilotPdDlg.this.setResizable(false);
            }
        };
        show.addActionListener(showDlg);
        ((Component)fr).setVisible(true);
    }

    public void makePropChangeEvent(int type, Object msg) {
        Vector list = (Vector)this.propsChangeListeners.clone();
        PropertyChangeEvent pe = new PropertyChangeEvent(this, type, msg);
        int i = 0;
        while (i < list.size()) {
            PropertyChangeListener listener = (PropertyChangeListener)list.elementAt(i);
            listener.propertyChanged(pe);
            ++i;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.removeElement(l);
    }

    public void showErrorDlg() {
        JOptionPane.showMessageDialog(this.winParent, uiRes.getString("The password provided is not correct."), uiRes.getString("Password Error"), 0);
    }
}

