/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PilotNameDlg
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle pdasyncTips;
    private static ResourceBundle commonTips;
    private static final String CONT = "Continue";
    private static final String CANCEL = "Cancel";
    private static final String HELP = "Help";
    public JOptionPane pilotNameOptions;
    protected JTextField pilotName;
    protected JButton continueBtn;
    protected JButton cancelBtn;
    protected JButton helpBtn;
    protected String name;
    protected JFrame winParent;
    private static final int FIELD_LEN = 12;
    protected Vector propsChangeListeners;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            pdasyncTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncTips", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PilotNameDlg.java: can't find properties");
            System.err.println("PilotNameDlg.java:" + e.getMessage());
            System.exit(1);
        }
    }

    public PilotNameDlg(JFrame parent) {
        super(parent, uiRes.getString("PDA Name"), true);
        Properties userSettings = new Properties();
        this.winParent = parent;
        this.propsChangeListeners = new Vector();
        this.name = null;
        int btnCnt = 0;
        this.pilotNameOptions = new JOptionPane();
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel.setLayout(new GridBagLayout());
        JLabel info = new JLabel(uiRes.getString("Please give your PalmPilot a name."));
        JLabel info2 = new JLabel(uiRes.getString("This dialog will not appear again."));
        JLabel pilotNameLabel = new JLabel(uiRes.getString("Name:"));
        this.pilotName = new JTextField(10);
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, info, 0, gbcGridy, 2, 1, 0, 17, new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, info2, 0, gbcGridy, 2, 1, 0, 17, new Insets(5, 0, 15, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, pilotNameLabel, 0, gbcGridy, 1, 1, 3, 17, new Insets(0, 30, 10, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.pilotName, 1, gbcGridy, 1, 1, 3, 17, new Insets(0, 10, 10, 0));
        }
        catch (AWTException aWTException) {}
        this.continueBtn = new JButton(uiRes.getString(CONT));
        this.continueBtn.setMargin(new Insets(4, 4, 4, 4));
        this.continueBtn.setToolTipText(pdasyncTips.getString("Continue with synchronization."));
        this.continueBtn.setActionCommand(CONT);
        ++btnCnt;
        this.cancelBtn = new JButton(commonRes.getString(CANCEL));
        this.cancelBtn.setMargin(new Insets(4, 4, 4, 4));
        this.cancelBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
        this.cancelBtn.setActionCommand(CANCEL);
        ++btnCnt;
        this.helpBtn = new JButton(SyncIcons.HELP);
        this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.helpBtn.setToolTipText(commonTips.getString("Display help."));
        this.helpBtn.setActionCommand(HELP);
        ++btnCnt;
        HelpBroker helpBroker = PDASyncHelp.enableContextHelp(this.helpBtn, "pda_name");
        if (helpBroker == null) {
            this.helpBtn.setEnabled(false);
        } else {
            this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.pilotNameOptions.setMessage(panel);
        this.pilotNameOptions.setMessageType(-1);
        Object[] buttons = new Object[btnCnt];
        buttons[0] = this.continueBtn;
        buttons[1] = this.cancelBtn;
        buttons[2] = this.helpBtn;
        this.pilotNameOptions.setOptions(buttons);
        this.pilotNameOptions.setOptionType(-1);
        this.pilotNameOptions.setInitialValue(this.continueBtn);
        this.pilotNameOptions.validate();
        ActionListener enterName = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String cmd = ev.getActionCommand();
                if (cmd.equals(PilotNameDlg.CONT)) {
                    String userVal = PilotNameDlg.this.pilotName.getText();
                    if (userVal == null || userVal.equals("")) {
                        JOptionPane.showMessageDialog(PilotNameDlg.this.winParent, uiRes.getString("Please provide a name for your PalmPilot."), uiRes.getString("Naming Error"), 0);
                    } else {
                        PilotNameDlg.this.name = new String(userVal);
                        PilotNameDlg.this.makePropChangeEvent(5, PilotNameDlg.this.name);
                        ((Component)PilotNameDlg.this).setVisible(false);
                    }
                } else if (cmd.equals(PilotNameDlg.CANCEL)) {
                    PilotNameDlg.this.name = new String("usercancel");
                    PilotNameDlg.this.makePropChangeEvent(5, PilotNameDlg.this.name);
                    ((Component)PilotNameDlg.this).setVisible(false);
                }
            }
        };
        this.continueBtn.addActionListener(enterName);
        this.cancelBtn.addActionListener(enterName);
        this.helpBtn.addActionListener(enterName);
        this.setContentPane(this.pilotNameOptions);
        this.validate();
        this.pack();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.addElement(l);
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Name Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        PilotNameDlg dlg = new PilotNameDlg(fr);
        ActionListener showDlg = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PilotNameDlg.this.show();
                PilotNameDlg.this.setResizable(false);
            }
        };
        show.addActionListener(showDlg);
        ((Component)fr).setVisible(true);
    }

    public void makePropChangeEvent(int type, Object msg) {
        Vector list = (Vector)this.propsChangeListeners.clone();
        PropertyChangeEvent pe = new PropertyChangeEvent(this, type, msg);
        int i = 0;
        while (i < list.size()) {
            PropertyChangeListener listener = (PropertyChangeListener)list.elementAt(i);
            listener.propertyChanged(pe);
            ++i;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.removeElement(l);
    }

    public void resetName() {
        this.name = null;
        this.pilotName.setText(this.name);
    }
}

