/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.CommPort.SerialPortCommunicator;
import com.sun.pdasync.Properties.UserProps;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class PDASyncProperties
extends UserProps {
    private static Locale theLocale;
    private static ResourceBundle propRes;
    public static final String PORT_PROP = "pdasync.port";
    public static final String PORT_SPEED_PROP = "pdasync.portspeed";
    public static final String AUTO_CLOSE_PROP = "pdasync.autoclose";
    public String pdasyncPort;
    public int pdasyncPortSpeed;
    public boolean pdasyncAutoClose;

    static {
        try {
            theLocale = Locale.getDefault();
            propRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public PDASyncProperties() {
        super("PDASync.def", "PDA Sync Properties");
        this.getProperties();
    }

    public String getPortSpeedString() {
        switch (this.pdasyncPortSpeed) {
            case 115200: {
                return new String(propRes.getString("115,200"));
            }
            case 57600: {
                return new String(propRes.getString("57,600"));
            }
            case 38400: {
                return new String(propRes.getString("38,400"));
            }
            case 19200: {
                return new String(propRes.getString("19,200"));
            }
            case 9600: {
                return new String(propRes.getString("9600"));
            }
        }
        return new String(propRes.getString("As fast as possible"));
    }

    public void printProps(String msg, Properties props) {
        System.out.println("Settings: " + msg);
        System.out.println("\tPort: " + props.getProperty(PORT_PROP));
        System.out.println("\tSpeed: " + props.getProperty(PORT_SPEED_PROP));
        System.out.println("\tAutoClose: " + props.getProperty(AUTO_CLOSE_PROP));
    }

    protected void savePropertiesError() {
    }

    public void setDefaultSettings(Properties userSettings) {
        Boolean gotString;
        String default_port = null;
        Vector ports = SerialPortCommunicator.getNamesOfPorts();
        if (ports != null && ports.size() > 1 && (gotString = new Boolean(default_port = new String((String)ports.elementAt(0)))).booleanValue()) {
            ((Hashtable)userSettings).put(PORT_PROP, default_port);
        }
        ((Hashtable)userSettings).put(PORT_SPEED_PROP, Integer.toString(0));
        ((Hashtable)userSettings).put(AUTO_CLOSE_PROP, Boolean.TRUE.toString());
    }

    public void setPortSpeed(String newVal) {
        this.pdasyncPortSpeed = newVal.equals(propRes.getString("115,200")) ? 115200 : (newVal.equals(propRes.getString("57,600")) ? 57600 : (newVal.equals(propRes.getString("38,400")) ? 38400 : (newVal.equals(propRes.getString("19,200")) ? 19200 : (newVal.equals(propRes.getString("9600")) ? 9600 : 0))));
    }

    protected void setProperties() {
        ((Hashtable)this.userProps).put(PORT_PROP, this.pdasyncPort);
        ((Hashtable)this.userProps).put(PORT_SPEED_PROP, new Integer(this.pdasyncPortSpeed).toString());
        ((Hashtable)this.userProps).put(AUTO_CLOSE_PROP, new Boolean(this.pdasyncAutoClose).toString());
    }

    protected void setSettings() {
        String tmp = this.userProps.getProperty(PORT_PROP);
        if (tmp != null) {
            this.pdasyncPort = new String(tmp);
        }
        if ((tmp = this.userProps.getProperty(PORT_SPEED_PROP)) != null) {
            this.pdasyncPortSpeed = Integer.parseInt(tmp);
        }
        if ((tmp = this.userProps.getProperty(AUTO_CLOSE_PROP)) != null) {
            this.pdasyncAutoClose = new Boolean(tmp);
        }
    }
}

