/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.dt.Xsession;
import com.sun.pdasync.Logger.LogToFile;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUI.LogProperties;
import com.sun.pdasync.SyncUI.PDASyncProperties;
import com.sun.pdasync.SyncUI.SyncTabs;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import com.sun.pdasync.SyncUtils.SyncUtils;
import com.sun.pdasync.SyncUtils.UserInteractionEvent;
import com.sun.pdasync.SyncUtils.UserInteractionListener;
import com.sun.pdasync.SyncUtils.ViewNotifierEvent;
import com.sun.pdasync.SyncUtils.ViewNotifierListener;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class PDASyncDlgUI
extends Applet
implements Serializable,
ViewNotifierListener {
    private static Locale theLocale;
    private static ResourceBundle pdaRes;
    private static ResourceBundle pdaTips;
    private static ResourceBundle commonRes;
    public JFrame pdaSyncFrame;
    protected JPanel pdaSyncPane;
    public PDASyncProperties appProps;
    public LogProperties logProps;
    SyncTabs syncPane;
    public LogToFile logFile;
    private int debugLevel;
    private boolean exitPending;
    private static int ticksize;
    private static int tick;
    protected Vector actionListeners;

    static {
        ticksize = 10;
        tick = 0;
        try {
            theLocale = Locale.getDefault();
            pdaRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncMessages", theLocale);
            pdaTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncTips", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASyncDlgUI: can't find properties");
            System.err.println("PDASyncDlgUI:" + e.getMessage());
            System.exit(1);
        }
        try {
            String lf = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(lf);
        }
        catch (Exception xcp) {
            System.err.println(String.valueOf(pdaRes.getString("Could not set look and feel:")) + xcp);
            System.exit(1);
        }
    }

    public PDASyncDlgUI(int debug) {
        this(null, debug);
    }

    public PDASyncDlgUI(Logger logger, int debug) {
        HelpBroker helpBroker = null;
        this.debugLevel = debug;
        this.pdaSyncFrame = new JFrame(pdaRes.getString("PDA Synchronization"));
        SyncUtils.setParentOfAllConduits(this.pdaSyncFrame);
        this.appProps = new PDASyncProperties();
        this.logProps = new LogProperties();
        this.syncPane = new SyncTabs(this.pdaSyncFrame, this.appProps, this.logProps);
        this.syncPane.validate();
        JPanel btnPane = new JPanel();
        btnPane.setLayout(new FlowLayout(2));
        JButton close = new JButton(commonRes.getString("Close"));
        close.setMargin(new Insets(4, 4, 4, 4));
        btnPane.add(close);
        close.setToolTipText(pdaTips.getString("Quit application."));
        ActionListener closeAL = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                System.exit(0);
            }
        };
        close.addActionListener(closeAL);
        this.exitPending = false;
        JButton help = new JButton(SyncIcons.HELP);
        help.setMargin(new Insets(-1, -1, -1, -1));
        btnPane.add(help);
        help.setToolTipText(pdaTips.getString("Display help."));
        btnPane.validate();
        helpBroker = PDASyncHelp.getHelpBroker();
        if (helpBroker == null) {
            help.setEnabled(false);
        } else {
            help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.pdaSyncPane = new CommandPane(this.syncPane, btnPane);
        this.pdaSyncPane.validate();
        this.pdaSyncFrame.setContentPane(this.pdaSyncPane);
        this.pdaSyncFrame.pack();
        this.pdaSyncFrame.validate();
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            public void windowOpened(WindowEvent event) {
                Dimension d = PDASyncDlgUI.this.pdaSyncFrame.getSize();
                PDASyncDlgUI.this.syncPane.setMinimumSize(d);
                SyncTabs.cmdPane.hideCancelSync();
                PDASyncDlgUI.this.syncPane.setMaximumSize(d);
            }
        };
        this.pdaSyncFrame.addWindowListener(winEvents);
        ((Frame)this.pdaSyncFrame).setIconImage(SyncIcons.PDA_SYNC);
        JOptionPane.setRootFrame(this.pdaSyncFrame);
        this.actionListeners = new Vector();
        this.logFile = new LogToFile(logger, this.logProps.logFileFullName, this.logProps.logFileAppend);
    }

    public void addUserInteractionListener(UserInteractionListener l) {
        this.actionListeners.addElement(l);
    }

    public void fireEvent(UserInteractionEvent e) {
        Vector list = (Vector)this.actionListeners.clone();
        int i = 0;
        while (i < list.size()) {
            UserInteractionListener listener = (UserInteractionListener)list.elementAt(i);
            listener.answerViewerRequest(e);
            ++i;
        }
    }

    public JFrame getPDASyncDlgUIFrame() {
        return this.pdaSyncFrame;
    }

    public String getSelectedPort() {
        return this.syncPane.syncBtns.propsDlg.getSelectedPort();
    }

    public void init() {
        PDASyncDlgUI appletFrame = new PDASyncDlgUI(0);
        appletFrame.showUI();
    }

    public boolean isExitPending() {
        return this.exitPending;
    }

    public void listenToPropertyUpdates(PropertyChangeListener listener) {
        this.syncPane.addPropertyChangeListener(listener);
    }

    public void listenToViewerRequests(UserInteractionListener listener) {
        SyncTabs.cmdPane.addUserInteractionListener(listener);
    }

    public static void main(String[] args) {
        PDASyncDlgUI mainFrame = new PDASyncDlgUI(0);
        mainFrame.showUI();
    }

    public void notifyListeners(int type, int priority) {
        UserInteractionEvent uie = new UserInteractionEvent(this, type, priority);
        this.fireEvent(uie);
    }

    public void removeUserInteractionListener(UserInteractionListener l) {
        this.actionListeners.removeElement(l);
    }

    public void resetLog() {
        SyncTabs.logPane.eraseLogText();
        this.logFile.newSettings(false);
    }

    public void setInitialState() {
        this.syncPane.setInitialState();
    }

    public void showUI() {
        ((Component)this.pdaSyncFrame).setVisible(true);
        Xsession.Deiconify((Object)this.pdaSyncFrame);
    }

    public void updateDebug(String logMessage) {
        if (this.debugLevel == 0) {
            return;
        }
        this.updateLog(logMessage);
    }

    public void updateFeedback(String feedback1, String feedback2) {
        this.syncPane.update(feedback1, feedback2);
    }

    public void updateLog(String logMessage) {
        this.syncPane.updateLogText(logMessage);
        this.logFile.updateLogFile(logMessage);
    }

    public void updateProgress(int progress) {
        this.syncPane.updateProgress(progress);
    }

    public void updateViewer(ViewNotifierEvent e) {
        switch (e.getNotificationType()) {
            case 0: {
                this.setInitialState();
                this.updateProgress(0);
                tick = 0;
                break;
            }
            case 1: {
                SyncTabs.cmdPane.showCancelSync();
                if (!this.logProps.logFileAppend) {
                    this.resetLog();
                }
                if ((String)e.message != null) {
                    this.updateFeedback((String)e.message, null);
                }
                Xsession.Deiconify((Object)this.pdaSyncFrame);
                break;
            }
            case 7: {
                this.updateFeedback((String)e.message, null);
                break;
            }
            case 8: {
                this.updateProgress(tick += ticksize);
                break;
            }
            case 9: {
                if ((Integer)e.message == 0) break;
                if (tick == 0) {
                    ticksize = 100 / (Integer)e.message;
                    break;
                }
                ticksize = (100 - tick) / (Integer)e.message;
                break;
            }
            case 11: {
                if (e.errorType == 0) {
                    this.syncPane.updateConduitList((Vector)e.message);
                    break;
                }
                if (e.errorType != 1) break;
                this.syncPane.showAddConduitError();
                break;
            }
            case 12: {
                this.syncPane.namePilot();
                break;
            }
            case 13: {
                this.syncPane.pilotPd(e.errorType);
                break;
            }
            case 14: {
                this.syncPane.askToUpdate();
                break;
            }
            case -1: 
            case 34: {
                this.updateLog((String)e.message);
                break;
            }
            case 5: 
            case 6: {
                this.updateDebug((String)e.message);
                break;
            }
            case 15: {
                Xsession.Iconify((Object)this.pdaSyncFrame);
                break;
            }
        }
    }
}

