/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import com.sun.pdasync.SyncUI.LogProperties;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class LogPropsUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private JLabel logLabel;
    protected ButtonGroup logFileBehaviorBG;
    protected JRadioButton logFileAppendRB;
    protected JRadioButton logFileOverwriteRB;
    protected JCheckBox debugInfoCB;
    protected LogProperties userProps;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDALog: can't find properties");
            System.err.println("PDALog:" + e.getMessage());
            System.exit(1);
        }
    }

    public LogPropsUI(JFrame parent) {
        this(parent, (LogProperties)null);
    }

    public LogPropsUI(JFrame parent, LogProperties initial) {
        super(parent, uiRes.getString("Log Properties"));
        this.propsChangeListeners = new Vector();
        this.setDialogMessage(this.createPropsPanel());
        this.userProps = initial != null ? initial : new LogProperties();
        this.userProperties = this.userProps;
        this.setDialogParameters();
        this.setContentPane(this.propsOptions);
        this.validate();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                LogPropsUI.this.propsChanged = false;
                LogPropsUI.this.setDialogParameters();
            }
        });
    }

    private JPanel createPropsPanel() {
        HelpBroker helpBroker = null;
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        panel.setLayout(new GridBagLayout());
        this.logLabel = new JLabel(uiRes.getString("When saving a log file:"));
        this.logFileBehaviorBG = new ButtonGroup();
        this.logFileAppendRB = new JRadioButton(uiRes.getString("Append to the last log file"));
        this.logFileOverwriteRB = new JRadioButton(uiRes.getString("Overwrite the last log file"));
        this.logFileBehaviorBG.add(this.logFileAppendRB);
        this.logFileBehaviorBG.add(this.logFileOverwriteRB);
        this.debugInfoCB = new JCheckBox(uiRes.getString("Show diagnostic information in log"));
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, this.logLabel, 0, gbcGridy, 0, 1, 1, 17, new Insets(15, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.logFileAppendRB, 0, gbcGridy, 0, 1, 1, 13, new Insets(5, 15, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.logFileOverwriteRB, 0, gbcGridy, 0, 1, 1, 13, new Insets(0, 15, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.debugInfoCB, 0, gbcGridy, 0, 1, 1, 17, new Insets(10, 0, 15, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, new JSeparator(), 0, gbcGridy, 0, 1, 2, 10, null);
        }
        catch (AWTException aWTException) {}
        PropsUI.PropsUIChangeListener stateChangedListener = new PropsUI.PropsUIChangeListener();
        this.logFileAppendRB.addItemListener(stateChangedListener);
        this.logFileOverwriteRB.addItemListener(stateChangedListener);
        this.debugInfoCB.addItemListener(stateChangedListener);
        this.propsChanged = false;
        helpBroker = PDASyncHelp.enableContextHelp(this.help, "pda_accessLogProp");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        panel.validate();
        return panel;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Log Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        LogProperties logProps = new LogProperties();
        LogPropsUI logPropsDlg = new LogPropsUI(fr, logProps);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LogPropsUI.this.show();
                LogPropsUI.this.setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public void setDialogParameters() {
        this.debugInfoCB.setSelected(this.userProps.logShowDebug);
        if (this.userProps.logFileAppend) {
            this.logFileAppendRB.setSelected(true);
        } else {
            this.logFileOverwriteRB.setSelected(true);
        }
    }

    public void updateFromUI() {
        this.userProps.logFileAppend = this.logFileAppendRB.isSelected();
        this.userProps.logShowDebug = this.debugInfoCB.isSelected();
    }
}

