/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.Properties.UserProps;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class LogProperties
extends UserProps {
    private static Locale theLocale;
    private static ResourceBundle propRes;
    public static final String LOG_FILE_APPEND = "log.fileappend";
    public static final String SHOW_DEBUG = "log.showdebug";
    public static final String DEFAULT_PRINTER = "log.printer";
    public static final String LOG_FILENAME = "PDA_Sync_Log.txt";
    public boolean logShowDebug;
    public boolean logFileAppend;
    public String logFileFullName;
    public String logPrinter;

    static {
        try {
            theLocale = Locale.getDefault();
            propRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("Log: can't find properties");
            System.err.println("Log:" + e.getMessage());
            System.exit(1);
        }
    }

    public LogProperties() {
        super("PDALog.def", "PDA Log Properties");
        this.getProperties();
    }

    public void printProps(String msg, Properties props) {
        System.out.println("Settings: " + msg);
        System.out.println("\tFile behavior: " + props.getProperty(LOG_FILE_APPEND));
        System.out.println("\tDebug: " + props.getProperty(SHOW_DEBUG));
    }

    protected void savePropertiesError() {
    }

    public void setDefaultSettings(Properties userSettings) {
        ((Hashtable)userSettings).put(LOG_FILE_APPEND, Boolean.FALSE.toString());
        ((Hashtable)userSettings).put(SHOW_DEBUG, Boolean.FALSE.toString());
        String logPath = new String(SyncConstants.LOG_DIR_PATH);
        SyncUtils.mkdirIfNotExist(logPath);
        if (!logPath.endsWith(SyncConstants.SEPARATOR)) {
            logPath = logPath.concat(SyncConstants.SEPARATOR);
        }
        this.logFileFullName = new String(String.valueOf(logPath) + LOG_FILENAME);
        this.logPrinter = SyncUtils.getDefaultPrinter();
    }

    protected void setProperties() {
        ((Hashtable)this.userProps).put(LOG_FILE_APPEND, new Boolean(this.logFileAppend).toString());
        ((Hashtable)this.userProps).put(SHOW_DEBUG, new Boolean(this.logShowDebug).toString());
        if (this.logPrinter != null) {
            ((Hashtable)this.userProps).put(DEFAULT_PRINTER, this.logPrinter);
        }
    }

    protected void setSettings() {
        String tmp = this.userProps.getProperty(LOG_FILE_APPEND);
        if (tmp != null) {
            this.logFileAppend = new Boolean(tmp);
        }
        if ((tmp = this.userProps.getProperty(SHOW_DEBUG)) != null) {
            this.logShowDebug = new Boolean(tmp);
        }
        if ((tmp = this.userProps.getProperty(DEFAULT_PRINTER)) != null) {
            this.logPrinter = new String(tmp);
        }
    }
}

