/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.Registry.ConduitInstall;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUI.CellRenderer;
import com.sun.pdasync.SyncUI.ConduitAddDlg;
import com.sun.pdasync.SyncUI.ConduitAssDlg;
import com.sun.pdasync.SyncUI.ConduitListObjects;
import com.sun.pdasync.SyncUI.SyncTabsResourceReader;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class ConduitButtons
extends JPanel {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    protected JButton propsBtn;
    protected JButton activateBtn;
    protected JButton addBtn;
    protected String selectedConduit;
    protected JDialog[] propsDlg;
    protected SyncTabsResourceReader resourceReader;
    protected ConduitListObjects cListObjs;
    protected JFrame winParent;
    private static JButton deleteBtn;
    private String tip = "";
    private ConduitAddDlg conduitAddDlg;
    private ConduitAssDlg conduitAssDlg;
    private Vector addInfo;
    protected Vector propsChangeListeners;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("ConduitButtons.java:" + e.getMessage());
            System.exit(1);
        }
    }

    public ConduitButtons(ConduitListObjects o) {
        this.cListObjs = o;
        this.winParent = SyncUtils.getParentOfAllConduits();
        this.propsChangeListeners = new Vector();
        this.addInfo = new Vector(10);
        SyncTabsResourceReader resourceReader = new SyncTabsResourceReader();
        this.setLayout(new FlowLayout(0));
        this.activateBtn = new JButton(SyncIcons.ACTIVATE);
        this.activateBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.tip = resourceReader.syncTabTips.getString("Toggle conduit's active state.");
        this.activateBtn.setToolTipText(this.tip);
        this.activateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = ConduitListObjects.conduitList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                if (ConduitListObjects.conduitsSelected.get(i)) {
                    ConduitListObjects.conduitsSelected.clear(i);
                } else {
                    ConduitListObjects.conduitsSelected.set(i);
                }
                ConduitListObjects.conduitList.setCellRenderer(new CellRenderer(ConduitListObjects.conduitsSelected));
                ConduitListObjects.conduitList.getParent().repaint();
                ConduitButtons.this.selectedConduit = (String)ConduitListObjects.conduitList.getSelectedValue();
                if (ConduitButtons.this.selectedConduit != null) {
                    ConduitButtons.this.makePropChangeEvent(3, ConduitButtons.this.selectedConduit);
                }
            }
        });
        this.propsBtn = new JButton(SyncIcons.PROPERTIES);
        this.propsBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.tip = resourceReader.syncTabTips.getString("Change conduit settings.");
        this.propsBtn.setToolTipText(this.tip);
        this.propsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ConduitButtons.this.selectedConduit = (String)ConduitListObjects.conduitList.getSelectedValue();
                if (ConduitButtons.this.selectedConduit != null) {
                    ConduitButtons.this.makePropChangeEvent(1, ConduitButtons.this.selectedConduit);
                }
            }
        });
        deleteBtn = new JButton(SyncIcons.MINUS);
        deleteBtn.setMargin(new Insets(-1, -1, -1, -1));
        deleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ConduitButtons.this.selectedConduit = (String)ConduitListObjects.conduitList.getSelectedValue();
                if (ConduitButtons.this.selectedConduit != null) {
                    Object[] buttons = new Object[2];
                    Object[] messages = new Object[1];
                    buttons[0] = uiRes.getString("Remove Conduit");
                    buttons[1] = commonRes.getString("Cancel");
                    messages[0] = String.valueOf(uiRes.getString("Remove the conduit ")) + ConduitButtons.this.selectedConduit + uiRes.getString(" from the conduit list ?");
                    int ret = JOptionPane.showOptionDialog(ConduitButtons.this.winParent, messages, uiRes.getString("Remove Conduit"), 0, 3, null, buttons, buttons[0]);
                    if (ret == 0) {
                        ConduitButtons.this.makePropChangeEvent(4, ConduitButtons.this.selectedConduit);
                    }
                }
            }
        });
        this.tip = resourceReader.syncTabTips.getString("Delete conduit from list.");
        deleteBtn.setToolTipText(this.tip);
        this.conduitAddDlg = new ConduitAddDlg(this.winParent);
        this.conduitAssDlg = new ConduitAssDlg(this.winParent);
        this.addBtn = new JButton(SyncIcons.PLUS);
        this.addBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.tip = resourceReader.syncTabTips.getString("Add conduit to list.");
        this.addBtn.setToolTipText(this.tip);
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConduitButtons.this.addInfo.size() > 0) {
                    ConduitButtons.this.addInfo.removeAllElements();
                }
                String[] fileInfo = new String[2];
                if (!ConduitButtons.this.conduitAddDlg.showDlg(fileInfo)) {
                    return;
                }
                String[] codeInfo = new String[2];
                if (!ConduitInstall.verifyConduit((String)fileInfo[1], (String[])codeInfo)) {
                    ConduitButtons.showErrorDlg(ConduitButtons.this.winParent, false);
                    return;
                }
                boolean newFlag = ConduitInstall.isNewConduit((String)codeInfo[0]);
                String[] dbInfo = new String[2];
                if (newFlag) {
                    if (!ConduitButtons.this.conduitAssDlg.showDlg(dbInfo)) {
                        return;
                    }
                    ConduitButtons.this.addInfo.addElement("new");
                    ConduitButtons.this.addInfo.addElement(codeInfo[1]);
                    ConduitButtons.this.addInfo.addElement(codeInfo[0]);
                    ConduitButtons.this.addInfo.addElement(dbInfo[0]);
                    ConduitButtons.this.addInfo.addElement(dbInfo[1]);
                    ConduitButtons.this.addInfo.addElement(fileInfo[0]);
                    ConduitButtons.this.addInfo.addElement(fileInfo[1]);
                } else {
                    ConduitButtons.this.addInfo.addElement("old");
                    ConduitButtons.this.addInfo.addElement(codeInfo[1]);
                }
                ConduitButtons.this.makePropChangeEvent(8, ConduitButtons.this.addInfo);
            }
        });
        this.add(this.propsBtn);
        this.add(this.activateBtn);
        this.add(this.addBtn);
        this.add(deleteBtn);
        this.validate();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.addElement(l);
    }

    protected static void enableDeleteButton(boolean enable) {
        deleteBtn.setEnabled(enable);
    }

    public void makePropChangeEvent(int type, Object msg) {
        Vector list = (Vector)this.propsChangeListeners.clone();
        PropertyChangeEvent pe = new PropertyChangeEvent(this, type, msg);
        int i = 0;
        while (i < list.size()) {
            PropertyChangeListener listener = (PropertyChangeListener)list.elementAt(i);
            listener.propertyChanged(pe);
            ++i;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.removeElement(l);
    }

    public static void showErrorDlg(JFrame parent, boolean validConduit) {
        if (!validConduit) {
            JOptionPane.showMessageDialog(parent, uiRes.getString("The file you chose is not a valid conduit."), uiRes.getString("Add Conduit Error"), 0);
        } else {
            JOptionPane.showMessageDialog(parent, String.valueOf(uiRes.getString("Failed to register conduit.  The conduit\n")) + uiRes.getString("will not appear in the conduit list."), uiRes.getString("Add Conduit Error"), 0);
        }
    }
}

