/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.HotSync.DBListDef;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ConduitAssDlg
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle commonTips;
    public JOptionPane assConduitOptions;
    protected JScrollPane scrollPane;
    protected JList dataDBList;
    protected DefaultListModel listModel;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected JButton helpBtn;
    protected JFrame winParent;
    protected String dataDBName;
    protected int creatorID;
    protected DBListDef dblist;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("ConduitAssDlg.java:" + e.getMessage());
            System.exit(1);
        }
    }

    public ConduitAssDlg(JFrame parent) {
        super(parent, uiRes.getString("Associate Conduit"), true);
        this.winParent = parent;
        int btnCnt = 0;
        this.assConduitOptions = new JOptionPane();
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 10);
            }
        };
        panel.setLayout(new GridBagLayout());
        JLabel dataDBLabel1 = new JLabel(uiRes.getString("Select the PalmPilot database to use"));
        JLabel dataDBLabel2 = new JLabel(uiRes.getString("with this conduit."));
        this.listModel = new DefaultListModel();
        this.dataDBList = new JList(this.listModel);
        this.dataDBList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.dataDBList);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setPreferredSize(new Dimension(250, 120));
        this.initializeList();
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, dataDBLabel1, 0, gbcGridy, 1, 1, 0, 17, new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, dataDBLabel2, 0, gbcGridy, 1, 1, 0, 17, new Insets(5, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.scrollPane, 0, gbcGridy, 0, 1, 0, 10, new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, new JSeparator(), 0, gbcGridy, 0, 1, 2, 10, new Insets(15, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.okBtn = new JButton(commonRes.getString("   OK   "));
        this.okBtn.setMargin(new Insets(4, 4, 4, 4));
        this.okBtn.setToolTipText(commonTips.getString("Apply changes."));
        this.okBtn.setActionCommand("okCmd");
        ++btnCnt;
        this.cancelBtn = new JButton(commonRes.getString("Cancel"));
        this.cancelBtn.setMargin(new Insets(4, 4, 4, 4));
        this.cancelBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
        this.cancelBtn.setActionCommand("cancelCmd");
        ++btnCnt;
        this.helpBtn = new JButton(SyncIcons.HELP);
        this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.helpBtn.setToolTipText(commonTips.getString("Display help."));
        this.helpBtn.setActionCommand("helpCmd");
        ++btnCnt;
        HelpBroker helpBroker = PDASyncHelp.enableContextHelp(this.helpBtn, "pda_addConduit");
        if (helpBroker == null) {
            this.helpBtn.setEnabled(false);
        } else {
            this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.assConduitOptions.setMessage(panel);
        this.assConduitOptions.setMessageType(-1);
        Object[] buttons = new Object[btnCnt];
        buttons[0] = this.okBtn;
        buttons[1] = this.cancelBtn;
        buttons[2] = this.helpBtn;
        this.assConduitOptions.setOptions(buttons);
        this.assConduitOptions.setOptionType(-1);
        this.assConduitOptions.setInitialValue(this.okBtn);
        this.assConduitOptions.validate();
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String cmd = ev.getActionCommand();
                if (cmd.equals("okCmd")) {
                    if (ConduitAssDlg.this.dataDBList.isSelectionEmpty()) {
                        ConduitAssDlg.this.dataDBName = null;
                    } else {
                        int listIndex = ConduitAssDlg.this.dataDBList.getSelectedIndex();
                        ConduitAssDlg.this.dataDBName = ConduitAssDlg.this.listModel.getElementAt(listIndex).toString();
                        ConduitAssDlg.this.creatorID = ConduitAssDlg.this.dblist.findCreatorID(ConduitAssDlg.this.dataDBName);
                    }
                } else {
                    ConduitAssDlg.this.dataDBName = null;
                }
                ((Component)ConduitAssDlg.this).setVisible(false);
            }
        };
        this.okBtn.addActionListener(buttonListener);
        this.cancelBtn.addActionListener(buttonListener);
        this.setContentPane(this.assConduitOptions);
        this.validate();
        this.pack();
    }

    private void addItemToList(String itemToAdd) {
        int size = this.listModel.getSize();
        if (size == 0) {
            this.listModel.addElement(itemToAdd);
            this.dataDBList.setSelectedIndex(0);
        } else {
            int index = 0;
            while (index < size) {
                String itemInList = this.listModel.getElementAt(index).toString();
                int retValue = itemInList.compareTo(itemToAdd);
                if (retValue > 0) break;
                ++index;
            }
            if (index == size) {
                this.listModel.addElement(itemToAdd);
            } else {
                this.listModel.insertElementAt(itemToAdd, index);
            }
            this.dataDBList.setSelectedIndex(index);
        }
        size = this.listModel.getSize();
    }

    private void emptyList() {
        int size = this.listModel.getSize();
        if (size > 0) {
            this.listModel.removeRange(0, size - 1);
        }
    }

    private void initializeList() {
        this.dblist = new DBListDef();
        this.dblist.read();
        String[] names = this.dblist.getDBNames();
        int i = 0;
        while (i < names.length) {
            this.addItemToList(names[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Add Conduit Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel panel = new JPanel();
        panel.add(show);
        panel.validate();
        fr.setContentPane(panel);
        fr.pack();
        ConduitAssDlg dlg = new ConduitAssDlg(fr);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ConduitAssDlg.this.show();
                ConduitAssDlg.this.setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public boolean showDlg(String[] db) {
        ((Component)this).setVisible(true);
        if (this.dataDBName != null) {
            db[0] = this.dataDBName;
            db[1] = new Integer(this.creatorID).toString();
            return true;
        }
        return false;
    }
}

