/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SyncUI;

import com.sun.pdasync.Registry.ConduitInstall;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUI.ConduitButtons;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ConduitAddDlg
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle uiRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle pdasyncTips;
    private static ResourceBundle commonTips;
    public JOptionPane addConduitOptions;
    protected JComboBox locationCB;
    protected JScrollPane scrollPane;
    protected JList conduitList;
    protected DefaultListModel listModel;
    protected JButton importBtn;
    protected JButton addBtn;
    protected JButton cancelBtn;
    protected JButton helpBtn;
    protected JFrame winParent;
    protected String fullFileName;
    protected boolean systemDirWritable;
    protected JFileChooser fileChooser;
    protected int conduitType;

    static {
        try {
            theLocale = Locale.getDefault();
            uiRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            pdasyncTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.PDASyncTips", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("ConduitAddDlg.java:" + e.getMessage());
            System.exit(1);
        }
    }

    public ConduitAddDlg(JFrame parent) {
        super(parent, uiRes.getString("Add Conduit"), true);
        this.winParent = parent;
        File personalDir = new File(SyncConstants.CONDUITS_DIR[0]);
        if (!personalDir.exists()) {
            personalDir.mkdir();
        }
        this.systemDirWritable = true;
        File systemDir = new File(SyncConstants.CONDUITS_DIR[2]);
        if (!systemDir.exists()) {
            if (!systemDir.mkdir()) {
                this.systemDirWritable = false;
            }
        } else if (!systemDir.isDirectory() || !systemDir.canWrite()) {
            this.systemDirWritable = false;
        }
        int btnCnt = 0;
        this.addConduitOptions = new JOptionPane();
        JPanel panel = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 10);
            }
        };
        panel.setLayout(new GridBagLayout());
        JLabel showConduitLabel = new JLabel(uiRes.getString("Show Conduits From:"));
        String[] locations = new String[]{uiRes.getString("Personal Conduits"), uiRes.getString("System Default"), uiRes.getString("System Additions")};
        this.locationCB = new JComboBox<String>(locations);
        this.conduitType = 1;
        this.locationCB.setSelectedIndex(this.conduitType);
        this.importBtn = new JButton(uiRes.getString("Import Conduit..."), SyncIcons.IMPORT);
        this.importBtn.setVerticalTextPosition(0);
        this.importBtn.setHorizontalTextPosition(4);
        this.importBtn.setMargin(new Insets(-2, 5, -1, 7));
        this.importBtn.setEnabled(false);
        this.importBtn.setToolTipText(pdasyncTips.getString("Import conduit."));
        this.fileChooser = new JFileChooser(SyncConstants.HOME_DIR);
        this.fileChooser.setDialogTitle(uiRes.getString("Import Conduit"));
        this.listModel = new DefaultListModel();
        this.conduitList = new JList(this.listModel);
        this.conduitList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.conduitList);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setPreferredSize(new Dimension(300, 100));
        int gbcGridy = 0;
        try {
            CommandPane.addComponent(panel, showConduitLabel, 0, gbcGridy, 1, 1, 0, 13, new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent(panel, this.locationCB, 1, gbcGridy, 1, 1, 0, 17, new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.importBtn, 1, gbcGridy, 1, 1, 0, 17, new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, this.scrollPane, 0, gbcGridy, 0, 1, 0, 10, new Insets(10, 5, 0, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent(panel, new JSeparator(), 0, gbcGridy, 0, 1, 2, 10, new Insets(15, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.addBtn = new JButton(uiRes.getString("Add to Conduit List"));
        this.addBtn.setMargin(new Insets(4, 4, 4, 4));
        this.addBtn.setToolTipText(pdasyncTips.getString("Add to conduit list."));
        this.addBtn.setActionCommand("addCmd");
        ++btnCnt;
        this.cancelBtn = new JButton(commonRes.getString("Cancel"));
        this.cancelBtn.setMargin(new Insets(4, 4, 4, 4));
        this.cancelBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
        this.cancelBtn.setActionCommand("cancelCmd");
        ++btnCnt;
        this.helpBtn = new JButton(SyncIcons.HELP);
        this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.helpBtn.setToolTipText(commonTips.getString("Display help."));
        this.helpBtn.setActionCommand("helpCmd");
        ++btnCnt;
        HelpBroker helpBroker = PDASyncHelp.enableContextHelp(this.helpBtn, "pda_addConduit");
        if (helpBroker == null) {
            this.helpBtn.setEnabled(false);
        } else {
            this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.addConduitOptions.setMessage(panel);
        this.addConduitOptions.setMessageType(-1);
        Object[] buttons = new Object[btnCnt];
        buttons[0] = this.addBtn;
        buttons[1] = this.cancelBtn;
        buttons[2] = this.helpBtn;
        this.addConduitOptions.setOptions(buttons);
        this.addConduitOptions.setOptionType(-1);
        this.addConduitOptions.setInitialValue(this.addBtn);
        this.addConduitOptions.validate();
        this.setList(SyncConstants.CONDUITS_DIR[1]);
        ActionListener locationChanged = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConduitAddDlg.this.conduitType = ConduitAddDlg.this.locationCB.getSelectedIndex();
                if (ConduitAddDlg.this.conduitType == 1 || ConduitAddDlg.this.conduitType == 2 && !ConduitAddDlg.this.systemDirWritable) {
                    ConduitAddDlg.this.importBtn.setEnabled(false);
                } else {
                    ConduitAddDlg.this.importBtn.setEnabled(true);
                }
                ConduitAddDlg.this.setList(SyncConstants.CONDUITS_DIR[ConduitAddDlg.this.conduitType]);
            }
        };
        this.locationCB.addActionListener(locationChanged);
        ActionListener importConduit = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                block4: {
                    File file;
                    int retVal = ConduitAddDlg.this.fileChooser.showDialog(ConduitAddDlg.this.winParent, uiRes.getString("Import"));
                    if (retVal != 0 || !(file = ConduitAddDlg.this.fileChooser.getSelectedFile()).exists()) break block4;
                    String[] codeInfo = new String[2];
                    if (!ConduitInstall.verifyConduit((String)file.toString(), (String[])codeInfo)) {
                        ConduitButtons.showErrorDlg(ConduitAddDlg.this.winParent, false);
                    } else {
                        try {
                            ConduitAddDlg.this.copy(file);
                        }
                        catch (IOException e) {
                            System.out.println(e.getMessage());
                        }
                    }
                }
            }
        };
        this.importBtn.addActionListener(importConduit);
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String cmd = ev.getActionCommand();
                if (cmd.equals("addCmd")) {
                    if (ConduitAddDlg.this.conduitList.isSelectionEmpty()) {
                        ConduitAddDlg.this.fullFileName = null;
                    } else {
                        int listIndex = ConduitAddDlg.this.conduitList.getSelectedIndex();
                        String fileName = ConduitAddDlg.this.listModel.getElementAt(listIndex).toString();
                        ConduitAddDlg.this.fullFileName = String.valueOf(SyncConstants.CONDUITS_DIR[ConduitAddDlg.this.conduitType]) + "/" + fileName;
                    }
                } else {
                    ConduitAddDlg.this.fullFileName = null;
                }
                ((Component)ConduitAddDlg.this).setVisible(false);
            }
        };
        this.addBtn.addActionListener(buttonListener);
        this.cancelBtn.addActionListener(buttonListener);
        this.setContentPane(this.addConduitOptions);
        this.validate();
        this.pack();
    }

    private void addItemToList(String itemToAdd) {
        int size = this.listModel.getSize();
        if (size == 0) {
            this.listModel.addElement(itemToAdd);
            this.conduitList.setSelectedIndex(0);
        } else {
            int index = 0;
            while (index < size) {
                String itemInList = this.listModel.getElementAt(index).toString();
                int retValue = itemInList.compareTo(itemToAdd);
                if (retValue > 0) break;
                ++index;
            }
            if (index == size) {
                this.listModel.addElement(itemToAdd);
            } else {
                this.listModel.insertElementAt(itemToAdd, index);
            }
            this.conduitList.setSelectedIndex(index);
        }
        size = this.listModel.getSize();
    }

    public void copy(File fromFile) throws IOException {
        FileOutputStream to;
        boolean toFileNotExist;
        block16: {
            File conduitDir = new File(SyncConstants.CONDUITS_DIR[this.conduitType]);
            File toFile = new File(SyncConstants.CONDUITS_DIR[this.conduitType]);
            toFileNotExist = true;
            toFile = new File(conduitDir, fromFile.getName());
            String toFileName = toFile.getName();
            if (toFile.exists()) {
                toFileNotExist = false;
                toFile.delete();
            }
            FileInputStream from = null;
            to = null;
            try {
                try {
                    int bytesRead;
                    from = new FileInputStream(fromFile);
                    to = new FileOutputStream(toFile);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    System.err.println("Import Conduit:" + e.getMessage());
                }
                Object var9_11 = null;
                if (from == null) break block16;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException iOException) {}
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                from.close();
            }
            catch (IOException iOException) {}
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException iOException) {}
        }
        if (toFileNotExist) {
            this.addItemToList(fromFile.getName());
        }
    }

    private void emptyList() {
        int size = this.listModel.getSize();
        if (size > 0) {
            this.listModel.removeRange(0, size - 1);
        }
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Add Conduit Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel panel = new JPanel();
        panel.add(show);
        panel.validate();
        fr.setContentPane(panel);
        fr.pack();
        ConduitAddDlg dlg = new ConduitAddDlg(fr);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ConduitAddDlg.this.show();
                ConduitAddDlg.this.setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    private void setList(String path) {
        this.emptyList();
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return;
        }
        String[] fileNames = dir.list();
        if (fileNames.length > 0) {
            int i = 0;
            while (i < fileNames.length) {
                this.addItemToList(fileNames[i]);
                ++i;
            }
            this.conduitList.setSelectedIndex(0);
        }
    }

    public boolean showDlg(String[] cond) {
        ((Component)this).setVisible(true);
        if (this.conduitType == 0) {
            cond[0] = "2";
        } else if (this.conduitType == 1) {
            cond[0] = "3";
        } else if (this.conduitType == 2) {
            cond[0] = "1";
        }
        if (this.fullFileName != null) {
            cond[1] = this.fullFileName;
            return true;
        }
        return false;
    }
}

