/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SharedUI;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SimpleClassLoader
extends ClassLoader {
    public static final String urlPrefix = "SIMPLE";
    private static boolean debug = false;
    private static boolean keepLoading = true;
    private String cookie;
    private static Hashtable loaders = new Hashtable();
    public static SimpleClassLoader ourLoader;
    private String localResourceDirectory;
    private Hashtable localOverrides = new Hashtable();
    private Hashtable resourceHash = new Hashtable();
    private Hashtable mimeHash = new Hashtable();
    private Hashtable rawClasses = new Hashtable();

    static {
        Properties newP = new Properties(System.getProperties());
        System.setProperties(newP);
        ourLoader = SimpleClassLoader.createLoader("BeanBox", null);
    }

    private SimpleClassLoader(String cookie, String dir) {
        this.cookie = cookie;
        this.localResourceDirectory = dir;
        loaders.put(cookie, this);
    }

    private Class applyDefinition(String name, boolean resolve) {
        byte[] buf = (byte[])this.rawClasses.get(name);
        this.rawClasses.remove(name);
        if (buf == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = super.defineClass(null, buf, 0, buf.length);
            if (c != null && resolve) {
                this.resolveClass(c);
            }
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("The definition for " + name + " in the JAR file");
            System.err.println("has a format error.");
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        if (!c.getName().equals(name)) {
            System.err.println("\nWARNING: file name versus class name mismatch");
            String fname = String.valueOf(name.replace('.', '/')) + ".class";
            System.err.println("    JAR entry \"" + fname + "\" was expected " + "to contain class \"" + name + "\"");
            System.err.println("    but instead contained class \"" + c.getName() + "\"");
            System.err.println("    This may cause future class-loading problems.\n");
        }
        return c;
    }

    public synchronized boolean applyDefinitions(Vector classList) {
        boolean back = true;
        Enumeration k = classList.elements();
        while (k.hasMoreElements()) {
            String classname = (String)k.nextElement();
            Class c = this.findLoadedClass(classname);
            if (c != null || (c = this.applyDefinition(classname, true)) != null) continue;
            if (back) {
                System.err.println("NOTE: There are classes that cannot be defined in this JAR file");
                System.err.println("    Some of these classes will cause the failure of defining or linking ");
                System.err.println("    other classes that depend on them.");
                if (keepLoading) {
                    System.err.println("NOTE: To simplify debugging JAR files, we will proceed loading classes");
                    System.err.println("    although this may lead eventually to an UnknownError or the like");
                    System.err.println();
                }
            }
            System.err.println("Class " + classname + " could not be defined from JAR file");
            back = false;
        }
        return back;
    }

    public static SimpleClassLoader createLoader(String cookie, String dir) {
        SimpleClassLoader back = SimpleClassLoader.getLoader(cookie);
        if (back != null) {
            if (!back.localResourceDirectory.equals(dir)) {
                throw new Error("internal error!");
            }
            return back;
        }
        return new SimpleClassLoader(cookie, dir);
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("SimpleClassLoader:: " + msg);
        }
    }

    public void defineClassFromBytes(String name, byte[] buf) {
        this.rawClasses.put(name, buf);
    }

    private static byte[] getByteArray(String fileName) throws IOException {
        File f = new File(fileName);
        int length = (int)f.length();
        byte[] buff = new byte[length];
        FileInputStream is = new FileInputStream(fileName);
        int read = 0;
        while (read < length) {
            int r = ((InputStream)is).read(buff, read, length - read);
            if (r < 0) break;
            read += r;
        }
        return buff;
    }

    private static SimpleClassLoader getLoader(String cookie) {
        return (SimpleClassLoader)loaders.get(cookie);
    }

    private URL getLocalResource(String name) {
        File f;
        Object o = this.localOverrides.get(name);
        if (o == null) {
            o = this.resourceHash.get(name);
        }
        if (o == null && this.localResourceDirectory != null && (f = new File(this.localResourceDirectory, name)).exists()) {
            o = new Integer("1");
        }
        if (o != null) {
            try {
                URL url = new URL("simpleresource", "", "/SIMPLE" + this.cookie + "/+/" + name);
                return url;
            }
            catch (Exception e) {
                SimpleClassLoader.debug("Exception " + e + " while building a resource URL");
                return null;
            }
        }
        return null;
    }

    public URL getResource(String name) {
        URL back = ClassLoader.getSystemResource(name);
        if (back != null) {
            return back;
        }
        return this.getLocalResource(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl == null) {
            cl = this.applyDefinition(name, resolve);
        }
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    void putClassResource(String name, String type) {
        this.resourceHash.put(name, "A CLASS FILE");
        this.mimeHash.put(name, type);
    }

    void putLocalResource(String name, byte[] data, String type) {
        this.resourceHash.put(name, data);
        this.mimeHash.put(name, type);
    }
}

