/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SharedUI;

import com.sun.pdasync.Properties.UserProps;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUtils.PropertyChangeEvent;
import com.sun.pdasync.SyncUtils.PropertyChangeListener;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class PropsUI
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle res;
    private static ResourceBundle tips;
    protected JOptionPane propsOptions;
    public boolean propsChanged = false;
    public JButton ok;
    public JButton cancel;
    public JButton help;
    public UserProps userProperties;
    protected Vector propsChangeListeners = new Vector();

    static {
        try {
            theLocale = Locale.getDefault();
            res = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            tips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("pdasync: can't find properties");
            System.err.println("pdasync:" + e.getMessage());
            System.exit(1);
        }
    }

    public PropsUI(JFrame parent) {
        this(parent, null, (Object)null, null);
    }

    public PropsUI(JFrame parent, UserProps settings) {
        this(parent, null, null, settings);
    }

    public PropsUI(JFrame parent, String title) {
        this(parent, title, (Object)null, null);
    }

    public PropsUI(JFrame parent, String title, UserProps settings) {
        this(parent, title, null, settings);
    }

    public PropsUI(JFrame parent, String title, Object message) {
        this(parent, title, message, null);
    }

    public PropsUI(JFrame parent, String title, Object message, UserProps settings) {
        super((Frame)parent, true);
        if (title != null) {
            this.setTitle(title);
        }
        if (settings != null) {
            this.userProperties = settings;
        }
        this.propsOptions = this.createOptions(message);
        this.setContentPane(this.propsOptions);
        this.validate();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.addElement(l);
    }

    private JOptionPane createOptions(Object message) {
        JOptionPane panel = new JOptionPane();
        panel.setMessageType(-1);
        if (message != null) {
            panel.setMessage(message);
        }
        this.ok = new JButton(res.getString("   OK   "));
        this.ok.setToolTipText(tips.getString("Apply changes."));
        this.ok.setMargin(new Insets(4, 4, 4, 4));
        this.cancel = new JButton(res.getString("Cancel"));
        this.cancel.setToolTipText(tips.getString("Dismiss dialog."));
        this.cancel.setMargin(new Insets(4, 4, 4, 4));
        this.help = new JButton(SyncIcons.HELP);
        this.help.setToolTipText(tips.getString("Display help."));
        this.help.setMargin(new Insets(-1, -1, -1, -1));
        Object[] buttons = new Object[]{this.ok, this.cancel, this.help};
        panel.setOptions(buttons);
        panel.setOptionType(-1);
        panel.setInitialValue(this.ok);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (PropsUI.this.propsChanged) {
                    PropsUI.this.updateFromUI();
                    PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, 2);
                    PropsUI.this.fireEvent(pe);
                    PropsUI.this.userProperties.saveProperties();
                    PropsUI.this.propsChanged = false;
                }
                ((Component)PropsUI.this).setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PropsUI.this.propsChanged = false;
                PropsUI.this.setDialogParameters();
                ((Component)PropsUI.this).setVisible(false);
            }
        });
        panel.validate();
        return panel;
    }

    public void fireEvent(PropertyChangeEvent e) {
        Vector list = (Vector)this.propsChangeListeners.clone();
        int i = 0;
        while (i < list.size()) {
            PropertyChangeListener listener = (PropertyChangeListener)list.elementAt(i);
            listener.propertyChanged(e);
            ++i;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propsChangeListeners.removeElement(l);
    }

    public void setDialogMessage(Object message) {
        this.propsOptions.setMessage(message);
    }

    public abstract void setDialogParameters();

    public void setUserProperties(UserProps settings) {
        this.userProperties = settings;
    }

    public abstract void updateFromUI();

    public class PropsUIChangeListener
    implements ItemListener,
    ActionListener,
    DocumentListener {
        public void actionPerformed(ActionEvent ev) {
            PropsUI.this.propsChanged = true;
        }

        public void changedUpdate(DocumentEvent e) {
            PropsUI.this.propsChanged = true;
        }

        public void insertUpdate(DocumentEvent e) {
            PropsUI.this.propsChanged = true;
        }

        public void itemStateChanged(ItemEvent ev) {
            PropsUI.this.propsChanged = true;
        }

        public void removeUpdate(DocumentEvent e) {
            PropsUI.this.propsChanged = true;
        }
    }
}

