/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SharedUI;

import com.sun.pdasync.SharedUI.JarLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.Vector;

public class LoadConduitsFromJars {
    private static final String suffix = "Conduit.jar";
    private static final int num_dirs = 1;
    private static String[] dirs = new String[]{"/opt/SUNWpdas/conduits/"};
    private static Vector jarList;
    private static String[] conduitList;
    private static Class[] conduitClasses;

    public LoadConduitsFromJars() {
        jarList = new Vector();
        try {
            int i = 0;
            while (i < 1) {
                LoadConduitsFromJars.listDirectory(dirs[i]);
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        LoadConduitsFromJars.loadClassesFromJars();
    }

    public static Class getConduitClass(String conduitName) {
        int i = 0;
        while (i < conduitList.length) {
            if (conduitList[i].equals(conduitName)) {
                Class conduitClass = conduitClasses[i];
                return conduitClass;
            }
            ++i;
        }
        return null;
    }

    public static String[] getConduitList() {
        return conduitList;
    }

    public static void listDirectory(String directory) throws FileNotFoundException {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("SyncUtils: no such directory");
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(LoadConduitsFromJars.suffix);
            }
        };
        String[] files = dir.list(filter);
        int i = 0;
        while (i < files.length) {
            if (!jarList.contains(String.valueOf(directory) + files[i])) {
                jarList.addElement(String.valueOf(directory) + files[i]);
            }
            ++i;
        }
    }

    public static void loadClassesFromJars() {
        conduitClasses = new Class[jarList.size()];
        conduitList = new String[jarList.size()];
        try {
            int i = 0;
            while (i < jarList.size()) {
                JarLoader jl = new JarLoader((String)jarList.elementAt(i));
                JarLoader.loadJar("Conduit");
                LoadConduitsFromJars.conduitClasses[i] = Class.forName(JarLoader.getClassName());
                StringTokenizer tokenizer = new StringTokenizer(JarLoader.getClassName(), ".");
                while (tokenizer.hasMoreTokens()) {
                    LoadConduitsFromJars.conduitList[i] = tokenizer.nextToken();
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

