/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.SharedUI;

import com.sun.pdasync.SharedUI.SimpleClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarLoader {
    private static final String SYNC_FUNC_NAME = "open";
    private static boolean debug = false;
    private static InputStream jarStream;
    private static String jarName;
    private static SimpleClassLoader loader;
    private static boolean warnedAboutNoBeans;
    private static String classname;
    private static String conduitDriverClass;

    public JarLoader(String jarName) throws FileNotFoundException {
        JarLoader.debug("(" + jarName + ")");
        JarLoader.jarName = jarName;
        FileInputStream is = new FileInputStream(jarName);
        jarStream = new BufferedInputStream(is);
        loader = SimpleClassLoader.ourLoader;
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("SimpleClassLoader:: " + msg);
        }
    }

    public static String getClassName() {
        return conduitDriverClass;
    }

    public ClassLoader getLoader() {
        return loader;
    }

    private static String guessContentTypeFromStream(InputStream is) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(is);
        if (type == null) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            is.reset();
            if (c1 == 172 && c2 == 237) {
                type = "application/java-serialized-object";
            }
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadJar(String conduitClassName) throws IOException {
        boolean empty;
        block16: {
            ZipInputStream zis = null;
            byte[] buffer = new byte[1024];
            empty = true;
            conduitDriverClass = null;
            try {
                try {
                    zis = new ZipInputStream(jarStream);
                    ZipEntry ent = null;
                    while ((ent = zis.getNextEntry()) != null) {
                        int len;
                        empty = false;
                        String name = ent.getName();
                        String type = null;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((len = zis.read(buffer)) >= 0) {
                            baos.write(buffer, 0, len);
                        }
                        byte[] buf = baos.toByteArray();
                        int size = buf.length;
                        if (type == null) {
                            ByteArrayInputStream tmpStream = new ByteArrayInputStream(buf);
                            type = JarLoader.guessContentTypeFromStream(tmpStream);
                            ((InputStream)tmpStream).close();
                        }
                        if (type == null) {
                            type = "input-stream/input-stream";
                        }
                        if (type.startsWith("application/java-serialized-object") || type.startsWith("application/x-java-serialized-object")) {
                            loader.putLocalResource(name, buf, type);
                            String sername = name.substring(0, name.length() - 4);
                            sername = sername.replace('/', '.');
                            continue;
                        }
                        if (type.startsWith("application/java-vm") || type.startsWith("application/x-java-vm")) {
                            Class<?> c;
                            loader.putClassResource(name, type);
                            classname = name.substring(0, name.length() - 6);
                            classname = classname.replace('/', '.');
                            loader.defineClassFromBytes(classname, buf);
                            if (!classname.endsWith(conduitClassName) || (c = Class.forName(classname)).isInterface()) continue;
                            Method[] methods = c.getDeclaredMethods();
                            int i = 0;
                            while (i < methods.length) {
                                Method m = methods[i];
                                if (m.getName().equals(SYNC_FUNC_NAME)) {
                                    conduitDriverClass = classname;
                                }
                                ++i;
                            }
                            continue;
                        }
                        loader.putLocalResource(name, buf, type);
                    }
                }
                catch (IOException ex) {
                    JarLoader.debug("IOException loading archive: " + ex);
                    throw ex;
                }
                catch (Throwable th) {
                    JarLoader.debug("Caught " + th + " in loadit()");
                    th.printStackTrace();
                    throw new IOException("loadJar caught: " + th);
                }
                Object var5_17 = null;
                if (zis == null) break block16;
            }
            catch (Throwable throwable) {
                Object var5_18 = null;
                if (zis == null) throw throwable;
                try {
                    zis.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            zis.close();
        }
        if (!empty) return;
        throw new IOException("JAR file is corrupt or empty");
    }
}

