/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Logger;

import com.sun.pdasync.SyncUtils.ViewNotifierEvent;
import com.sun.pdasync.SyncUtils.ViewNotifierListener;
import java.util.Vector;

public final class Logger {
    protected Vector viewNotifierListeners;
    private static int debugLevel = 0;
    private static boolean dbgCmdLine = false;
    public static Logger logger;

    public Logger(int debug) {
        debugLevel = debug;
        this.viewNotifierListeners = new Vector();
        logger = this;
    }

    public void addViewNotifierListener(ViewNotifierListener l) {
        this.viewNotifierListeners.addElement(l);
    }

    public static void doDebugLogging(String msg, int level) {
        Logger.doDebugLogging(msg, level, true);
    }

    public static void doDebugLogging(String msg, int level, boolean newLine) {
        if (debugLevel == 0) {
            return;
        }
        if (logger != null && level >= debugLevel) {
            if (newLine) {
                msg = String.valueOf(msg) + "\n";
            }
            logger.notifyListeners(-1, msg, 0);
        }
    }

    public static void doLogging(String msg) {
        Logger.doLogging(msg, true);
    }

    public static void doLogging(String msg, int err) {
        Logger.doLogging(msg, true, err);
    }

    public static void doLogging(String msg, boolean newLine) {
        Logger.doLogging(msg, newLine, 0);
    }

    public static void doLogging(String msg, boolean newLine, int err) {
        if (logger != null) {
            if (newLine) {
                msg = String.valueOf(msg) + "\n";
            }
            logger.notifyListeners(-1, msg, err);
        }
    }

    public static void doProgressMsg(String msg, int error) {
        if (logger != null) {
            logger.notifyListeners(7, msg, error);
        }
    }

    public static void doProgressUpdate(String msg, int error) {
        if (logger != null) {
            logger.notifyListeners(8, msg, error);
        }
    }

    public void fireEvent(ViewNotifierEvent e) {
        Vector list = (Vector)this.viewNotifierListeners.clone();
        int i = 0;
        while (i < list.size()) {
            ViewNotifierListener listener = (ViewNotifierListener)list.elementAt(i);
            listener.updateViewer(e);
            ++i;
        }
    }

    public static boolean getDebugCmdLineLevel() {
        return dbgCmdLine;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public void notifyListeners(int tick) {
        ViewNotifierEvent vne = new ViewNotifierEvent(this, 9, new Integer(tick), 0);
        this.fireEvent(vne);
    }

    public void notifyListeners(int noteType, String msg, int error) {
        ViewNotifierEvent vne = new ViewNotifierEvent(this, noteType, msg, error);
        this.fireEvent(vne);
    }

    public void notifyListeners(String info) {
        ViewNotifierEvent vne = new ViewNotifierEvent(this, 14, info, 0);
        this.fireEvent(vne);
    }

    public void notifyListeners(String info, boolean getPassword) {
        ViewNotifierEvent vne = getPassword ? new ViewNotifierEvent(this, 13, info, 0) : new ViewNotifierEvent(this, 12, info, 0);
        this.fireEvent(vne);
    }

    public void notifyListeners(Vector state, int error) {
        ViewNotifierEvent vne = new ViewNotifierEvent(this, 11, state, error);
        this.fireEvent(vne);
    }

    public void notifyListeners(boolean doit) {
        ViewNotifierEvent vne = new ViewNotifierEvent(this, 15, null, 0);
        this.fireEvent(vne);
    }

    public void removeViewNotifierListener(ViewNotifierListener l) {
        this.viewNotifierListeners.removeElement(l);
    }

    public static void setDebugCmdLine(boolean dbgLevel) {
        dbgCmdLine = dbgLevel;
    }

    public static void setDebugLevel(int dbgLevel) {
        debugLevel = dbgLevel;
    }
}

