/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.CommPort;

import com.sun.pdasync.CommPort.CommPortConst;
import com.sun.pdasync.CommPort.DataAvailableEvent;
import com.sun.pdasync.CommPort.DataAvailableListener;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public final class SerialPortCommunicator
implements SerialPortEventListener,
CommPortOwnershipListener {
    public static final int defaultRetries = 10;
    public static final int defaultRetryInterval = 4000;
    private String portName;
    int maxRetries;
    int retryInterval;
    public boolean dataAvailable;
    public CommPortIdentifier portId;
    private InputStream ins;
    private BufferedInputStream buffedIns;
    private OutputStream outs;
    private BufferedOutputStream buffedOuts;
    private SerialPort serialPort;
    boolean isOpen = false;
    protected Vector listeners;

    public SerialPortCommunicator(String portName) {
        this(portName, 10, 4000);
    }

    public SerialPortCommunicator(String portName, int maxRetries, int retryInterval) {
        this.portName = portName;
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
        this.dataAvailable = false;
        this.listeners = new Vector(2, 1);
    }

    public long ClosePort() {
        if (!this.isOpen) {
            return 0L;
        }
        if (this.serialPort != null) {
            try {
                this.outs.close();
                this.ins.close();
            }
            catch (IOException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
            }
            this.serialPort.close();
            this.isOpen = false;
            this.portId.removePortOwnershipListener((CommPortOwnershipListener)this);
        }
        return 0L;
    }

    public long ConfigPortStats(int dwBaud, byte DataBits, byte stopBits, byte parity, boolean bHardHand) throws UnsupportedCommOperationException {
        this.serialPort.setSerialPortParams(dwBaud, (int)DataBits, (int)stopBits, (int)parity);
        return 0L;
    }

    public boolean FlushOutputQueue(int dwTimeOutMilliSec) {
        try {
            this.ins.reset();
        }
        catch (IOException iOException) {}
        return true;
    }

    public int GetCurrentBaudRate() {
        return this.serialPort.getBaudRate();
    }

    public int GetMaxBaudRate(int rOsInfo) {
        return 57600;
    }

    public long GetPortStats() {
        return 0L;
    }

    public boolean GetQueueStats(int pcbInQue, int pcbOutQue) {
        return true;
    }

    public boolean IsOpen() {
        return this.isOpen;
    }

    public long OpenPort() throws PortInUseException {
        long err = CommPortConst.serErrNoError;
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)this.portName);
        }
        catch (NoSuchPortException e) {
            Logger.doDebugLogging(e.toString(), 1, true);
            err = CommPortConst.serErrNoSuchPort;
            return err;
        }
        if (this.portId.getPortType() == 1) {
            try {
                this.serialPort = (SerialPort)this.portId.open("pdasync", 20000);
            }
            catch (PortInUseException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrNoSuchPort;
                return err;
            }
            try {
                this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrUnsupportedOp;
                this.isOpen = false;
                return err;
            }
            try {
                this.ins = this.serialPort.getInputStream();
            }
            catch (IOException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrIOError;
                this.isOpen = false;
                return err;
            }
            this.buffedIns = new BufferedInputStream(this.ins);
            try {
                this.outs = this.serialPort.getOutputStream();
            }
            catch (IOException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrIOError;
                this.isOpen = false;
                return err;
            }
            this.buffedOuts = new BufferedOutputStream(this.outs);
            try {
                this.serialPort.addEventListener((SerialPortEventListener)this);
            }
            catch (TooManyListenersException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrIOError;
                this.isOpen = false;
                return err;
            }
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.notifyOnBreakInterrupt(true);
            try {
                this.serialPort.enableReceiveTimeout(2000);
            }
            catch (UnsupportedCommOperationException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrUnsupportedOp;
                this.isOpen = false;
                return err;
            }
            try {
                this.serialPort.enableReceiveThreshold(1);
            }
            catch (UnsupportedCommOperationException e) {
                Logger.doDebugLogging(e.toString(), 1, true);
                err = CommPortConst.serErrUnsupportedOp;
                this.isOpen = false;
                return err;
            }
            this.portId.addPortOwnershipListener((CommPortOwnershipListener)this);
            this.isOpen = true;
        }
        return err;
    }

    public long PurgeCommQueues(int eQueueId) {
        this.ClosePort();
        return 0L;
    }

    public boolean ReadBytePresent() throws IOException {
        try {
            this.dataAvailable = this.buffedIns.available() > 0;
        }
        catch (IOException iOException) {}
        return this.dataAvailable;
    }

    public long ReadBytes(byte[] readBytes, long len, long[] rActual) {
        long retval = 0L;
        int numRead = 0;
        int total_read = 0;
        if (this.serialPort == null || this.ins == null || this.buffedIns == null) {
            return CommPortConst.serErrIOError;
        }
        try {
            while ((long)total_read != len) {
                numRead = this.ins.read(readBytes, total_read, (int)len);
                total_read += numRead;
                if (numRead != 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        if ((long)total_read == len) {
            rActual[0] = total_read;
        } else {
            retval = CommPortConst.serErrRecvTimedOut;
        }
        this.dataAvailable = false;
        return retval;
    }

    public long ReadSingleByte(byte[] readBytes) {
        long[] actual = new long[]{0L};
        return this.ReadBytes(readBytes, 1L, actual);
    }

    public long WriteBytes(byte[] writeBytes, long len, long[] rActual) {
        try {
            this.outs.write(writeBytes, 0, (int)len);
        }
        catch (IOException e) {
            Logger.doDebugLogging("OutputStream write error: " + e.toString(), 1, true);
        }
        return 0L;
    }

    public void addDataAvailableListener(DataAvailableListener l) {
        if (this.listeners != null && !this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void fireEvent(DataAvailableEvent e) {
        Vector list = (Vector)this.listeners.clone();
        int i = 0;
        while (i < list.size()) {
            DataAvailableListener listener = (DataAvailableListener)list.elementAt(i);
            switch (e.getID()) {
                case 0: {
                    listener.pollConnection(e);
                }
                case 1: {
                    listener.ignoreConnection(e);
                }
                case 2: {
                    listener.abortConnection(e);
                }
            }
            ++i;
        }
    }

    public static Vector getNamesOfPorts() {
        Vector<String> portNames = new Vector<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier aPort = (CommPortIdentifier)portList.nextElement();
            if (aPort.getPortType() != 1) continue;
            portNames.addElement(aPort.getName());
        }
        return portNames;
    }

    public void logDebugReadWriteBytes(byte[] readWriteBytes, int numBytes, boolean readWrite) {
        String header = readWrite ? "READ from Serial Port:   ( " + numBytes + " Bytes )\n" : "WRITTEN to Serial Port:   ( " + numBytes + " Bytes )\n";
        String str = SyncUtils.convertToStringOfHex(readWriteBytes, 0, numBytes);
        Logger.doDebugLogging(String.valueOf(header) + str + "\n", 1, true);
    }

    public static void main(String[] args) {
        SerialPortCommunicator rw = new SerialPortCommunicator("/dev/term/a");
        try {
            rw.OpenPort();
        }
        catch (PortInUseException portInUseException) {
            Logger.doDebugLogging("Port is in use", 1, true);
        }
        byte[] someBytes = new byte[1200];
        long[] actual = new long[]{0L};
        long retVal = 0L;
        int i = 0;
        while (i <= rw.maxRetries) {
            retVal = rw.ReadBytes(someBytes, 100L, actual);
            if (retVal == CommPortConst.serErrNoError) break;
            Logger.doDebugLogging(new Long(retVal).toString(), 1, true);
            ++i;
        }
    }

    public void ownershipChange(int type) {
        if (type == 3) {
            return;
        }
    }

    public void removeDataAvailableListener(DataAvailableListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void serialEvent(SerialPortEvent se) {
        switch (se.getEventType()) {
            case 1: {
                this.dataAvailable = true;
                DataAvailableEvent dae = new DataAvailableEvent(this, this.dataAvailable, 0, se);
                this.fireEvent(dae);
                break;
            }
        }
    }
}

