/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.System;

import com.sun.pdasync.Conduits.System.SystemProperties;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class SystemPropsUI
extends PropsUI {
    private static Locale theLocale;
    private static ResourceBundle systemRes;
    private static ResourceBundle commonRes;
    private static ResourceBundle systemTips;
    protected JRadioButton pdaOverwriteDT;
    protected JRadioButton dtOverwritePDA;
    private SystemProperties systemProps;

    static {
        try {
            theLocale = Locale.getDefault();
            systemRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SystemPropsUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            systemTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SystemPropsUITips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
        }
    }

    public SystemPropsUI(JFrame parent, SystemProperties systemProps) {
        super(parent, systemRes.getString("Configure System Conduit"));
        this.systemProps = systemProps;
        this.userProperties = this.systemProps;
        this.setDialogMessage(this.createPropsPanel());
        ((JDialog)((Object)this)).setContentPane(this.propsOptions);
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
    }

    private Object createPropsPanel() {
        HelpBroker helpBroker = null;
        PropsUI.PropsUIChangeListener propsUIChangeListener = new PropsUI.PropsUIChangeListener((PropsUI)this);
        JPanel dirPanel = new JPanel(new GridBagLayout(), true){

            public Insets getInsets() {
                return new Insets(0, 0, 0, 10);
            }
        };
        int gridY = 0;
        JLabel changeLabel = new JLabel(systemRes.getString("Changes:"));
        ButtonGroup dirGroup = new ButtonGroup();
        this.pdaOverwriteDT = new JRadioButton(systemRes.getString("PDA overwrites desktop"));
        this.dtOverwritePDA = new JRadioButton(systemRes.getString("Desktop overwrites PDA"));
        this.pdaOverwriteDT.addActionListener((ActionListener)propsUIChangeListener);
        this.dtOverwritePDA.addActionListener((ActionListener)propsUIChangeListener);
        dirGroup.add(this.pdaOverwriteDT);
        dirGroup.add(this.dtOverwritePDA);
        try {
            CommandPane.addComponent((Container)dirPanel, (Component)changeLabel, (int)0, (int)gridY, (int)1, (int)1, (int)1, (int)17, (Insets)new Insets(15, 15, 0, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)dirPanel, (Component)this.pdaOverwriteDT, (int)-1, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(15, 5, 0, 15));
            ++gridY;
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)dirPanel, (Component)this.dtOverwritePDA, (int)1, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(5, 5, 0, 15));
            ++gridY;
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)dirPanel, (Component)new JSeparator(), (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)10, (Insets)new Insets(15, 0, 0, 0));
            ++gridY;
        }
        catch (AWTException aWTException) {}
        this.setDialogParameters();
        this.propsChanged = false;
        helpBroker = PDASyncHelp.enableContextHelp((Component)this.help, (String)"pda_systemConfig");
        if (helpBroker == null) {
            this.help.setEnabled(false);
        } else {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        ((Container)((Object)this)).validate();
        ((Window)((Object)this)).pack();
        return dirPanel;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("System Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        SystemProperties systemProps = new SystemProperties();
        SystemPropsUI cprops = new SystemPropsUI(fr, systemProps);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((Dialog)((Object)SystemPropsUI.this)).show();
                ((Dialog)((Object)SystemPropsUI.this)).setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    public void setDialogParameters() {
        this.pdaOverwriteDT.setSelected(this.systemProps.pdaOverwriteDT);
        this.dtOverwritePDA.setSelected(this.systemProps.dtOverwritePDA);
    }

    public void updateFromUI() {
        this.systemProps.pdaOverwriteDT = this.pdaOverwriteDT.isSelected();
        this.systemProps.dtOverwritePDA = this.dtOverwritePDA.isSelected();
    }
}

