/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.System;

import com.sun.pdasync.Conduits.System.SystemProperties;
import com.sun.pdasync.Conduits.System.SystemPropsUI;
import com.sun.pdasync.Conduits.Utils.DatabaseHdrType;
import com.sun.pdasync.Conduits.Utils.RecordEntryType;
import com.sun.pdasync.Conduits.Utils.RsrcEntryType;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncMgr.CDbList;
import com.sun.pdasync.SyncMgr.CRawRecordInfo;
import com.sun.pdasync.SyncMgr.CSyncProperties;
import com.sun.pdasync.SyncMgr.SyncDefs;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;
import palm.conduit.SystemInfo;

public class SystemConduit
implements Conduit,
Serializable {
    private static final int ROM_VER_1 = 1;
    private static final int ROM_VER_2 = 2;
    private static final int ROM_VER_3 = 3;
    private static Locale theLocale;
    private static ResourceBundle systemRes;
    CSyncProperties syncProps;
    SystemInfo sysInfo;
    CDbList remoteDB;
    int dbHandle;
    long headerSize;
    long appInfoSize;
    long sortInfoSize;
    String localFileName;
    BufferedOutputStream localFileOS;
    SystemProperties systemProps = new SystemProperties();
    private Vector dataP;
    private Vector recordP;
    private SystemPropsUI systemPropsUI;

    static {
        try {
            theLocale = Locale.getDefault();
            systemRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.SystemConduitMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
        }
    }

    public int configure(ConfigureConduitInfo info) {
        if (this.systemPropsUI == null) {
            this.systemPropsUI = new SystemPropsUI(SyncUtils.getParentOfAllConduits(), this.systemProps);
        }
        ((Dialog)((Object)this.systemPropsUI)).show();
        info.syncPermanent = this.systemProps.dtOverwritePDA ? 3 : (this.systemProps.pdaOverwriteDT ? 2 : 0);
        info.syncTemporary = info.syncPermanent;
        return 0;
    }

    void createLocalFileName() {
        String fname = new String(SyncConstants.BACKUP_DIR_PATH);
        SyncUtils.mkdirIfNotExist((String)fname);
        if (!fname.endsWith(SyncConstants.SEPARATOR)) {
            fname = String.valueOf(fname) + SyncConstants.SEPARATOR;
        }
        fname = String.valueOf(fname) + new String(this.remoteDB.m_Name);
        fname = fname.trim();
        fname = (this.remoteDB.m_DbFlags_u & 1) != 0 ? String.valueOf(fname) + ".prc" : String.valueOf(fname) + ".pdb";
        this.localFileName = fname;
        this.doDebugLog("localFileName =" + this.localFileName + ", len= " + this.localFileName.length());
    }

    void doDebugLog(String message) {
        Logger.doDebugLogging((String)message, (int)5, (boolean)true);
    }

    void doLog(String message) {
        Log.sunwAddEntry((String)(String.valueOf(systemRes.getString("System Conduit (backup): ")) + message));
    }

    boolean isBackupNeeded() {
        this.createLocalFileName();
        if (SyncDefs.SYNCROMVMAJOR((int)this.sysInfo.romSoftVersion) == 1L) {
            return true;
        }
        DatabaseHdrType dbhLocal = new DatabaseHdrType();
        if (!this.readLocalFileHeader(this.localFileName, dbhLocal)) {
            return true;
        }
        if (dbhLocal.creator_u != this.remoteDB.m_Creator_u) {
            return true;
        }
        String dbLocalName = new String(dbhLocal.name);
        String dbRemoteName = new String(this.remoteDB.m_Name);
        if (!dbLocalName.equals(dbRemoteName)) {
            return true;
        }
        if (dbhLocal.creationDate_u != SyncUtils.millisecToSecond((long)this.remoteDB.m_CreateDate)) {
            this.doDebugLog("creationDate is different.");
            return true;
        }
        if (dbhLocal.modificationDate_u == SyncUtils.millisecToSecond((long)this.remoteDB.m_ModDate) && this.remoteDB.m_BackupDate != 0L) {
            this.doDebugLog("modDate same and remoteDB.m_BackupDate != 0, no backup needed.");
            return false;
        }
        this.doDebugLog("either modDate different or remoteDB.m_BackupDate = 0. need backup.");
        return true;
    }

    public String name() {
        return systemRes.getString("System");
    }

    public void open(CSyncProperties props) {
        this.syncProps = props;
        if (props.m_SyncType == 6 || props.m_SyncType == 3 || props.m_SyncType == 4) {
            return;
        }
        this.recordP = new Vector();
        this.dataP = new Vector();
        try {
            this.sysInfo = SyncManager.readSystemInfo();
            int i = 0;
            while (i < props.m_RemoteCount) {
                this.remoteDB = props.m_RemoteDbList[i];
                if ((this.remoteDB.m_DbFlags_u & 2) == 0) {
                    this.processRemoteDB();
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    public void open(SyncProperties props) {
        CSyncProperties temp = new CSyncProperties();
        props.copyToCSyncProperties(temp);
        this.open(temp);
    }

    void process10RomData() throws SyncException {
        this.dbHandle = SyncManager.openDB((String)new String(this.remoteDB.m_Name), (int)this.remoteDB.m_CardNum, (int)128);
        int recCount = SyncManager.getDBRecordCount((int)this.dbHandle);
        this.remoteDB.m_RecCount = recCount;
        try {
            try {
                this.localFileOS = new BufferedOutputStream(new FileOutputStream(this.localFileName));
                this.processDBData();
                this.localFileOS.close();
                SyncUtils.setFilePermission((String)this.localFileName, (String)"400");
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var3_3 = null;
                SyncManager.closeDB((int)this.dbHandle);
                return;
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            SyncManager.closeDB((int)this.dbHandle);
            throw throwable;
        }
        SyncManager.closeDB((int)this.dbHandle);
    }

    void process20RomData() throws SyncException {
        int openMode = (this.remoteDB.m_DbFlags_u & 1) == 0 && this.remoteDB.m_BackupDate == 0L ? 192 : 128;
        this.dbHandle = SyncManager.openDB((String)new String(this.remoteDB.m_Name), (int)this.remoteDB.m_CardNum, (int)openMode);
        int recCount = SyncManager.getDBRecordCount((int)this.dbHandle);
        this.remoteDB.m_RecCount = recCount;
        try {
            try {
                this.localFileOS = new BufferedOutputStream(new FileOutputStream(this.localFileName));
                this.processDBData();
                if (this.remoteDB.m_BackupDate == 0L) {
                    SyncManager.resetSyncFlags((int)this.dbHandle);
                }
                this.localFileOS.close();
                SyncUtils.setFilePermission((String)this.localFileName, (String)"400");
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var4_4 = null;
                SyncManager.closeDB((int)this.dbHandle);
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            SyncManager.closeDB((int)this.dbHandle);
            throw throwable;
        }
        SyncManager.closeDB((int)this.dbHandle);
    }

    void process30RomData() throws SyncException {
        this.doDebugLog("process30RomData...");
        this.dbHandle = SyncManager.openDB((String)new String(this.remoteDB.m_Name), (int)this.remoteDB.m_CardNum, (int)128);
        int recCount = SyncManager.getDBRecordCount((int)this.dbHandle);
        this.doDebugLog("dbHandle -- " + this.dbHandle);
        this.doDebugLog("recCount -- " + recCount);
        this.remoteDB.m_RecCount = recCount;
        try {
            this.localFileOS = new BufferedOutputStream(new FileOutputStream(this.localFileName));
            this.processDBData();
            this.localFileOS.close();
            SyncUtils.setFilePermission((String)this.localFileName, (String)"400");
        }
        catch (Throwable t) {
            SyncManager.closeDB((int)this.dbHandle);
            t.printStackTrace();
            return;
        }
        SyncManager.closeDBEx((byte)((byte)this.dbHandle), (byte)-128);
    }

    void processDBData() throws SyncException, IOException {
        byte[] sortInfoBytes;
        byte[] appInfoBytes;
        this.headerSize = 0L;
        this.appInfoSize = 0L;
        this.sortInfoSize = 0L;
        int appInfoID = 0;
        int sortInfoID = 0;
        this.headerSize = (this.remoteDB.m_DbFlags_u & 1) != 0 ? 78L + this.remoteDB.m_RecCount * 10L : 78L + this.remoteDB.m_RecCount * 8L;
        this.headerSize += 2L;
        String dbName = new String(this.remoteDB.m_Name);
        this.doDebugLog("headerSize = " + this.headerSize);
        this.doDebugLog("dbName = " + dbName);
        try {
            appInfoBytes = SyncManager.readDBAppInfoBlock((int)this.dbHandle, (String)dbName);
            if (appInfoBytes.length > 0) {
                this.appInfoSize = appInfoBytes.length;
                appInfoID = (int)this.headerSize;
            }
        }
        catch (SyncException e) {
            if (e.errorCode == 16387) {
                appInfoBytes = new byte[]{};
            }
            throw e;
        }
        this.doDebugLog("appInfoBytes.length = " + appInfoBytes.length);
        try {
            sortInfoBytes = SyncManager.readDBSortInfoBlock((int)this.dbHandle, (String)dbName);
            if (sortInfoBytes.length > 0) {
                this.sortInfoSize = sortInfoBytes.length;
                sortInfoID = (int)(this.headerSize + this.appInfoSize);
            }
        }
        catch (SyncException e) {
            if (e.errorCode == 16387) {
                sortInfoBytes = new byte[]{};
            }
            throw e;
        }
        this.doDebugLog("sortInfoBytes.length = " + sortInfoBytes.length);
        this.doDebugLog("appInfoID = " + appInfoID);
        this.doDebugLog("sortInfoID = " + sortInfoID);
        DatabaseHdrType dbHeader = new DatabaseHdrType();
        dbHeader.name = this.remoteDB.m_Name;
        dbHeader.attributes_u = this.remoteDB.m_DbFlags_u;
        dbHeader.version_u = this.remoteDB.m_Version_u;
        dbHeader.creationDate_u = SyncUtils.millisecToSecond((long)this.remoteDB.m_CreateDate);
        dbHeader.modificationDate_u = SyncUtils.millisecToSecond((long)this.remoteDB.m_ModDate);
        dbHeader.lastBackupDate_u = SyncUtils.millisecToSecond((long)this.remoteDB.m_BackupDate);
        dbHeader.modificationNumber_u = this.remoteDB.m_ModNumber_u;
        dbHeader.appInfoID_u = appInfoID;
        dbHeader.sortInfoID_u = sortInfoID;
        dbHeader.type_u = this.remoteDB.m_DbType_u;
        dbHeader.creator_u = this.remoteDB.m_Creator_u;
        dbHeader.uniqueIDSeed_u = 0;
        dbHeader.nextRecordListID_u = 0;
        dbHeader.numRecords_u = (short)this.remoteDB.m_RecCount;
        boolean resFlag = false;
        if ((this.remoteDB.m_DbFlags_u & 1) != 0) {
            resFlag = true;
            this.processResourceEntries();
        } else {
            this.processRecordEntries();
        }
        dbHeader.writeData(this.localFileOS);
        int i = 0;
        while (i < this.recordP.size()) {
            if (resFlag) {
                RsrcEntryType resEntry = (RsrcEntryType)this.recordP.elementAt(i);
                resEntry.writeData(this.localFileOS);
            } else {
                RecordEntryType recEntry = (RecordEntryType)this.recordP.elementAt(i);
                recEntry.writeData(this.localFileOS);
            }
            ++i;
        }
        byte[] extra = new byte[]{0, 0};
        this.localFileOS.write(extra);
        this.localFileOS.write(appInfoBytes);
        this.localFileOS.write(sortInfoBytes);
        int i2 = 0;
        while (i2 < this.dataP.size()) {
            byte[] bytes = (byte[])this.dataP.elementAt(i2);
            this.localFileOS.write(bytes);
            ++i2;
        }
    }

    void processRecordEntries() throws SyncException, IOException {
        long offset = this.headerSize + this.appInfoSize + this.sortInfoSize;
        int i = 0;
        while ((long)i < this.remoteDB.m_RecCount) {
            CRawRecordInfo crawRecInfo = new CRawRecordInfo();
            crawRecInfo.m_FileHandle_u = (byte)this.dbHandle;
            crawRecInfo.m_RecId = 0L;
            crawRecInfo.m_RecIndex_u = (short)i;
            SyncManager.sunwReadRawRecordByIndex((int)this.dbHandle, (CRawRecordInfo)crawRecInfo);
            if ((crawRecInfo.m_Attribs_u & 8) != 0) {
                crawRecInfo.m_Attribs_u = (byte)(crawRecInfo.m_Attribs_u & 0xF0 | 0x80);
            }
            RecordEntryType recEntry = new RecordEntryType();
            recEntry.localChunkID_u = (int)offset;
            recEntry.attributes_u = (byte)(crawRecInfo.m_Attribs_u & 0xF0 | crawRecInfo.m_CatId & 0xF);
            recEntry.setUniqueID((int)crawRecInfo.m_RecId);
            this.recordP.addElement(recEntry);
            byte[] bytes = new byte[crawRecInfo.m_RecSize_u];
            System.arraycopy(crawRecInfo.m_pBytes_u, 0, bytes, 0, bytes.length);
            this.dataP.addElement(bytes);
            offset += (long)crawRecInfo.m_RecSize_u;
            ++i;
        }
    }

    void processRemoteDB() throws SyncException {
        if (this.isBackupNeeded()) {
            this.doDebugLog("Backup is needed");
            File file = new File(this.localFileName);
            if (file.exists()) {
                file.delete();
            }
            if (this.recordP.size() > 0) {
                this.recordP.removeAllElements();
            }
            if (this.dataP.size() > 0) {
                this.dataP.removeAllElements();
            }
            try {
                switch ((int)SyncDefs.SYNCROMVMAJOR((int)this.sysInfo.romSoftVersion)) {
                    case 1: {
                        this.process10RomData();
                        break;
                    }
                    case 2: {
                        this.process20RomData();
                        break;
                    }
                    default: {
                        this.process30RomData();
                    }
                }
                this.doLog(String.valueOf(SyncUtils.getStringFromBytes((byte[])this.remoteDB.m_Name)) + systemRes.getString(" has been backed up."));
            }
            catch (SyncException e) {
                this.doLog(String.valueOf(systemRes.getString("Error in getting database from palm, skipping ")) + new String(this.remoteDB.m_Name));
                this.doDebugLog("Exception caught in backing up " + new String(this.remoteDB.m_Name) + " " + e.toString());
            }
        } else {
            this.doDebugLog("Backup is *NOT* needed");
        }
    }

    void processResourceEntries() throws SyncException, IOException {
        long offset = this.headerSize + this.appInfoSize + this.sortInfoSize;
        int i = 0;
        while ((long)i < this.remoteDB.m_RecCount) {
            CRawRecordInfo crawRecInfo = new CRawRecordInfo();
            crawRecInfo.m_FileHandle_u = (byte)this.dbHandle;
            crawRecInfo.m_RecId = 0L;
            crawRecInfo.m_RecIndex_u = (short)i;
            SyncManager.sunwReadResRawRecordByIndex((int)this.dbHandle, (CRawRecordInfo)crawRecInfo, (boolean)true);
            RsrcEntryType rsrcEntry = new RsrcEntryType();
            rsrcEntry.type_u = (int)crawRecInfo.m_RecId;
            rsrcEntry.id_u = crawRecInfo.m_RecIndex_u;
            rsrcEntry.localChunkID_u = (int)offset;
            this.recordP.addElement(rsrcEntry);
            byte[] bytes = new byte[crawRecInfo.m_RecSize_u];
            System.arraycopy(crawRecInfo.m_pBytes_u, 0, bytes, 0, bytes.length);
            this.dataP.addElement(bytes);
            offset += (long)crawRecInfo.m_RecSize_u;
            ++i;
        }
    }

    boolean readLocalFileHeader(String fname, DatabaseHdrType header) {
        File file = new File(fname);
        if (!file.exists() | file.length() < 78L) {
            return false;
        }
        try {
            BufferedInputStream fi = new BufferedInputStream(new FileInputStream(fname));
            header.readData(fi);
            fi.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

