/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.client;

import com.sun.opencard.cmd.OCFDisable;
import com.sun.opencard.cmd.OCFEnable;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.gui.client.plugin.ClientPluginGuiCtx;
import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginException;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import java.util.Hashtable;
import java.util.Properties;

public class CDEClientPlugin
implements SmartCardPlugin {
    private boolean enableSmartCard = false;
    private boolean ignoreCardRemoval = false;
    private boolean reauthAfterCardRemoval = true;
    private static String timeoutUnits = "seconds";
    private int cardRemovalTimeout = 0;
    private int cardRemovalTimeoutMax = 120;
    private int reauthTimeout = 20;
    private int reauthTimeoutMax = 120;
    private int cardRemovalLogoutWait = 30;
    private int cardRemovalLogoutWaitMax = 120;
    private static final String cardRemovalTimeoutProp = "cardRemovalTimeout";
    private static final String ignoreCardRemovalProp = "ignoreCardRemoval";
    private static final String reauthAfterCardRemovalProp = "reauthAfterCardRemoval";
    private static final String reauthTimeoutProp = "reauthTimeout";
    private static final String cardRemovalLogoutWaitProp = "cardRemovalLogoutWait";
    private static final String useSmartCardProp = "useSmartCard";
    private PluginSlider cardRemovalTimeoutSlider;
    private PluginSlider reauthTimeoutSlider;
    private PluginSlider cardRemovalLogoutWaitSlider;
    private PluginCheckBox ignoreCardRemovalCheckbox;
    private PluginCheckBox reauthAfterCardRemovalCheckbox;
    private ClientPluginGuiCtx pgc;
    private Smartcard dtloginSC;
    private Smartcard dtsessionSC;
    private Smartcard defaultSC = null;
    private Properties cfgProps;
    private static final String inactivePropName = "inactive";
    private boolean debug = System.getProperty("debug") != null;

    public CDEClientPlugin(Properties p) throws PluginException {
        System.out.println("WRONG CONSTRUCTOR!");
    }

    public CDEClientPlugin(Properties p, ClientPluginGuiCtx guicontext) throws PluginException {
        this.pgc = guicontext;
        this.cfgProps = p;
        if (this.pgc == null) {
            throw new PluginException("Error with ClientPluginGuiCtx (null)");
        }
        this.pgc.setCallback((SmartCardPlugin)this);
        if (this.debug) {
            System.out.println("\n======= CDEClientPlugin =========================================");
        }
        try {
            this.dtloginSC = new Smartcard("dtlogin");
            this.defaultSC = this.dtsessionSC = new Smartcard("dtsession");
        }
        catch (Exception e) {
            if (this.debug) {
                this.pgc.popupError("OCF Server Error", e.toString());
            }
            throw new PluginException(e.toString());
        }
        if (this.getDefaults(this.dtloginSC, useSmartCardProp, this.enableSmartCard) && this.getDefaults(this.dtsessionSC, useSmartCardProp, this.enableSmartCard)) {
            this.enableSmartCard = true;
        }
        this.cardRemovalTimeout = this.getDefaults(cardRemovalTimeoutProp, this.cardRemovalTimeout);
        this.reauthTimeout = this.getDefaults(reauthTimeoutProp, this.reauthTimeout);
        this.cardRemovalLogoutWait = this.getDefaults(cardRemovalLogoutWaitProp, this.cardRemovalLogoutWait);
        this.ignoreCardRemoval = this.getDefaults(ignoreCardRemovalProp, this.ignoreCardRemoval);
        this.reauthAfterCardRemoval = this.getDefaults(reauthAfterCardRemovalProp, this.reauthAfterCardRemoval);
        if (this.debug) {
            System.out.println("[Constructor] CDEClientPlugin Parameters:\n           enableSmartCard = " + this.enableSmartCard + "\n" + "        cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "         ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "    reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "             reauthTimeout = " + this.reauthTimeout + "\n" + "     cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        PluginTab tab2 = this.pgc.addTab("Timeouts");
        PluginTab tab1 = this.pgc.addTab("Options");
        this.ignoreCardRemovalCheckbox = tab1.addCheckBox("Ignore Card Removal");
        if (this.ignoreCardRemoval) {
            this.ignoreCardRemovalCheckbox.setChecked();
        } else {
            this.ignoreCardRemovalCheckbox.setUnchecked();
        }
        this.reauthAfterCardRemovalCheckbox = tab1.addCheckBox("Reauthenticate After Card Removal");
        if (this.reauthAfterCardRemoval) {
            this.reauthAfterCardRemovalCheckbox.setChecked();
        } else {
            this.reauthAfterCardRemovalCheckbox.setUnchecked();
        }
        this.cardRemovalTimeoutSlider = tab2.addSlider("Card Removal Timeout (" + timeoutUnits + ")", 0, this.cardRemovalTimeoutMax);
        this.cardRemovalTimeoutSlider.setValue(this.cardRemovalTimeout);
        this.reauthTimeoutSlider = tab2.addSlider("Reauthentication Timeout (" + timeoutUnits + ")", 0, this.reauthTimeoutMax);
        this.reauthTimeoutSlider.setValue(this.reauthTimeout);
        this.cardRemovalLogoutWaitSlider = tab2.addSlider("Card Removal Logout Wait Timeout (" + timeoutUnits + ")", 0, this.cardRemovalLogoutWaitMax);
        this.cardRemovalLogoutWaitSlider.setValue(this.cardRemovalLogoutWait);
        if (this.enableSmartCard) {
            ((Hashtable)p).remove(inactivePropName);
        } else {
            p.setProperty(inactivePropName, "true");
        }
    }

    public void activeState(boolean state) {
        this.enableSmartCard = state;
        if (this.debug) {
            System.out.println("activeState() enableSmartCard = " + this.enableSmartCard);
        }
    }

    public void buttonAction(PluginButton b) {
    }

    public boolean cancelOperation() {
        return true;
    }

    public void checkBoxAction(PluginCheckBox cb) {
        if (cb == this.ignoreCardRemovalCheckbox) {
            this.ignoreCardRemoval = this.ignoreCardRemovalCheckbox.getState();
        }
        if (cb == this.reauthAfterCardRemovalCheckbox) {
            this.reauthAfterCardRemoval = this.reauthAfterCardRemovalCheckbox.getState();
        }
    }

    public void comboAction(PluginComboBox cb) {
    }

    private void disableCDEsmartcard() {
        this.disableCDEsmartcard(true);
    }

    private boolean disableCDEsmartcard(boolean doErrorPopup) {
        try {
            this.dtloginSC.setClientProperty(useSmartCardProp, "False");
            this.dtsessionSC.setClientProperty(useSmartCardProp, "False");
        }
        catch (Exception e) {
            if (doErrorPopup) {
                this.pgc.popupError("Error Disabling CDE for Smart Card Authentication", "Can't set CDE properties in OCF server");
            }
            if (this.debug) {
                System.out.println("disableCDEsmartcard error: " + e.toString());
            }
            return false;
        }
        return true;
    }

    private void disablePAMsmartcard() {
        try {
            new OCFDisable().disablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Disabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private void enableCDEsmartcard() {
        try {
            this.dtsessionSC.setClientProperty(cardRemovalTimeoutProp, Integer.toString(this.cardRemovalTimeout));
            this.dtsessionSC.setClientProperty(reauthTimeoutProp, Integer.toString(this.reauthTimeout));
            this.dtsessionSC.setClientProperty(cardRemovalLogoutWaitProp, Integer.toString(this.cardRemovalLogoutWait));
            this.dtsessionSC.setClientProperty(ignoreCardRemovalProp, new Boolean(this.ignoreCardRemoval).toString());
            this.dtsessionSC.setClientProperty(reauthAfterCardRemovalProp, new Boolean(this.reauthAfterCardRemoval).toString());
            this.dtloginSC.setClientProperty(useSmartCardProp, "True");
            this.dtsessionSC.setClientProperty(useSmartCardProp, "True");
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println("enableCDEsmartcard error: " + e.toString());
            }
            String errMsg = "Can't set CDE properties in OCF server";
            if (!this.disableCDEsmartcard(false)) {
                errMsg = String.valueOf(errMsg) + "\nCan't disable CDE Smart Card Authentication";
            }
            this.pgc.popupError("Error Enabling CDE for Smart Card Authentication", errMsg);
        }
    }

    private void enablePAMsmartcard() {
        try {
            new OCFEnable().enablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Enabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private String getDefaults(Smartcard sc, String propName) {
        String propValue;
        block4: {
            propValue = null;
            String clientRootPrefix = "root.";
            try {
                propValue = sc.getClientProperty(String.valueOf(clientRootPrefix) + propName, null);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("unable to get OCF property for client: [" + sc.getClientName() + "] [" + clientRootPrefix + propName + "]");
                }
                if ((propValue = this.cfgProps.getProperty(propName)) != null || !this.debug) break block4;
                System.out.println("unable to get CFG property: [" + propName + "]");
            }
        }
        if (propValue != null && this.debug) {
            System.out.println("property value: [" + propValue + "]");
        }
        return propValue;
    }

    private boolean getDefaults(Smartcard sc, String propName, boolean defaultValue) {
        String propValue = this.getDefaults(sc, propName);
        if (propValue != null) {
            return Boolean.valueOf(propValue);
        }
        return defaultValue;
    }

    private String getDefaults(String propName) {
        return this.getDefaults(this.defaultSC, propName);
    }

    private int getDefaults(String propName, int defaultValue) {
        try {
            return Integer.parseInt(this.getDefaults(propName));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private boolean getDefaults(String propName, boolean defaultValue) {
        return this.getDefaults(this.defaultSC, propName, defaultValue);
    }

    public Properties okButtonPushed(boolean activeState) {
        this.enableSmartCard = activeState;
        Properties ap = new Properties();
        if (this.enableSmartCard) {
            this.enableCDEsmartcard();
            this.enablePAMsmartcard();
        } else {
            this.disableCDEsmartcard();
            this.disablePAMsmartcard();
        }
        if (this.debug) {
            System.out.println("[OK|Apply] CDEClientPlugin Parameters:\n           enableSmartCard = " + this.enableSmartCard + "\n" + "        cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "         ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "    reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "             reauthTimeout = " + this.reauthTimeout + "\n" + "     cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        return ap;
    }

    public void passwordAction(PluginPassword pp) {
    }

    public void sliderAction(PluginSlider sl) {
        if (sl == this.cardRemovalTimeoutSlider) {
            this.cardRemovalTimeout = this.cardRemovalTimeoutSlider.getValue();
        }
        if (sl == this.reauthTimeoutSlider) {
            this.reauthTimeout = this.reauthTimeoutSlider.getValue();
        }
        if (sl == this.cardRemovalLogoutWaitSlider) {
            this.cardRemovalLogoutWait = this.cardRemovalLogoutWaitSlider.getValue();
        }
    }

    public void textAction(PluginTextField tf) {
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }
}

