/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.applet;

import com.sun.ami.common.SunAMI;
import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.KeyImportCardService;
import com.sun.smartcard.PinCardService;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.TimeoutSpec;
import com.sun.smartcard.UserInfo;
import com.sun.smartcard.UserInfoCardService;
import com.sun.smartcard.gui.client.plugin.AppletConfigPluginGuiCtx;
import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginException;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SolarisAuthAppletPlugin
implements SmartCardPlugin {
    private String cardName;
    private String readerName;
    private String AID;
    private Smartcard sc;
    private Card card;
    PinCardService pcs;
    UserInfoCardService uics;
    KeyImportCardService kics;
    private String currentPIN;
    private PluginTab PIN_tab;
    private PluginPassword newPIN_pw;
    private PluginPassword retypedPIN_pw;
    private PluginButton changePIN_button;
    private PluginButton clearPIN_button;
    private PluginTab UserInfo_tab;
    private PluginTextField userProfileName_tf;
    private PluginTextField userName_tf;
    private PluginPassword userPassword_pw;
    private PluginButton UI_Get_button;
    private PluginButton UI_Set_button;
    private PluginButton UI_Delete_button;
    private boolean kicsSupported = false;
    private PluginTab RSAKey_tab = null;
    private PluginTextField RSAuserProfileName_tf = null;
    private PluginButton importRSAKey_button = null;
    private String RSAkey_dir = null;
    private PluginTab PKICert_tab = null;
    private PluginTextField PKIuserProfileName_tf = null;
    private PluginButton exportPKICert_button = null;
    private PluginButton importPKICert_button = null;
    private String PKICert_dir = null;
    private AppletConfigPluginGuiCtx pgc;
    private boolean debug = System.getProperty("debug") != null;

    public SolarisAuthAppletPlugin(Hashtable p) throws PluginException {
        this(p, null);
    }

    public SolarisAuthAppletPlugin(Hashtable p, AppletConfigPluginGuiCtx guicontext) throws PluginException {
        this.pgc = guicontext;
        this.pgc.setCallback((SmartCardPlugin)this);
        if (this.debug) {
            System.out.println("\n======= SolarisAuthAppletPlugin =========================================");
        }
        String propsNotFound = null;
        this.cardName = (String)p.get("plugin.card");
        if (this.cardName == null) {
            propsNotFound = String.valueOf(propsNotFound) + "plugin.card ";
        }
        if ((this.readerName = (String)p.get("plugin.reader")) == null) {
            propsNotFound = String.valueOf(propsNotFound) + "plugin.reader ";
        }
        if ((this.AID = (String)p.get("aid")) == null) {
            propsNotFound = String.valueOf(propsNotFound) + "aid ";
        }
        if (propsNotFound != null) {
            throw new PluginException("Missing Properties: " + propsNotFound);
        }
        if (this.debug) {
            System.out.println("SolarisAuthAppletPlugin: from props:\n    cardName = [" + this.cardName + "]\n" + "  readerName = [" + this.readerName + "]\n" + "         AID = [" + this.AID + "]");
        }
        try {
            this.sc = new Smartcard("default");
            this.card = this.sc.waitForCardInserted(new CardSpec(this.cardName), new ReaderSpec(this.readerName), new AIDSpec(this.AID), new TimeoutSpec(0, 1));
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin: Card = [" + this.card.toString() + "]");
            }
            this.pcs = (PinCardService)this.card.getCardService("com.sun.smartcard.PinCardService");
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin: got PinCardService");
            }
            this.uics = (UserInfoCardService)this.card.getCardService("com.sun.smartcard.UserInfoCardService");
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin: got UserInfoCardService");
            }
            if (this.cardSupports_KeyImportCardService(this.card.getCardName())) {
                if (Security.getProvider("SunAMI") == null) {
                    Security.insertProviderAt((Provider)new SunAMI(), 1);
                }
                this.kics = (KeyImportCardService)this.card.getCardService("com.sun.smartcard.KeyImportCardService");
                if (this.debug) {
                    System.out.println("SolarisAuthAppletPlugin: got KeyImportCardService");
                }
                this.kicsSupported = true;
            }
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin: got all Card Services");
            }
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin: constructor exception:\n" + e.toString());
            }
            throw new PluginException("OCF Server Error");
        }
        this.currentPIN = "(not set)";
        this.PIN_tab = this.pgc.addTab("PIN");
        this.newPIN_pw = this.PIN_tab.addPassword("Type New PIN");
        this.newPIN_pw.setEchoChar('*');
        this.retypedPIN_pw = this.PIN_tab.addPassword("Retype New PIN");
        this.retypedPIN_pw.setEchoChar('*');
        this.changePIN_button = this.PIN_tab.addButton("Change");
        this.clearPIN_button = this.PIN_tab.addButton("Clear");
        this.UserInfo_tab = this.pgc.addTab("User Profiles");
        this.userProfileName_tf = this.UserInfo_tab.addTextField("User Profile Name (User Info Tag)");
        this.userName_tf = this.UserInfo_tab.addTextField("User Name");
        this.userPassword_pw = this.UserInfo_tab.addPassword("Password");
        this.userPassword_pw.setEchoChar('*');
        this.UI_Get_button = this.UserInfo_tab.addButton("Get");
        this.UI_Set_button = this.UserInfo_tab.addButton("Set");
        this.UI_Delete_button = this.UserInfo_tab.addButton("Delete");
        if (this.kicsSupported) {
            this.RSAKey_tab = this.pgc.addTab("RSA Key");
            this.RSAuserProfileName_tf = this.RSAKey_tab.addTextField("RSA Key Tag Name");
            this.importRSAKey_button = this.RSAKey_tab.addButton("Import");
            this.PKICert_tab = this.pgc.addTab("PKI Cert");
            this.PKIuserProfileName_tf = this.PKICert_tab.addTextField("PKI Certificate Tag Name");
            this.exportPKICert_button = this.PKICert_tab.addButton("Export");
            this.importPKICert_button = this.PKICert_tab.addButton("Import");
        }
        this.pgc.removeApplyButton();
    }

    public void activeState(boolean state) {
    }

    /*
     * Exception decompiling
     */
    public void buttonAction(PluginButton b) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[DOLOOP]], but top level block is 76[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean cancelOperation() {
        if (this.debug) {
            System.out.println("SolarisAuthAppletPlugin:cancelOperation");
        }
        return true;
    }

    private boolean cardSupports_KeyImportCardService(String cardName) {
        block5: {
            try {
                Enumeration svcs = this.sc.cardServices(cardName);
                if (this.debug) {
                    System.out.println("Card Services for cardName = [" + cardName + "]");
                }
                while (svcs != null && svcs.hasMoreElements()) {
                    String svcName = (String)svcs.nextElement();
                    if (this.debug) {
                        System.out.println("    svcName = [" + svcName + "]");
                    }
                    if (!svcName.equals(String.valueOf(cardName) + "KeyImportCardService")) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (!this.debug) break block5;
                System.out.println("cardSupports_KeyImportCardService:\n(exception): " + e.toString());
            }
        }
        return false;
    }

    public void checkBoxAction(PluginCheckBox cb) {
    }

    private boolean checkUserProfile(String label, String userProfile) {
        return this.checkUserProfile(label, userProfile, true);
    }

    private boolean checkUserProfile(String label, String userProfile, boolean dsp) {
        UserInfo ui;
        block8: {
            if (!this.checkUserProfileLength(label, userProfile)) {
                return false;
            }
            ui = null;
            try {
                if (this.debug) {
                    System.out.println("SolarisAuthAppletPlugin:checkUserProfile:\nuserProfile = [" + userProfile + "]");
                }
                this.pgc.enableBusyCursor();
                ui = this.uics.getUserInfo(userProfile);
                if (ui != null && this.debug) {
                    System.out.println("    ui.Type = [" + ui.getType() + "]\n" + "    ui.Name = [" + ui.getName() + "]");
                }
                this.pgc.disableBusyCursor();
            }
            catch (Exception e) {
                this.pgc.disableBusyCursor();
                if (!this.debug) break block8;
                System.out.println("SolarisAuthAppletPlugin:checkUserProfile:\n(exception) = " + e.toString());
            }
        }
        if (ui == null) {
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin:checkUserProfile:\nUser Profile: [" + userProfile + "] does not exist");
            }
            if (dsp) {
                this.pgc.popupError(String.valueOf(label) + ": Unknown User Profile", "The User Profile you specified does not exist");
            }
            return false;
        }
        return true;
    }

    private boolean checkUserProfileLength(String label, String userProfile) {
        return this.checkUserProfileLength(label, userProfile, null);
    }

    private boolean checkUserProfileLength(String label, String userProfile, String profileType) {
        if (profileType == null) {
            profileType = "User Profile";
        }
        if (userProfile.length() < 1) {
            this.pgc.popupError(String.valueOf(label) + ": Empty User Profile", "A " + profileType + " is required to complete this operation.");
            return false;
        }
        if (userProfile.length() > 8) {
            this.pgc.popupError(String.valueOf(label) + ": User Profile Too Long", "The specified " + profileType + " name is too long - " + "it can be a maximum of 8 characters.");
            return false;
        }
        return true;
    }

    public void comboAction(PluginComboBox cb) {
    }

    private boolean getAndValidatePIN(String label) {
        String PIN = this.pgc.popupPasswordInput(String.valueOf(label) + ": Enter PIN");
        if (PIN == null) {
            return false;
        }
        if ((PIN = PIN.trim()).length() < 1) {
            this.pgc.popupError(String.valueOf(label) + ": Empty PIN", "A PIN is required to complete this operation.");
            return false;
        }
        if (this.debug) {
            System.out.println("SolarisAuthAppletPlugin:getAndValidatePIN:\nPIN = [" + PIN + "]");
        }
        try {
            this.pgc.enableBusyCursor();
            if (!this.pcs.validateAndUnlock(PIN)) {
                this.pgc.disableBusyCursor();
                this.pgc.popupError(String.valueOf(label) + ": PIN Validation Error", "The PIN you entered is invalid.\nA valid PIN is required to complete this operation.");
                return false;
            }
            this.pgc.disableBusyCursor();
        }
        catch (Exception e) {
            this.pgc.disableBusyCursor();
            this.pgc.popupError(String.valueOf(label) + ": PIN Validation Error", "Unable to validate PIN - an OCF server error occured.");
            if (this.debug) {
                System.out.println("SolarisAuthAppletPlugin:getAndValidatePIN:\n(exception) = " + e.toString());
            }
            return false;
        }
        this.currentPIN = PIN;
        return true;
    }

    public Properties okButtonPushed(boolean activeState) {
        Properties ap = new Properties();
        if (this.debug) {
            System.out.println("SolarisAuthAppletPlugin:okButtonPushed: activeState = " + activeState);
        }
        return ap;
    }

    public void passwordAction(PluginPassword pp) {
        String pw = pp.getPassword();
        if (this.debug) {
            System.out.println("SolarisAuthAppletPlugin:passwordAction:\nPluginPassword = [" + pw + "]");
        }
        if (pp == this.newPIN_pw || pp == this.retypedPIN_pw) {
            this.buttonAction(this.changePIN_button);
            return;
        }
        if (pp == this.userPassword_pw) {
            this.buttonAction(this.UI_Get_button);
            return;
        }
    }

    public void sliderAction(PluginSlider sl) {
    }

    public void textAction(PluginTextField tf) {
        if (tf == this.userProfileName_tf || tf == this.userName_tf) {
            this.buttonAction(this.UI_Get_button);
            return;
        }
        if (tf == this.RSAuserProfileName_tf) {
            this.buttonAction(this.importRSAKey_button);
            return;
        }
        if (tf == this.PKIuserProfileName_tf) {
            this.buttonAction(this.importPKICert_button);
            return;
        }
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }
}

