/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableConnectionException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolServerDirTableException;
import com.sun.admin.usermgr.common.SolServerException;
import com.sun.admin.usermgr.common.UserObj;
import java.util.StringTokenizer;

public class SolarisAutoHomeTable {
    private String table = new String("auto_home");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String keyCol = "key";
    private String valueCol = "value";
    private String pathDelimiter = ":";
    private String autohomeSeparator = " \t";
    private AdminMgmtScope scope;

    public SolarisAutoHomeTable(AdminMgmtScope adminMgmtScope) {
        this.scope = adminMgmtScope;
    }

    private DirectoryTable openAutoHomeTable() throws SolServerDirTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw new SolServerDirTableException("LM_2190");
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw new SolServerDirTableException("LM_2194");
        }
        try {
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(this.table);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw new SolServerDirTableException("LM_2190");
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw new SolServerDirTableException("LM_2194");
        }
    }

    public UserObj getAutoHomeRow(UserObj userObj) throws SolServerException, AdminException {
        AdminCommonTools.CMN_Trace3("in getAutoHomeRow");
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAutoHomeTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    AdminCommonTools.CMN_Trace1("AutoHome " + userObj.getUserName() + " does not exist");
                    throw new SolServerException("EXM_SUS20", userObj.getUserName());
                }
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.valueCol));
                StringTokenizer stringTokenizer = new StringTokenizer(string, this.autohomeSeparator);
                int n = stringTokenizer.countTokens();
                int n2 = 0;
                while (n2 < n) {
                    string = stringTokenizer.nextToken();
                    ++n2;
                }
                stringTokenizer = new StringTokenizer(string, this.pathDelimiter);
                solHomedirAttr.setServer(stringTokenizer.nextToken());
                solHomedirAttr.setPathname(stringTokenizer.nextToken());
                solHomedirAttr.setAutomount(true);
                userObj.setSolHomedirAttr(solHomedirAttr);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2190");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2194");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var4_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return userObj;
    }

    public void addAutoHomeRow(UserObj userObj) throws SolServerException, AdminException {
        AdminCommonTools.CMN_Trace3("in addAutoHomeRow");
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAutoHomeTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        String string = solHomedirAttr.getServer();
        string = string.concat(this.pathDelimiter);
        string = string.concat(solHomedirAttr.getPathname());
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.valueCol), string);
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                AdminCommonTools.CMN_Trace1("AutoHome Entry already exists - can't add");
                try {
                    TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                    DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                    directoryTable.deleteRow(directoryRow);
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.valueCol), string);
                    directoryTable.addRow(directoryRow);
                }
                catch (Exception exception) {
                    AdminCommonTools.CMN_Trace1("failed to modify auto_home entry during AddUser");
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2190");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2194");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var6_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block14: {
                Object var6_14 = null;
                if (directoryTable == null) break block14;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public void modifyAutoHomeRow(UserObj userObj, UserObj userObj2) throws SolServerException, AdminException {
        AdminCommonTools.CMN_Trace3("in modifyAutoHomeRow");
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAutoHomeTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                String string = userObj.getUserName();
                if (!string.equals(userObj2.getUserName())) {
                    string = userObj2.getUserName();
                }
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), string);
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    AdminCommonTools.CMN_Trace1("AutoHome " + string + " does not exist");
                    throw new SolServerException("EXM_SUS20", string);
                }
                DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
                String string2 = solHomedirAttr.getServer();
                string2 = string2.concat(this.pathDelimiter);
                string2 = string2.concat(solHomedirAttr.getPathname());
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.valueCol));
                StringTokenizer stringTokenizer = new StringTokenizer(string3, this.autohomeSeparator);
                int n = stringTokenizer.countTokens();
                String string4 = "";
                if (n > 1) {
                    int n2 = 0;
                    while (n2 < n - 1) {
                        string4 = string4.concat(stringTokenizer.nextToken());
                        string4 = string4.concat(" ");
                        ++n2;
                    }
                }
                string4 = string4.concat(string2);
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.valueCol), string4);
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2190");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2194");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var5_21 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block16: {
                Object var5_22 = null;
                if (directoryTable == null) break block16;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public void deleteAutoHomeRow(UserObj userObj) throws SolServerException, AdminException {
        AdminCommonTools.CMN_Trace3("in deleteAutoHomeRow");
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAutoHomeTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.keyCol), userObj.getUserName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    Object var4_10 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2190");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2194");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var4_12 = null;
                if (directoryTable == null) break block13;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var4_11 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }
}

