/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class SolPassProps
extends UMgrPropsPanel {
    JPasswordField passwordField;
    JPasswordField confirmField;
    JRadioButton setPwdRadioBtn;
    JRadioButton usePwdRadioBtn;
    SolPassProps solPassProps = this;
    URL CurrentUrl;
    GenInfoPanel infoPanel;
    JPanel passwordBox;
    JLabel passwordLabel;
    JLabel confirmLabel;
    boolean isPasswordGood = true;

    public SolPassProps(UserObj userObj, GenInfoPanel genInfoPanel) {
        this.infoPanel = genInfoPanel;
        this.createGui(userObj);
        this.setPwdRadioBtn.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "uprop_passwd_first"));
        this.usePwdRadioBtn.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "uprop_passwd_first"));
        this.passwordField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "uprop_passwd_password"));
        this.confirmField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "uprop_passwd_confirm"));
        this.focusListener = new UMgrContextHelpListener(this.infoPanel, "uprop_passwd");
    }

    private void createGui(UserObj userObj) {
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        AdminCommonTools.CMN_HandleOutput("SolPass " + solPasswordAttr);
        String string = "";
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.passwordBox = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("sol_pass_props_userPass"));
        this.passwordBox.setBorder(titledBorder);
        this.passwordBox.setLayout(gridBagLayout);
        Constraints.constrain(this.solPassProps, this.passwordBox, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 20, 16, 12, 16);
        boolean bl = false;
        if (solPasswordAttr != null && solPasswordAttr.isThereAPassword()) {
            bl = true;
            string = "FakePassword";
        }
        this.setPwdRadioBtn = new JRadioButton(UMgrResourceStrings.getString("au_wiz_password_set"), !bl);
        this.setPwdRadioBtn.addActionListener(new PasswdActionListener());
        JLabel jLabel = new JLabel(UMgrResourceStrings.getString("sol_pass_next_logon1"));
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.usePwdRadioBtn = new JRadioButton(UMgrResourceStrings.getString("au_wiz_password_use"), bl);
        this.usePwdRadioBtn.addActionListener(new PasswdActionListener());
        JLabel jLabel2 = new JLabel(UMgrResourceStrings.getString("sol_pass_set_pass1"));
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.setPwdRadioBtn);
        buttonGroup.add(this.usePwdRadioBtn);
        Constraints.constrain(this.passwordBox, this.setPwdRadioBtn, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 20, 24, 0, 0);
        Constraints.constrain(this.passwordBox, jLabel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 40, 0, 0);
        Constraints.constrain(this.passwordBox, this.usePwdRadioBtn, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 20, 24, 0, 0);
        Constraints.constrain(this.passwordBox, jLabel2, 0, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 40, 0, 0);
        this.passwordLabel = new JLabel(UMgrResourceStrings.getString("au_wiz_user_pw1"));
        this.passwordLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.passwordLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.passwordLabel.setEnabled(bl);
        Constraints.constrain(this.passwordBox, this.passwordLabel, 0, 4, 1, 1, 0, 17, 0.0, 0.0, 10, 40, 0, 0);
        this.passwordField = new JPasswordField(string, 15);
        this.passwordField.setFont(Constants.PASSWORD_VALUE_FONT);
        this.passwordField.setEnabled(bl);
        Constraints.constrain(this.passwordBox, this.passwordField, 0, 5, 1, 1, 0, 17, 1.0, 0.0, 5, 40, 0, 0);
        this.confirmLabel = new JLabel(UMgrResourceStrings.getString("au_wiz_user_pw2"));
        this.confirmLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.confirmLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.confirmLabel.setEnabled(bl);
        Constraints.constrain(this.passwordBox, this.confirmLabel, 0, 6, 1, 1, 0, 17, 0.0, 0.0, 15, 40, 0, 0);
        this.confirmField = new JPasswordField(string, 15);
        this.confirmField.setFont(Constants.PASSWORD_VALUE_FONT);
        this.confirmField.setEnabled(bl);
        Constraints.constrain(this.passwordBox, this.confirmField, 0, 7, 1, 1, 0, 18, 1.0, 1.0, 5, 40, 0, 0);
    }

    public void setThisUrl(URL uRL) {
        this.CurrentUrl = uRL;
    }

    public URL getThisUrl() {
        return this.CurrentUrl;
    }

    public void updateInfoPanel() {
        this.infoPanel.setUrl(this.getThisUrl());
    }

    public boolean isPasswdSyntaxOK() {
        return true;
    }

    public void setPasswordGood(boolean bl) {
        this.isPasswordGood = bl;
    }

    public boolean getPasswordGood() {
        return this.isPasswordGood;
    }

    public UserObj updateSolPassProps(UserObj userObj) {
        UserMgrClient userMgrClient = UserMgrClient.instance();
        SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
        if (solPasswordAttr == null) {
            solPasswordAttr = new SolPasswordAttr();
        }
        if (this.setPwdRadioBtn.isSelected()) {
            solPasswordAttr.setUnixEPasswd("");
            userObj = userMgrClient.setUpPDCPassword("", userObj);
            this.setPasswordGood(true);
            solPasswordAttr.setChangePassword(true);
        } else if (this.usePwdRadioBtn.isSelected()) {
            char[] cArray = this.passwordField.getPassword();
            String string = new String(cArray);
            char[] cArray2 = this.confirmField.getPassword();
            String string2 = new String(cArray2);
            if (!string.equals("FakePassword")) {
                if (string.equals("")) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, ResourceStrings.getString("cs_passwd_len"));
                    this.setPasswordGood(false);
                } else if (!CheckSyntax.isPasswordConf(string, string2)) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, CheckSyntax.getErrorString());
                    this.setPasswordGood(false);
                } else {
                    this.setPasswordGood(true);
                }
                userObj = userMgrClient.setUpPassword(string, userObj);
                userObj = userMgrClient.setUpPDCPassword(string, userObj);
                solPasswordAttr.setChangePassword(true);
            } else {
                solPasswordAttr.setChangePassword(false);
            }
        }
        userObj.setSolPasswordAttr(solPasswordAttr);
        return userObj;
    }

    class PasswdActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SolPassProps.this.setPwdRadioBtn) {
                ((JTextComponent)SolPassProps.this.passwordField).setText("");
                SolPassProps.this.passwordField.setEnabled(false);
                SolPassProps.this.passwordLabel.setEnabled(false);
                ((JTextComponent)SolPassProps.this.confirmField).setText("");
                SolPassProps.this.confirmField.setEnabled(false);
                SolPassProps.this.confirmLabel.setEnabled(false);
                SolPassProps.this.passwordBox.repaint();
                return;
            }
            if (actionEvent.getSource() == SolPassProps.this.usePwdRadioBtn) {
                SolPassProps.this.passwordField.setEnabled(true);
                SolPassProps.this.passwordLabel.setEnabled(true);
                SolPassProps.this.confirmField.setEnabled(true);
                SolPassProps.this.confirmLabel.setEnabled(true);
                SolPassProps.this.passwordBox.repaint();
            }
        }

        PasswdActionListener() {
            SolPassProps.this = SolPassProps.this;
        }
    }
}

