/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AuthAttrMgmt;
import com.sun.admin.usermgr.client.AuthAttrModelEntry;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class RightsProps
extends UMgrPropsPanel {
    RightsProps rightsProps;
    JCheckBox primaryAdminCB;
    JPanel rightsPanel;
    JButton selectAll;
    JButton deselectAll;
    JCheckBox[] checkArr;
    AuthAttrMgmt authAttrMgmt;
    AuthAttrModelEntry[] authArr;
    GenInfoPanel infoPanel;

    public RightsProps(UserObj userObj, GenInfoPanel genInfoPanel) throws AdminException {
        this.infoPanel = genInfoPanel;
        this.rightsProps = this;
        this.createGui(userObj);
    }

    private void createGui(UserObj userObj) throws AdminException {
        String string = userObj.getUserName();
        UserAttrObj userAttrObj = userObj.getSolAuthAttrs();
        this.authAttrMgmt = new AuthAttrMgmt(string, userAttrObj);
        this.authArr = this.authAttrMgmt.getAuthEntries();
        this.setAuthArr(this.authArr);
        this.selectAll = new JButton(UMgrResourceStrings.getString("rights_props_sel_all"));
        this.deselectAll = new JButton(UMgrResourceStrings.getString("rights_props_clear_all"));
        this.makeRightsPanel(this.getAuthArr());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("rights_props_admin_rights"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain(this.rightsProps, jPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.4, 20, 16, 0, 16);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("rights_props_acc_rights"));
        jPanel2.setBorder(titledBorder2);
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(this.rightsProps, jPanel2, 0, 1, 1, 1, 1, 10, 1.0, 0.8, 12, 16, 12, 16);
        this.primaryAdminCB = new JCheckBox(UMgrResourceStrings.getString("rights_props_grant"), false);
        this.primaryAdminCB.setForeground(Constants.PROPS_LABEL_COLOR);
        this.primaryAdminCB.addFocusListener(new UMgrContextHelpListener(this.infoPanel, this.authArr[0].getHelp(), "auths"));
        if (this.authArr[0].isGranted()) {
            this.primaryAdminCB.setSelected(true);
        }
        if (this.authArr[0].canBeGranted()) {
            this.primaryAdminCB.setEnabled(true);
            this.selectAll.setEnabled(true);
            this.deselectAll.setEnabled(true);
        } else {
            this.primaryAdminCB.setEnabled(false);
            this.selectAll.setEnabled(false);
            this.deselectAll.setEnabled(false);
        }
        Constraints.constrain(jPanel, this.primaryAdminCB, 0, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 24, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.getRightsPanel(), 20, 30);
        jScrollPane.setBackground(Color.white);
        Dimension dimension = new Dimension(340, 180);
        jScrollPane.setPreferredSize(dimension);
        Constraints.constrain(jPanel2, jScrollPane, 0, 0, 2, 1, 0, 17, 1.0, 0.0, 0, 24, 0, 0);
        this.selectAll.addActionListener(new EnableListener());
        this.deselectAll.addActionListener(new ClearListener());
        Constraints.constrain(jPanel2, this.selectAll, 0, 1, 1, 1, 0, 13, 1.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(jPanel2, this.deselectAll, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.focusListener = new UMgrContextHelpListener(this.infoPanel, "uprop_rights");
    }

    private void makeRightsPanel(AuthAttrModelEntry[] authAttrModelEntryArray) {
        this.rightsPanel = new JPanel();
        this.rightsPanel.setLayout(new BoxLayout(this.rightsPanel, 1));
        Dimension dimension = new Dimension(10, 5);
        Dimension dimension2 = new Dimension(10, 5);
        Dimension dimension3 = new Dimension(10, 5);
        Dimension dimension4 = new Dimension(10, 1);
        Dimension dimension5 = new Dimension(10, 1);
        Dimension dimension6 = new Dimension(10, 1);
        JCheckBox[] jCheckBoxArray = new JCheckBox[authAttrModelEntryArray.length];
        jCheckBoxArray[0] = new JCheckBox(authAttrModelEntryArray[0].getDesc(), authAttrModelEntryArray[0].isGranted());
        int n = 1;
        while (n < jCheckBoxArray.length) {
            String string = authAttrModelEntryArray[n].getDesc();
            boolean bl = authAttrModelEntryArray[n].isHeader();
            boolean bl2 = authAttrModelEntryArray[n].canBeGranted();
            boolean bl3 = authAttrModelEntryArray[n].isGranted();
            if (bl3) {
                jCheckBoxArray[n] = new JCheckBox(string, true);
                jCheckBoxArray[n].setBackground(Color.white);
            } else {
                jCheckBoxArray[n] = new JCheckBox(string, false);
                jCheckBoxArray[n].setBackground(Color.white);
            }
            if (!bl2) {
                jCheckBoxArray[n].setEnabled(false);
            }
            if (bl) {
                JLabel jLabel = new JLabel(string);
                jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
                this.rightsPanel.add(new Box.Filler(dimension, dimension2, dimension3));
                this.rightsPanel.add(jLabel);
            } else {
                jCheckBoxArray[n].setForeground(Constants.PROPS_LABEL_COLOR);
                jCheckBoxArray[n].setFont(Constants.PROPS_LABEL_FONT);
                jCheckBoxArray[n].addFocusListener(new UMgrContextHelpListener(this.infoPanel, authAttrModelEntryArray[n].getHelp(), "auths"));
                this.rightsPanel.add(new Box.Filler(dimension4, dimension5, dimension6));
                this.rightsPanel.add(jCheckBoxArray[n]);
            }
            ++n;
        }
        this.setMyArr(jCheckBoxArray);
        this.rightsPanel.setBackground(Color.white);
        this.setRightsPanel(this.rightsPanel);
    }

    public void setRightsPanel(JPanel jPanel) {
        this.rightsPanel = jPanel;
    }

    public JPanel getRightsPanel() {
        return this.rightsPanel;
    }

    public void setMyArr(JCheckBox[] jCheckBoxArray) {
        this.checkArr = jCheckBoxArray;
    }

    public JCheckBox[] getMyArr() {
        return this.checkArr;
    }

    public void setAuthArr(AuthAttrModelEntry[] authAttrModelEntryArray) {
        this.authArr = authAttrModelEntryArray;
    }

    public AuthAttrModelEntry[] getAuthArr() {
        return this.authArr;
    }

    public void getChecks(JPanel jPanel) {
        AdminCommonTools.CMN_HandleOutput("IN GET CHECKS");
        AuthAttrModelEntry[] authAttrModelEntryArray = this.getAuthArr();
        JCheckBox[] jCheckBoxArray = this.getMyArr();
        if (this.primaryAdminCB.isSelected()) {
            authAttrModelEntryArray[0].grant();
        } else {
            authAttrModelEntryArray[0].revoke();
        }
        int n = 1;
        while (n < jCheckBoxArray.length) {
            if (jCheckBoxArray[n].isSelected()) {
                authAttrModelEntryArray[n].grant();
                AdminCommonTools.CMN_HandleOutput(String.valueOf(jCheckBoxArray[n].getText()) + " is Selected? " + jCheckBoxArray[n].isSelected());
            } else {
                authAttrModelEntryArray[n].revoke();
            }
            ++n;
        }
        this.setAuthArr(authAttrModelEntryArray);
    }

    public UserObj updateRightsProps(UserObj userObj) {
        this.getChecks(this.getRightsPanel());
        try {
            UserAttrObj userAttrObj = this.authAttrMgmt.setAuthEntries(this.getAuthArr());
            userObj.setSolAuthAttrs(userAttrObj);
        }
        catch (AdminException adminException) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, adminException.getLocalizedMessage());
        }
        return userObj;
    }

    class EnableListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox[] jCheckBoxArray = RightsProps.this.getMyArr();
            int n = 0;
            while (n < jCheckBoxArray.length) {
                jCheckBoxArray[n].setSelected(true);
                ++n;
            }
        }

        EnableListener() {
            RightsProps.this = RightsProps.this;
        }
    }

    class ClearListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox[] jCheckBoxArray = RightsProps.this.getMyArr();
            int n = 0;
            while (n < jCheckBoxArray.length) {
                jCheckBoxArray[n].setSelected(false);
                ++n;
            }
        }

        ClearListener() {
            RightsProps.this = RightsProps.this;
        }
    }
}

