/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.serialmgr.client.ContentPanel;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.client.SerialActionsListener;
import com.sun.admin.serialmgr.client.SerialContentPanel;
import com.sun.admin.serialmgr.client.SerialMgrTree;
import com.sun.admin.serialmgr.client.SerialMgrTreeEvent;
import com.sun.admin.serialmgr.client.SerialMgrTreeListener;
import com.sun.admin.serialmgr.client.SerialTableView;
import com.sun.admin.serialmgr.client.TreeNodeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SerialMgrTree
extends JTree {
    private DefaultTreeModel treeModel;
    private ContentPanel currentContentPanel;
    private ImageIcon programIcon;
    private final TreeCellRenderer oldRenderer = this.getCellRenderer();
    private Vector listeners = new Vector();

    public SerialMgrTree() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.programIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "SmallProgramGif"), "");
        SerialContentPanel serialContentPanel = new SerialContentPanel();
        serialContentPanel.addView(new SerialTableView());
        String string = ResourceStrings.getString(resourceBundle, "toolname");
        TreeNodeData treeNodeData = new TreeNodeData(string, serialContentPanel, null, this.programIcon, "overview");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(treeNodeData);
        serialContentPanel.setTreeNode(defaultMutableTreeNode);
        this.currentContentPanel = serialContentPanel;
        this.setModel(new SerialMgrTreeModel(defaultMutableTreeNode));
        this.setCellRenderer(new SerialMgrTreeCellRenderer());
        TreeSelectionModel treeSelectionModel = this.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.collapseRow(0);
        this.addTreeSelectionListener(new 1());
        this.registerKeyboardAction(new SerialActionsListener(), "Delete", KeyStroke.getKeyStroke(127, 0, true), 1);
    }

    private void onTreeSelection(TreeSelectionEvent treeSelectionEvent) {
        if (this.isSelectionEmpty()) {
            return;
        }
        Main.getApp().getClientComm().waitOn();
        Main.getApp().getClientComm().setAppFocus(Main.getApp());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        this.currentContentPanel = treeNodeData.getContentPanel();
        this.fireContentPanelChanged();
        this.currentContentPanel.repaintView();
        Main.getApp().setContentPanel(this.currentContentPanel);
        Main.getApp().setHelp(treeNodeData.getHelpName());
        Main.getApp().getClientComm().waitOff();
        if (!this.currentContentPanel.isRefreshed()) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            SerialActionsListener serialActionsListener = new SerialActionsListener();
            serialActionsListener.actionPerformed(actionEvent);
        }
    }

    public ContentPanel getCurrentContentPanel() {
        return this.currentContentPanel;
    }

    private void fireContentPanelChanged() {
        SerialMgrTreeEvent serialMgrTreeEvent = new SerialMgrTreeEvent(this.currentContentPanel);
        int n = 0;
        while (n < this.listeners.size()) {
            SerialMgrTreeListener serialMgrTreeListener = (SerialMgrTreeListener)this.listeners.elementAt(n);
            serialMgrTreeListener.contentPanelChanged(serialMgrTreeEvent);
            ++n;
        }
    }

    public synchronized void addSerialMgrTreeListener(SerialMgrTreeListener serialMgrTreeListener) {
        this.listeners.addElement(serialMgrTreeListener);
    }

    public synchronized void removeSerialMgrTreeListener(SerialMgrTreeListener serialMgrTreeListener) {
        this.listeners.removeElement(serialMgrTreeListener);
    }

    static /* synthetic */ void access$0(SerialMgrTree serialMgrTree, TreeSelectionEvent treeSelectionEvent) {
        serialMgrTree.onTreeSelection(treeSelectionEvent);
    }

    private final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = treeSelectionEvent;
            2 var3_3 = new 2(SerialMgrTree.this, treeSelectionEvent2);
            var3_3.start();
        }

        /* synthetic */ 1() {
        }
    }

    class SerialMgrTreeCellRenderer
    implements TreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = SerialMgrTree.this.oldRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
            JLabel jLabel = (JLabel)component;
            jLabel.setIcon(treeNodeData.getImageIcon());
            jLabel.setText(treeNodeData.getName());
            if (treeNodeData.getPreferredSize() == null) {
                Dimension dimension = jLabel.getMinimumSize();
                dimension.height += 4;
                treeNodeData.setPreferredSize(dimension);
            }
            jLabel.setPreferredSize(treeNodeData.getPreferredSize());
            jLabel.setMaximumSize(treeNodeData.getPreferredSize());
            return component;
        }

        SerialMgrTreeCellRenderer() {
            SerialMgrTree.this = SerialMgrTree.this;
        }
    }

    class SerialMgrTreeModel
    extends DefaultTreeModel {
        public SerialMgrTreeModel(TreeNode treeNode) {
            super(treeNode);
            SerialMgrTree.this = SerialMgrTree.this;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
            if (treeNodeData != null) {
                defaultMutableTreeNode.setUserObject(treeNodeData);
            } else {
                defaultMutableTreeNode.setUserObject((String)object);
            }
            this.nodeChanged(defaultMutableTreeNode);
        }
    }
}

