/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.InfoDialog;
import com.sun.admin.cis.common.PDCContext;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.logviewer.client.CancelListener;
import com.sun.admin.logviewer.client.FetchContinueListener;
import com.sun.admin.logviewer.client.FetchPanel;
import com.sun.admin.logviewer.client.FilterListener;
import com.sun.admin.logviewer.client.LogPanel;
import com.sun.admin.logviewer.client.LogVClient;
import com.sun.admin.logviewer.client.LogVContextHelpListener;
import com.sun.admin.logviewer.client.LogVMenuBar;
import com.sun.admin.logviewer.client.LogVToolBar;
import com.sun.admin.logviewer.client.LogVTree;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LogVMainPanel
extends JPanel
implements AdminClientComponent {
    private LogVMenuBar logVMenuBar;
    private LogVToolBar logVToolBar;
    private LogPanel logPanel;
    private JPanel currentPanel;
    private String currentId;
    private JLabel contentLabel;
    public static String LOGVIEWER = LogVResourceStrings.getString("toolname");
    private LogVClient logVClient;
    private PDCContext adminContext;
    private LogVTree theTree;
    private static JFrame jFrame;
    private static LogVMainPanel instance;
    IClientComm clientComm;
    private InfoDialog infoDialog;
    static int temporaryFix;
    static final int PROGRESS_WAIT = 1000;

    public void appReceivingMainFocus() {
        this.clientComm.addToMainView(this);
        if (temporaryFix == 0) {
            temporaryFix = 1;
            this.logPanel = new LogPanel();
            this.logVMenuBar = new LogVMenuBar();
            this.logVToolBar = new LogVToolBar();
            int n = 0;
            n = this.logVClient.getRowCount();
            if (n > 50) {
                FetchPanel fetchPanel = new FetchPanel();
                String string = new String(LogVResourceStrings.getString("fetch_title"));
                this.infoDialog = new InfoDialog(LogVMainPanel.getFrame(), string, fetchPanel, (ActionListener)new FetchContinueListener(), (ActionListener)new FilterListener(), new CancelListener());
            } else {
                1 var2_3 = new 1();
                var2_3.start();
            }
        }
        this.addToHelpPanel("lm_ctx_main");
    }

    public void appLosingMainFocus() {
        this.theTree.removeSelectionRows(this.theTree.getSelectionRows());
        this.theTree.invalidate();
        this.theTree.validate();
        this.theTree.repaint();
    }

    public void appCloseDown() {
        try {
            temporaryFix = 0;
            this.logVClient.terminateConnection();
            temporaryFix = 0;
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void addHelpListener(GenInfoPanel genInfoPanel, Component component, String string) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(genInfoPanel, componentArray[n], string);
                ++n;
            }
        }
        component.addFocusListener(new LogVContextHelpListener(genInfoPanel, string));
    }

    private static String getLogVImageDirectory() {
        String string = File.separator;
        String string2 = String.valueOf(string) + "logviewer" + string + "client" + string + "images";
        return string2;
    }

    public String getHelpUrlString(String string) {
        return this.clientComm.getHelpUrl("logviewer", String.valueOf(string) + ".html");
    }

    public void addToHelpPanel(String string) {
        try {
            URL uRL = new URL(this.getHelpUrlString(string));
            this.clientComm.addToHelpPanel(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = LogVResourceStrings.getString("err_malformed_URL");
            AdminCommonTools.CMN_HandleOutput(String.valueOf(string2) + " " + malformedURLException);
            return;
        }
    }

    public ImageIcon loadImageIcon(String string, String string2) {
        String string3 = String.valueOf(this.clientComm.getImagePath()) + LogVMainPanel.getLogVImageDirectory() + File.separator + string;
        return new ImageIcon(string3, string2);
    }

    public static LogVMainPanel instance() {
        return instance;
    }

    private void initializeComponents() {
        this.adminContext = PDCContext.instance();
        this.logVClient = LogVClient.instance();
        try {
            this.logVClient.setUpConnection(this.clientComm);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.theTree = new LogVTree();
    }

    public LogVMainPanel(IClientComm iClientComm) {
        instance = this;
        this.clientComm = iClientComm;
        jFrame = iClientComm.getFrame();
        this.initializeComponents();
        iClientComm.addToTreePanel(this.theTree);
    }

    public void setCurrentPanel(String string) {
        if (temporaryFix == 0) {
            return;
        }
        this.removeAll();
        this.currentPanel = this.logPanel;
        JPanel jPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(jPanel, this.logVMenuBar, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 10);
        this.logVMenuBar.setBorderPainted(false);
        Constraints.constrain(jPanel, this.logVToolBar, 1, -1, 1, 1, 1, 17, 1.0, 0.0, 0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.contentLabel = new JLabel("   ");
        Constraints.constrain(jPanel2, this.contentLabel, 0, -1, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 0);
        Font font = this.contentLabel.getFont();
        this.contentLabel.setFont(new Font(font.getName(), 0, font.getSize() + 2));
        this.contentLabel.setForeground(Color.black);
        String string5 = LogVMainPanel.instance().getLogVClient().getFileName();
        string2 = LogVResourceStrings.getString("domain_name");
        string3 = this.clientComm.getScopeName();
        string4 = LogVResourceStrings.getString("log_lbl");
        this.contentLabel.setText(String.valueOf(string2) + " " + string3 + " " + " " + string4 + " " + string5);
        Constraints.constrain(this, jPanel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this, jPanel2, 0, -1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this, this.currentPanel, 0, -1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public static JFrame getFrame() {
        return jFrame;
    }

    public LogPanel getLogPanel() {
        return this.logPanel;
    }

    public LogVMenuBar getMenuBar() {
        return this.logVMenuBar;
    }

    public LogVToolBar getToolBar() {
        return this.logVToolBar;
    }

    public LogVClient getLogVClient() {
        return this.logVClient;
    }

    public void setContentLbl(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string2 = LogVResourceStrings.getString("domain_name");
        string3 = this.clientComm.getScopeName();
        string4 = LogVResourceStrings.getString("log_lbl");
        this.contentLabel.setText(String.valueOf(string2) + " " + string3 + " " + " " + string4 + " " + string);
    }

    public void clearContentLbl() {
        this.contentLabel.setText("");
    }

    private final class 1
    extends Thread {
        public void run() {
            LogVMainPanel.instance().clientComm.waitOn();
            String string = LogVResourceStrings.getString("LogViewerProgressPanelTitle");
            String string2 = LogVResourceStrings.getString("LogViewerProgressPanelText");
            LogVMainPanel.instance();
            ProgressPanel progressPanel = new ProgressPanel(LogVMainPanel.getFrame(), 1, 30, false, false);
            progressPanel.setTitle(string);
            progressPanel.setText(string2);
            ((Component)progressPanel).setVisible(true);
            progressPanel.show();
            LogVMainPanel.this.setCurrentPanel("LOGVIEWER");
            LogVMainPanel.this.logPanel.prepareData();
            LogVMainPanel.this.logPanel.populate();
            LogVMainPanel.this.logPanel.invalidate();
            LogVMainPanel.this.logPanel.validate();
            LogVMainPanel.this.logPanel.repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            LogVMainPanel.instance().clientComm.waitOff();
        }

        /* synthetic */ 1() {
        }
    }
}

