/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.ColumnLayout;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.LAYOUT_ALIGNMENT;
import com.sun.admin.cis.common.RowLayout;
import com.sun.admin.logviewer.client.LogPanel;
import com.sun.admin.logviewer.client.LogVContextHelpListener;
import com.sun.admin.logviewer.client.LogVException;
import com.sun.admin.logviewer.client.LogVMainPanel;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jclass.bwt.JCSpinBox;

public class LogSettings
extends AdminDialog {
    LogPanel logPanel;
    JButton OKBtn;
    JButton CancelBtn;
    JTextField fileTextf;
    JCheckBox sysLogBtn;
    JCSpinBox fileSizeField;
    JCSpinBox numFilesField;
    JButton backUpBtn;
    GenInfoPanel infoPanel;
    public static final Border emptyBorder10 = new EmptyBorder(10, 10, 10, 10);
    public static final Border emptyBorder5 = new EmptyBorder(5, 5, 5, 5);

    public LogSettings(Frame frame, LogPanel logPanel) {
        super(frame, LogVResourceStrings.getString("main_title"), false);
        this.logPanel = logPanel;
        this.infoPanel = this.getInfoPanel();
        this.OKBtn = this.getOKBtn();
        this.OKBtn.addActionListener(new OKCancelButtonListener());
        this.CancelBtn = this.getCancelBtn();
        this.CancelBtn.addActionListener(new OKCancelButtonListener());
        JPanel jPanel = this.getRightPanel();
        jPanel.setBorder(emptyBorder10);
        jPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LogVResourceStrings.getString("top_log_lbl"));
        jPanel2.setBorder(titledBorder);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 0));
        jPanel3.setBorder(new EmptyBorder(10, 2, 10, 0));
        JLabel jLabel = new JLabel(LogVResourceStrings.getString("specify_lbl"));
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jPanel3.add(jLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 2));
        jPanel4.setBorder(emptyBorder5);
        JLabel jLabel2 = new JLabel(LogVResourceStrings.getString("dir_name_lbl"));
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        JLabel jLabel3 = new JLabel(LogVResourceStrings.getString("max_file_size"));
        jLabel3.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel3.setFont(Constants.PROPS_LABEL_FONT);
        this.fileTextf = new JTextField(10);
        this.fileTextf.setText("/var/admin/log/");
        this.fileSizeField = new JCSpinBox(10);
        this.fileSizeField.setMinimum(1);
        this.fileSizeField.setMaximum(2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(5, 0, 2, 0));
        jPanel5.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
        JLabel jLabel4 = new JLabel(LogVResourceStrings.getString("megabytes"));
        jLabel4.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel4.setFont(Constants.PROPS_LABEL_FONT);
        jPanel5.add((Component)this.fileSizeField);
        jPanel5.add(jLabel4);
        jPanel4.add(jLabel2);
        jPanel4.add(this.fileTextf);
        jPanel4.add(jLabel3);
        jPanel4.add(jPanel5);
        jPanel3.add(jPanel4);
        jPanel2.add(jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(LogVResourceStrings.getString("bot_log_lbl"));
        jPanel6.setBorder(titledBorder2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND, 0, 0));
        jPanel7.setBorder(new EmptyBorder(10, 2, 10, 0));
        JLabel jLabel5 = new JLabel(LogVResourceStrings.getString("back_up_lbl1"));
        jLabel5.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel5.setFont(Constants.PROPS_LABEL_FONT);
        JLabel jLabel6 = new JLabel(LogVResourceStrings.getString("back_up_lbl2"));
        jLabel6.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel6.setFont(Constants.PROPS_LABEL_FONT);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
        jPanel8.setBorder(emptyBorder5);
        JLabel jLabel7 = new JLabel(LogVResourceStrings.getString("keep_lbl"));
        jLabel7.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel7.setFont(Constants.PROPS_LABEL_FONT);
        this.numFilesField = new JCSpinBox(10);
        this.numFilesField.setMinimum(1);
        this.numFilesField.setMaximum(20);
        JLabel jLabel8 = new JLabel(LogVResourceStrings.getString("back_log_file_lbl"));
        jLabel8.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel8.setFont(Constants.PROPS_LABEL_FONT);
        this.backUpBtn = new JButton(LogVResourceStrings.getString("backup_btn_lbl"));
        this.backUpBtn.setActionCommand("BACKUP");
        this.backUpBtn.addActionListener(new OKCancelButtonListener());
        jPanel8.add(jLabel7);
        jPanel8.add((Component)this.numFilesField);
        jPanel8.add(jLabel8);
        jPanel7.add(jLabel5);
        jPanel7.add(jLabel6);
        jPanel7.add(jPanel8);
        jPanel6.add(jPanel7);
        this.sysLogBtn = new JCheckBox(LogVResourceStrings.getString("sys_log_lbl"));
        jPanel.add(jPanel2);
        jPanel.add(new JLabel("         "));
        jPanel.add(jPanel6);
        jPanel.add(new JLabel("         "));
        jPanel.add(this.sysLogBtn);
        this.pack();
        Dimension dimension = this.getSize();
        this.setMySize(dimension);
        this.setDefaultFocusListener(new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_settings_overview"), true);
        this.fileTextf.addFocusListener(new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_settings_directory"));
        this.fileSizeField.addFocusListener((FocusListener)new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_settings_maxsize"));
        this.numFilesField.addFocusListener((FocusListener)new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_settings_backup"));
        this.sysLogBtn.addFocusListener(new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_settings_enable"));
    }

    public String getDirName() {
        String string = null;
        string = this.fileTextf.getText();
        return string;
    }

    public int getFileSize() throws LogVException {
        int n = 1;
        try {
            n = Integer.parseInt(this.fileSizeField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new LogVException("EXFILE_SIZE");
        }
        return n;
    }

    public int getNumFiles() throws LogVException {
        int n = 1;
        try {
            n = Integer.parseInt(this.numFilesField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new LogVException("EXNUM_FILES");
        }
        return n;
    }

    public String getSysLogValue() {
        if (this.sysLogBtn.isSelected()) {
            return "on";
        }
        return "off";
    }

    public void doSettings() {
        if (this.logPanel != null) {
            this.logPanel.setSettings();
        }
    }

    public void doBackup() {
    }

    public boolean isSyntaxOK() {
        int n = 0;
        int n2 = 0;
        try {
            n = this.getFileSize();
        }
        catch (LogVException logVException) {
            new ErrorDialog(LogVMainPanel.getFrame(), logVException.getLocalizedMessage());
            this.fileSizeField.setText("2");
            return false;
        }
        try {
            n2 = this.getNumFiles();
        }
        catch (LogVException logVException) {
            new ErrorDialog(LogVMainPanel.getFrame(), logVException.getLocalizedMessage());
            this.numFilesField.setText("20");
            return false;
        }
        String string = this.getDirName();
        if (string.compareTo("") == 0) {
            LogVException logVException = new LogVException("EXDIR_NAME_EMPTY");
            new ErrorDialog(LogVMainPanel.getFrame(), logVException.getLocalizedMessage());
            return false;
        }
        if (n > 5 || n <= 0) {
            LogVException logVException = new LogVException("EXFILE_SIZE");
            new ErrorDialog(LogVMainPanel.getFrame(), logVException.getLocalizedMessage());
            this.fileSizeField.setText("2");
            return false;
        }
        if (n2 > 20 || n2 <= 0) {
            LogVException logVException = new LogVException("EXNUM_FILES");
            new ErrorDialog(LogVMainPanel.getFrame(), logVException.getLocalizedMessage());
            this.numFilesField.setText("20");
            return false;
        }
        return true;
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == LogSettings.this.CancelBtn) {
                LogSettings.this.dispose();
                return;
            }
            if (actionEvent.getSource() == LogSettings.this.OKBtn) {
                if (LogSettings.this.isSyntaxOK()) {
                    LogSettings.this.doSettings();
                    LogSettings.this.dispose();
                    return;
                }
            } else {
                actionEvent.getSource();
            }
        }

        OKCancelButtonListener() {
            LogSettings.this = LogSettings.this;
        }
    }
}

