/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.cis.common.sort.TableSorter;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.Share;
import com.sun.admin.fsmgr.client.share.ShareActionsListener;
import com.sun.admin.fsmgr.client.share.ShareCache;
import com.sun.admin.fsmgr.client.share.ShareCacheEntry;
import com.sun.admin.fsmgr.client.share.ShareListView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ShareTableView
extends ShareListView {
    JTable table;
    JScrollPane scrollPane;
    Object[][] theData;
    ShareTableModel dataModel;
    TableSorter tableSorter;
    int oldSortColumn;
    int theSortColumn;
    boolean ascendSort = true;
    ShareTableView thisView;
    Vector vColumns = new Vector();
    ResourceBundle bundle = FsMgr.getFsMgr().getResourceBundle();
    private static String SHARENAME = FsMgrResourceStrings.getString("ShareTableName");
    private static String STATUS = FsMgrResourceStrings.getString("ShareTableStatus");
    private static String ACCESS = FsMgrResourceStrings.getString("ShareTableAccess");
    private static String DESCRIPTION = FsMgrResourceStrings.getString("ShareTableDescription");
    String[] columnKeys = new String[]{SHARENAME, STATUS, ACCESS, DESCRIPTION};

    public ShareTableView() {
        this.thisView = this;
        this.vColumns.addElement(new String(SHARENAME));
        this.vColumns.addElement(new String(STATUS));
        this.vColumns.addElement(new String(ACCESS));
        this.vColumns.addElement(new String(DESCRIPTION));
        this.dataModel = new ShareTableModel();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter = new TableSorter(this.dataModel);
        this.table = new JTable(this.tableSorter);
        this.table.setBackground(Color.white);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
        this.table.addMouseListener(new TableMouseListener(this));
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new 2());
        this.setViewportView(this.table);
        this.setBackground(Color.white);
    }

    protected int getViewType() {
        return 1;
    }

    public void populate() {
        ShareCache shareCache = Share.getInstance().getShareCache();
        this.theData = new Object[shareCache.size()][this.dataModel.getMaxColumnCount()];
        int n = 0;
        while (n < shareCache.size()) {
            ShareCacheEntry shareCacheEntry = (ShareCacheEntry)shareCache.elementAt(n);
            this.dataModel.addShareAtRow(n, shareCacheEntry);
            ++n;
        }
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void clear() {
        this.clearSelection();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void append(Vector vector) {
    }

    public Object getSelectedItem() {
        int[] nArray = this.table.getSelectedRows();
        ShareCache shareCache = Share.getInstance().getShareCache();
        Object e = shareCache.elementAt(this.tableSorter.convertRowIndexToModel(nArray[0]));
        return e;
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    private void onSelect() {
        this.fireItemPressed(1);
    }

    public void selectAll() {
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.fireItemPressed(0);
    }

    public void sortAscending() {
        this.ascendSort = true;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortDescending() {
        this.ascendSort = false;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortByAttribute(String string) {
        try {
            int n;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            this.theSortColumn = n = tableColumnModel.getColumnIndex(string);
            this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
            this.fireSortChanged();
            return;
        }
        catch (Exception exception) {
            this.fireSortChanged();
            return;
        }
    }

    protected int getSortOrder() {
        if (this.ascendSort) {
            return 10;
        }
        return 11;
    }

    public String getSortAttribute() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.theSortColumn);
        return (String)tableColumn.getIdentifier();
    }

    public void find(String string) {
        if (string == null) {
            return;
        }
        if (this.table.getRowCount() == 0) {
            return;
        }
        int n = 0;
        while (n < this.table.getRowCount()) {
            int n2 = this.tableSorter.convertRowIndexToModel(n);
            String string2 = this.dataModel.getSharename(n2);
            if (string2 != null && string.equals(string2)) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(n, n);
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                this.table.scrollRectToVisible(rectangle);
                return;
            }
            ++n;
        }
    }

    public Vector getAvailableSortAttributes() {
        return this.vColumns;
    }

    public void doPopupMenu(MouseEvent mouseEvent, boolean bl) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (bl) {
            this.table.clearSelection();
            this.table.setRowSelectionInterval(n, n);
        }
        Share share = Share.getInstance();
        JMenuPlus jMenuPlus = share.getShareMenuBar().getActionMenu();
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.getViewport());
        Point point = mouseEvent2.getPoint();
        jMenuPlus.showPopupAt(this, point.x, point.y);
    }

    class ShareTableModel
    extends AbstractTableModel {
        Vector tableColumns = new Vector();

        public int getColumnCount() {
            return ShareTableView.this.vColumns.size();
        }

        public int getRowCount() {
            return ShareTableView.this.theData.length;
        }

        public String getSharename(int n) {
            int n2 = this.getColumnModelIndex(SHARENAME);
            return (String)this.getValueAt(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            if (ShareTableView.this.theData.length == 0) {
                return null;
            }
            return ShareTableView.this.theData[n][n2];
        }

        public String getColumnName(int n) {
            String string = (String)ShareTableView.this.vColumns.elementAt(n);
            ActionString actionString = new ActionString(ShareTableView.this.bundle, string);
            return actionString.getString();
        }

        public void addShareAtRow(int n, ShareCacheEntry shareCacheEntry) {
            int n2 = this.getColumnModelIndex(SHARENAME);
            ShareTableView.this.theData[n][n2] = shareCacheEntry.getPathname();
            n2 = this.getColumnModelIndex(STATUS);
            ShareTableView.this.theData[n][n2] = shareCacheEntry.getStatusString();
            n2 = this.getColumnModelIndex(ACCESS);
            ShareTableView.this.theData[n][n2] = shareCacheEntry.getAccess();
            n2 = this.getColumnModelIndex(DESCRIPTION);
            ShareTableView.this.theData[n][n2] = shareCacheEntry.getDescription();
        }

        public int getMaxColumnCount() {
            return ShareTableView.this.columnKeys.length;
        }

        public String getColumnModelKey(int n) {
            return ShareTableView.this.columnKeys[n];
        }

        public TableColumn getTableColumn(int n) {
            return (TableColumn)this.tableColumns.elementAt(n);
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < this.getMaxColumnCount()) {
                if (string.compareTo(ShareTableView.this.columnKeys[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public ShareTableModel() {
            ShareTableView.this = ShareTableView.this;
            int n = 0;
            while (n < ShareTableView.this.columnKeys.length) {
                String string = ShareTableView.this.columnKeys[n];
                ActionString actionString = new ActionString(ShareTableView.this.bundle, string);
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(actionString.getString());
                tableColumn.setModelIndex(n);
                this.tableColumns.addElement(tableColumn);
                ++n;
            }
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ShareTableView.this.onSelect();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        boolean needSort = false;

        public void mouseExited(MouseEvent mouseEvent) {
            this.needSort = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.needSort = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.needSort) {
                return;
            }
            this.needSort = false;
            TableColumnModel tableColumnModel = ShareTableView.this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = ShareTableView.this.table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                ShareCacheEntry shareCacheEntry = null;
                if (ShareTableView.this.getNumSelections() != 0) {
                    shareCacheEntry = (ShareCacheEntry)ShareTableView.this.getSelectedItem();
                }
                ShareTableView.this.oldSortColumn = ShareTableView.this.theSortColumn;
                ShareTableView.this.theSortColumn = n2;
                ShareTableView.this.ascendSort = ShareTableView.this.theSortColumn == ShareTableView.this.oldSortColumn ? !ShareTableView.this.ascendSort : true;
                ShareTableView.this.tableSorter.sortByColumn(ShareTableView.this.theSortColumn, ShareTableView.this.ascendSort);
                ShareTableView.this.fireSortChanged();
                if (shareCacheEntry != null) {
                    ShareTableView.this.find(shareCacheEntry.getPathname());
                }
            }
        }

        /* synthetic */ 2() {
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        ShareTableView listView;

        public TableMouseListener(ShareTableView shareTableView2) {
            ShareTableView.this = ShareTableView.this;
            this.listView = shareTableView2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = ShareTableView.this.table.rowAtPoint(point);
            ShareTableView.this.table.columnAtPoint(point);
            if (mouseEvent.isPopupTrigger()) {
                ShareTableView.this.doPopupMenu(mouseEvent, true);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n == -1) {
                ShareTableView.this.table.clearSelection();
                return;
            }
            if (mouseEvent.isControlDown() || mouseEvent.getClickCount() != 2) {
                return;
            }
            this.listView.fireItemPressed(2);
            ActionEvent actionEvent = new ActionEvent(this.listView, 1001, "ViewShare");
            ShareActionsListener shareActionsListener = new ShareActionsListener();
            shareActionsListener.actionPerformed(actionEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ShareTableView.this.doPopupMenu(mouseEvent, true);
            }
        }
    }
}

