/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.ClientListView;
import com.sun.admin.fsmgr.client.share.ClientListViewEvent;
import com.sun.admin.fsmgr.client.share.ClientListViewListener;
import com.sun.admin.fsmgr.client.share.ClientTableRow;
import com.sun.admin.fsmgr.client.share.ClientViewPanel;
import com.sun.admin.fsmgr.client.share.FsMgrAddShareAuthDlg;
import com.sun.admin.fsmgr.client.share.SecModePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClientTablePanel
extends JPanel {
    private static final String COLON = ":";
    SecModePanel modePanel;
    ClientViewPanel table;
    JLabel tableLbl;
    ClientTablePanel tablePanel;
    UpDownBtnPanel udPanel;
    AddModRemBtnPanel amrPanel;
    String defaultStr = FsMgrResourceStrings.getString("sec_mode_default_lbl");
    String customStr = FsMgrResourceStrings.getString("sec_mode_custom_lbl");
    public static boolean defaultList;

    public ClientTablePanel(SecModePanel secModePanel) {
        this.modePanel = secModePanel;
        this.tablePanel = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.tablePanel.setLayout(gridBagLayout);
        this.tableLbl = new JLabel(this.defaultStr);
        Constraints.constrain(this.tablePanel, this.tableLbl, 0, 0, 2, 1, 0, 16, 0.0, 0.0, 0, 5, 0, 0);
        this.table = new ClientViewPanel();
        this.table.addListViewListener(new ClientTableListener());
        Constraints.constrain(this.tablePanel, this.table, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 2, 5, 5, 5);
        this.udPanel = new UpDownBtnPanel();
        Constraints.constrain(this.tablePanel, this.udPanel, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 0, 5, 0);
        this.amrPanel = new AddModRemBtnPanel();
        Constraints.constrain(this.tablePanel, this.amrPanel, 0, 2, 2, 1, 0, 17, 0.0, 0.0, 0, 5, 5, 5);
    }

    private void notifySelectionChange(int n) {
        if (n > 0) {
            if (!this.table.getCurrentView().isFirstRow()) {
                this.udPanel.upBtn.setEnabled(true);
            } else {
                this.udPanel.upBtn.setEnabled(false);
            }
            if (!this.table.getCurrentView().isLastRow()) {
                this.udPanel.downBtn.setEnabled(true);
            } else {
                this.udPanel.downBtn.setEnabled(false);
            }
            this.amrPanel.modifyBtn.setEnabled(true);
            this.amrPanel.removeBtn.setEnabled(true);
            return;
        }
        this.udPanel.enableButtons(false);
        this.amrPanel.modifyBtn.setEnabled(false);
        this.amrPanel.removeBtn.setEnabled(false);
    }

    public void enablePanel(boolean bl) {
        this.tableLbl.setEnabled(bl);
        this.table.setEnabled(bl);
        this.amrPanel.enableButtons(bl);
    }

    public void setDefaultLabel() {
        this.tableLbl.setText(this.defaultStr);
    }

    public void setCustomLabel() {
        this.tableLbl.setText(this.customStr);
    }

    public void setDefaultList(boolean bl) {
        defaultList = bl;
    }

    public String getRoList() {
        String string = "";
        Vector vector = this.table.getCurrentView().getRowData();
        if (vector.size() > 0) {
            String string2 = FsMgrResourceStrings.getString("read_only");
            int n = 0;
            while (n < vector.size()) {
                ClientTableRow clientTableRow = (ClientTableRow)vector.elementAt(n);
                if (clientTableRow.getAccessStr().equals(string2)) {
                    string = String.valueOf(string) + clientTableRow.getClientName() + COLON;
                }
                ++n;
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
                return string;
            }
        }
        return null;
    }

    public String getRwList() {
        String string = "";
        Vector vector = this.table.getCurrentView().getRowData();
        if (vector.size() > 0) {
            String string2 = FsMgrResourceStrings.getString("read_write");
            int n = 0;
            while (n < vector.size()) {
                ClientTableRow clientTableRow = (ClientTableRow)vector.elementAt(n);
                if (clientTableRow.getAccessStr().equals(string2)) {
                    string = String.valueOf(string) + clientTableRow.getClientName() + COLON;
                }
                ++n;
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
                return string;
            }
        }
        return null;
    }

    public String getRootList() {
        String string = "";
        Vector vector = this.table.getCurrentView().getRowData();
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                ClientTableRow clientTableRow = (ClientTableRow)vector.elementAt(n);
                if (clientTableRow.isRoot()) {
                    string = String.valueOf(string) + clientTableRow.getClientName() + COLON;
                }
                ++n;
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
                return string;
            }
        }
        return null;
    }

    private class ClientTableListener
    implements ClientListViewListener {
        public void itemPressed(ClientListViewEvent clientListViewEvent) {
            ClientListView clientListView = clientListViewEvent.getSource();
            Vector vector = ClientTablePanel.this.table.getCurrentView().getRowData();
            if (vector.size() > 0) {
                ClientTablePanel.this.notifySelectionChange(clientListView.getNumSelections());
            }
        }

        public void viewChanged(ClientListViewEvent clientListViewEvent) {
        }

        public void sortChanged(ClientListViewEvent clientListViewEvent) {
        }

        public void sortOrderChanged(ClientListViewEvent clientListViewEvent) {
        }

        ClientTableListener() {
            ClientTablePanel.this = ClientTablePanel.this;
        }
    }

    class UpDownBtnPanel
    extends JPanel {
        JButton upBtn;
        JButton downBtn;

        UpDownBtnPanel() {
            ClientTablePanel.this = ClientTablePanel.this;
            this.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            Constraints.constrain(this, jPanel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
            this.upBtn = new JButton();
            this.upBtn.setMargin(new Insets(0, 0, 0, 0));
            Constraints.constrain(jPanel, this.upBtn, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 5, 0, 5, 0);
            this.upBtn.addActionListener(new UpBtnListener());
            this.downBtn = new JButton();
            this.downBtn.setMargin(new Insets(0, 0, 0, 0));
            Constraints.constrain(jPanel, this.downBtn, 0, 1, 1, 1, 0, 10, 0.0, 0.0, 5, 0, 5, 0);
            this.downBtn.addActionListener(new DownBtnListener());
            this.enableButtons(false);
            JPanel jPanel2 = new JPanel();
            Constraints.constrain(this, jPanel2, 1, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        }

        public void addNotify() {
            super.addNotify();
            Font font = this.upBtn.getFont();
            int n = font != null ? font.getSize() : 8;
            int n2 = 2 * n;
            int n3 = n2 / 2;
            Image image = this.createImage(n2, n);
            Graphics graphics = image.getGraphics();
            graphics.setColor(this.upBtn.getBackground());
            graphics.fillRect(0, 0, n2, n);
            graphics.setColor(Color.black);
            Polygon polygon = new Polygon();
            polygon.addPoint(n3, 1);
            polygon.addPoint(1, n - 2);
            polygon.addPoint(n2 - 2, n - 2);
            graphics.fillPolygon(polygon);
            ImageIcon imageIcon = new ImageIcon(image);
            this.upBtn.setIcon(imageIcon);
            Image image2 = this.createImage(n2, n);
            graphics = image2.getGraphics();
            graphics.setColor(this.downBtn.getBackground());
            graphics.fillRect(0, 0, n2, n);
            graphics.setColor(Color.black);
            polygon = new Polygon();
            polygon.addPoint(1, 1);
            polygon.addPoint(n2 - 2, 1);
            polygon.addPoint(n3, n - 2);
            graphics.fillPolygon(polygon);
            ImageIcon imageIcon2 = new ImageIcon(image2);
            this.downBtn.setIcon(imageIcon2);
        }

        protected void enableButtons(boolean bl) {
            this.upBtn.setEnabled(bl);
            this.downBtn.setEnabled(bl);
        }

        class UpBtnListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ((UpDownBtnPanel)UpDownBtnPanel.this).ClientTablePanel.this.table.getCurrentView().moveUp();
                if (((UpDownBtnPanel)UpDownBtnPanel.this).ClientTablePanel.this.table.getCurrentView().isFirstRow()) {
                    UpDownBtnPanel.this.upBtn.setEnabled(false);
                }
            }

            UpBtnListener() {
                UpDownBtnPanel.this = UpDownBtnPanel.this;
            }
        }

        class DownBtnListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ((UpDownBtnPanel)UpDownBtnPanel.this).ClientTablePanel.this.table.getCurrentView().moveDown();
                if (((UpDownBtnPanel)UpDownBtnPanel.this).ClientTablePanel.this.table.getCurrentView().isLastRow()) {
                    UpDownBtnPanel.this.downBtn.setEnabled(false);
                }
            }

            DownBtnListener() {
                UpDownBtnPanel.this = UpDownBtnPanel.this;
            }
        }
    }

    class AddModRemBtnPanel
    extends JPanel {
        JButton addBtn;
        JButton modifyBtn;
        JButton removeBtn;

        AddModRemBtnPanel() {
            ClientTablePanel.this = ClientTablePanel.this;
            this.setLayout(new GridBagLayout());
            this.addBtn = new JButton(FsMgrResourceStrings.getString("add_dlg_button"));
            Constraints.constrain(this, this.addBtn, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 5, 5, 5);
            this.addBtn.addActionListener(new AddBtnListener());
            this.addBtn.setEnabled(true);
            this.modifyBtn = new JButton(FsMgrResourceStrings.getString("modify_dlg_button"));
            Constraints.constrain(this, this.modifyBtn, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 5, 5, 5);
            this.modifyBtn.addActionListener(new ModifyBtnListener());
            this.modifyBtn.setEnabled(false);
            this.removeBtn = new JButton(FsMgrResourceStrings.getString("remove_button"));
            Constraints.constrain(this, this.removeBtn, 2, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 5, 5, 5);
            this.removeBtn.addActionListener(new RemoveBtnListener());
            this.removeBtn.setEnabled(false);
        }

        protected void enableButtons(boolean bl) {
            this.addBtn.setEnabled(bl);
            if (!bl) {
                this.modifyBtn.setEnabled(bl);
                this.removeBtn.setEnabled(bl);
            }
        }

        class AddBtnListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                FsMgr.getFsMgr().getClientComm().waitOn();
                String string = ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.tableLbl.getText().equals(((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.defaultStr) ? FsMgrResourceStrings.getString("share_wiz_auth_dlg_add_title1") : FsMgrResourceStrings.getString("share_wiz_auth_dlg_add_title2");
                FsMgrAddShareAuthDlg fsMgrAddShareAuthDlg = new FsMgrAddShareAuthDlg(FsMgr.getFsMgr().getFrame(), string, ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.modePanel, ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.modePanel.isDefaultAccess(), null);
                ((Component)fsMgrAddShareAuthDlg).setVisible(true);
                FsMgr.getFsMgr().getClientComm().waitOff();
            }

            AddBtnListener() {
                AddModRemBtnPanel.this = AddModRemBtnPanel.this;
            }
        }

        class ModifyBtnListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                FsMgr.getFsMgr().getClientComm().waitOn();
                String string = ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.tableLbl.getText().equals(((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.defaultStr) ? FsMgrResourceStrings.getString("share_wiz_auth_dlg_mod_title1") : FsMgrResourceStrings.getString("share_wiz_auth_dlg_mod_title2");
                FsMgrAddShareAuthDlg fsMgrAddShareAuthDlg = new FsMgrAddShareAuthDlg(FsMgr.getFsMgr().getFrame(), string, ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.modePanel, ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.modePanel.defaultAccess, ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.modePanel.tablePanel.table.getCurrentView().getSelectedItem());
                ((Component)fsMgrAddShareAuthDlg).setVisible(true);
                FsMgr.getFsMgr().getClientComm().waitOff();
            }

            ModifyBtnListener() {
                AddModRemBtnPanel.this = AddModRemBtnPanel.this;
            }
        }

        class RemoveBtnListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.table.getCurrentView().remove();
                ((AddModRemBtnPanel)AddModRemBtnPanel.this).ClientTablePanel.this.table.getCurrentView().clearSelection();
                AddModRemBtnPanel.this.removeBtn.setEnabled(false);
                AddModRemBtnPanel.this.modifyBtn.setEnabled(false);
            }

            RemoveBtnListener() {
                AddModRemBtnPanel.this = AddModRemBtnPanel.this;
            }
        }
    }
}

