/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.cis.common.WizardStep;
import com.sun.admin.fsmgr.client.BrowseDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrAddMountWizard;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrRemoteFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FsMgrAddMountMntPntStep
implements WizardStep {
    FsMgrAddMountWizard wizard;
    FsMgrMountData mountData;
    JPanel stepPanel = new JPanel();
    JTextField mntpntField;
    FsMgrClient fsMgrClient;
    ErrorDialog errorDlg;
    WarningDialog warningDlg;
    WarningListener warningListener;

    public FsMgrAddMountMntPntStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.stepPanel.setLayout(gridBagLayout);
        this.warningListener = new WarningListener();
        this.fsMgrClient = FsMgrClient.instance();
        FlowArea flowArea = new FlowArea(FsMgrResourceStrings.getString("mount_wiz_mntpnt_explain"));
        Constraints.constrain(this.stepPanel, flowArea, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain(this.stepPanel, jPanel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        JLabel jLabel = new JLabel(FsMgrResourceStrings.getString("mount_wiz_mntpnt"));
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 10);
        this.mntpntField = new JTextField("", 20);
        Constraints.constrain(jPanel, this.mntpntField, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 10, 10);
        this.mntpntField.getDocument().addDocumentListener(new MntPntFieldListener());
        JButton jButton = new JButton(FsMgrResourceStrings.getString("browse_button"));
        Constraints.constrain(jPanel, jButton, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 0, 10, 10);
        jButton.setEnabled(true);
        jButton.addActionListener(new BrowseBtnListener());
        FlowArea flowArea2 = new FlowArea(FsMgrResourceStrings.getString("mount_wiz_mntpnt_warn"));
        Constraints.constrain(this.stepPanel, flowArea2, 0, 2, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain(this.stepPanel, jPanel2, 0, 3, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
    }

    public String getDescription() {
        return FsMgrResourceStrings.getString("mount_wiz_mntpnt_step");
    }

    public Component getComponent() {
        return this.stepPanel;
    }

    public void setActive(int n) {
        this.wizard = FsMgrAddMountWizard.instance();
        this.mountData = this.wizard.getMountData();
        if (!this.mountData.equals(null)) {
            this.mntpntField.setText(this.mountData.getMountPoint());
        }
        this.stepPanel.validate();
    }

    public boolean setInactive(int n) {
        FsMgrRemoteFile fsMgrRemoteFile = null;
        String string = this.mntpntField.getText();
        if (n > 0) {
            if (!string.startsWith("/")) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("share_wiz_dir_err1"));
                return false;
            }
            try {
                fsMgrRemoteFile = this.fsMgrClient.getFile(string);
            }
            catch (FsMgrException fsMgrException) {
                this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
            }
            if (fsMgrRemoteFile == null) {
                this.warningDlg = new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("warning_dlg_title"), FsMgrResourceStrings.getString("MntPntDirDoesntExist"), (ActionListener)this.warningListener, FsMgrResourceStrings.getString("ok_button"));
                try {
                    fsMgrRemoteFile = this.fsMgrClient.getFile(string);
                }
                catch (FsMgrException fsMgrException) {
                    this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
                }
                if (fsMgrRemoteFile == null) {
                    return false;
                }
            }
            this.mountData.setMountPoint(string);
            this.wizard.setMountData(this.mountData);
        }
        return true;
    }

    class MntPntFieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            FsMgrAddMountMntPntStep.this.wizard.setForwardEnabled(documentEvent.getDocument().getLength() != 0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        MntPntFieldListener() {
            FsMgrAddMountMntPntStep.this = FsMgrAddMountMntPntStep.this;
        }
    }

    class BrowseBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowseDialog browseDialog = new BrowseDialog(FsMgrResourceStrings.getString("browse_title"), FsMgrAddMountMntPntStep.this.mntpntField);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)browseDialog).setLocation(dimension.width / 2 - browseDialog.getSize().width / 2, dimension.height / 2 - browseDialog.getSize().height / 2);
            ((Component)browseDialog).setVisible(true);
        }

        BrowseBtnListener() {
            FsMgrAddMountMntPntStep.this = FsMgrAddMountMntPntStep.this;
        }
    }

    class WarningListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FsMgrAddMountMntPntStep.this.fsMgrClient.makeDirectory(FsMgrAddMountMntPntStep.this.mntpntField.getText());
                return;
            }
            catch (FsMgrException fsMgrException) {
                FsMgrAddMountMntPntStep.this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
                return;
            }
        }

        WarningListener() {
            FsMgrAddMountMntPntStep.this = FsMgrAddMountMntPntStep.this;
        }
    }
}

