/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableLibrary;
import com.sun.admin.cis.service.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.admin.cis.service.directorytable.DirectoryUtility;
import com.sun.admin.cis.service.directorytable.FileDirectoryTable;
import com.sun.admin.cis.service.directorytable.FileEditor;
import com.sun.admin.cis.service.directorytable.NisTableDefinitions;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NisDirectoryTable
extends FileDirectoryTable {
    private static final String ypwhichCmd = "/usr/bin/ypwhich";
    private static final String echoCmd = "/usr/bin/echo";
    private static final String makeCmd = "/usr/ccs/bin/make";
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private String makeFile;
    private String makePath;
    private String updateSchedule;
    String domainName;
    String serverName;

    public NisDirectoryTable() {
        try {
            this.makePath = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.makepath");
            if (this.makePath == null || this.makePath.equals("")) {
                this.makePath = "/var/yp";
            }
        }
        catch (AdminException adminException) {
            this.makePath = "/var/yp";
        }
        try {
            this.makeFile = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.makefile");
            if (this.makeFile == null || this.makeFile.equals("")) {
                this.makeFile = "Makefile";
            }
        }
        catch (AdminException adminException) {
            this.makeFile = "Makefile";
        }
        try {
            this.updateSchedule = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.updateschedule");
            if (this.updateSchedule == null || this.updateSchedule.equals("")) {
                this.updateSchedule = "always";
            }
            return;
        }
        catch (AdminException adminException) {
            this.updateSchedule = "always";
            return;
        }
    }

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        String string2 = nisTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string2, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public void open(String string) throws DirectoryTableException {
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(nisTableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(string, "file", string);
        }
        if (!this.isMaster(nisTableDefinitions, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(string, "file", string);
        }
        this.tableDefinitions = nisTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file", tableDefinitions.getMappedTableName());
        }
        if (!this.isMaster(tableDefinitions, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file", tableDefinitions.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            n = DirectoryTableLibrary.convertAccessToMode(tableDefinitions.getAccess());
            n2 = DirectoryTableLibrary.fileCreate(tableDefinitions.getMappedTableName(), tableDefinitions.getUser(), tableDefinitions.getGroup(), n);
            DirectoryTableLibrary.errnoToException(n2, tableDefinitions);
        }
        this.addMakefileEntry(tableDefinitions);
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = true;
    }

    public void create(String string) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(nisTableDefinitions.getMappedTableName(), 0) != 0) {
            n = DirectoryTableLibrary.convertAccessToMode(nisTableDefinitions.getAccess());
            n2 = DirectoryTableLibrary.fileCreate(nisTableDefinitions.getMappedTableName(), nisTableDefinitions.getUser(), nisTableDefinitions.getGroup(), n);
            DirectoryTableLibrary.errnoToException(n2, nisTableDefinitions);
        }
        this.addMakefileEntry(nisTableDefinitions);
        this.tableDefinitions = nisTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = true;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.fileDelete(tableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.fileDelete(nisTableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, nisTableDefinitions);
    }

    public void flush() throws DirectoryTableException {
        String string = null;
        if (this.tableDefinitions == null) {
            return;
        }
        string = this.tableDefinitions.getTableName().equals("shadow") ? "passwd" : (this.tableDefinitions.getTableName().equals("auto_home") ? "auto.home" : (this.tableDefinitions.getTableName().equals("auto_master") ? "auto.master" : this.tableDefinitions.getTableName()));
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + makeCmd + " -f " + this.makeFile + " " + string};
        if (this.needsFlush && this.updateSchedule.equals("always")) {
            String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
            this.needsFlush = false;
        }
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new NisTableDefinitions(this.serverName, this.domainName);
    }

    public void setContext(String string) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getServerFromContext(string);
        this.domainName = DirectoryUtility.getDomainFromContext(string);
        if (this.domainName.length() > 0 && this.domainName.charAt(this.domainName.length() - 1) == '.') {
            this.domainName = this.domainName.substring(0, this.domainName.length() - 1);
        }
        try {
            if (!this.serverName.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                throw new DirectoryTableOperationNotSupportedException("Remote NIS Master");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new DirectoryTableException("EXM_INTERNAL");
        }
    }

    private void addMakefileEntry(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (this.checkForMakefileTarget(tableDefinitions.getTableName())) {
            return;
        }
        String string = tableDefinitions.getRawMappedTableName();
        string = this.convertMacrosToVariables(string);
        String string2 = String.valueOf(string) + ":";
        this.appendMakefileLine(string2);
        string2 = String.valueOf(tableDefinitions.getTableName()) + ": " + tableDefinitions.getTableName() + ".time";
        this.appendMakefileLine(string2);
        string2 = String.valueOf(tableDefinitions.getTableName()) + ".time: " + string;
        this.appendMakefileLine(string2);
        int n = 1;
        while (n <= tableDefinitions.getNumberOfColumns()) {
            if ((tableDefinitions.getColumnAttributes(n) & 1) == 1) {
                string2 = "\t@(awk \\047BEGIN { FS=\"" + tableDefinitions.getColumnSeparators() + "\"; OFS=\"\\t\"; } /^[a-zA-Z0-9_]/ { print $$" + n + ", $$0 }\\047 " + string + " $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/" + tableDefinitions.getTableName() + ".by" + tableDefinitions.getColumnName(n) + ";";
                this.appendMakefileLine(string2);
            }
            ++n;
        }
        string2 = "\t@touch " + tableDefinitions.getTableName() + ".time;";
        this.appendMakefileLine(string2);
        string2 = "\t@echo updated " + tableDefinitions.getTableName();
        this.appendMakefileLine(string2);
        int n2 = 1;
        while (n2 <= tableDefinitions.getNumberOfColumns()) {
            if ((tableDefinitions.getColumnAttributes(n2) & 1) == 1) {
                string2 = "\t@if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) " + tableDefinitions.getTableName() + ".by" + tableDefinitions.getColumnName(n2) + "; fi";
                this.appendMakefileLine(string2);
            }
            ++n2;
        }
    }

    private void appendMakefileLine(String string) throws DirectoryTableException {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + echoCmd + " '" + string + "' " + " >> " + this.makeFile};
        String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
    }

    private boolean checkForMakefileTarget(String string) {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + string + ":' " + this.makeFile};
        String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
        return stringArray2.length >= 1;
    }

    private String convertMacrosToVariables(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DIR") == 0 ? String.valueOf(string2) + "$(DIR)" : (string3.compareTo("PWDIR") == 0 ? String.valueOf(string2) + "$(PWDIR)" : (string3.compareTo("ALIASES") == 0 ? String.valueOf(string2) + "$(ALIASES)" : String.valueOf(string2) + string3));
        }
        return string2;
    }

    private boolean isMaster(TableDefinitions tableDefinitions, boolean bl) {
        String string = null;
        if (tableDefinitions.getTableName().equals("shadow")) {
            return this.isMaster("passwd.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("networks")) {
            return this.isMaster("networks.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("aliases")) {
            return this.isMaster("mail.aliases", bl);
        }
        if (tableDefinitions.getTableName().equals("auto_home")) {
            return this.isMaster("auto.home", bl);
        }
        if (tableDefinitions.getTableName().equals("auto_master")) {
            return this.isMaster("auto.master", bl);
        }
        if (tableDefinitions.getTableName().equals("protocols")) {
            return this.isMaster("protocols.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("services")) {
            return this.isMaster("services.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("rpc")) {
            return this.isMaster("rpc.bynumber", bl);
        }
        try {
            int n = 1;
            while (n <= tableDefinitions.getNumberOfColumns()) {
                if ((tableDefinitions.getColumnAttributes(n) & 1) == 1) {
                    string = String.valueOf(tableDefinitions.getTableName()) + ".by" + tableDefinitions.getColumnName(n);
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return this.isMaster(string, bl);
    }

    private boolean isMaster(String string, boolean bl) {
        String string2;
        try {
            string2 = DirectoryUtility.getDirectoryTableProperty("admin.directorytable.nis.ismaster");
            if (string2 == null) {
                string2 = "check";
            }
        }
        catch (AdminException adminException) {
            string2 = "check";
        }
        if (bl || string2.equals("check")) {
            String string3 = DirectoryTableLibrary.nisGetMaster(this.domainName, string);
            return string3.equalsIgnoreCase(this.serverName);
        }
        return string2.equals("yes");
    }

    private String getMakefileVariable(String string) {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + string + "' " + this.makeFile + " | " + sedCmd + " 's/^" + string + "[ \t]*=//'"};
        String[] stringArray2 = AdminCommonTools.CMN_exec(stringArray);
        if (stringArray2.length < 1) {
            return null;
        }
        return stringArray2[0].trim();
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            return vector;
        }
        String string3 = DirectoryTableLibrary.nisGetMaster(string2, "passwd.byname");
        if (string3.equalsIgnoreCase(string)) {
            vector = new Vector<String>();
            vector.addElement("nis:/" + string + "/" + string2);
            return vector;
        }
        return vector;
    }

    public void setup() {
        String string;
        boolean bl = false;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            bl = false;
        } else {
            String string3 = DirectoryTableLibrary.nisGetMaster(string2, "passwd.byname");
            if (string3.equalsIgnoreCase(string)) {
                bl = true;
            }
        }
        if (!bl) {
            try {
                DirectoryUtility.setDirectoryTableProperty("admin.directorytable.nis.ismaster", "no");
                return;
            }
            catch (AdminException adminException) {
                return;
            }
        }
        try {
            DirectoryUtility.setDirectoryTableProperty("admin.directorytable.nis.ismaster", "yes");
        }
        catch (AdminException adminException) {}
        String string4 = this.getMakefileVariable("DIR");
        String string5 = this.getMakefileVariable("PWDIR");
        String string6 = this.getMakefileVariable("ALIASES");
        if (string4 != null) {
            try {
                DirectoryUtility.setDirectoryTableProperty("admin.directorytable.nis.dir", string4);
            }
            catch (AdminException adminException) {}
        }
        if (string5 != null) {
            try {
                DirectoryUtility.setDirectoryTableProperty("admin.directorytable.nis.pwdir", string5);
            }
            catch (AdminException adminException) {}
        }
        if (string6 != null) {
            try {
                DirectoryUtility.setDirectoryTableProperty("admin.directorytable.nis.aliases", string6);
                return;
            }
            catch (AdminException adminException) {
                return;
            }
        }
    }

    public void refreshSetup() {
        this.setup();
    }
}

