/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common.sort;

import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.cis.common.sort.Compare;
import java.util.Random;
import java.util.Vector;

public class Sort {
    private static Random rn = null;
    private static int MAX_ELEMENTS_FOR_COPY = 15000;
    static final int ASCENDING_SORT = 0;
    static final int DESCENDING_SORT = 0;

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void quicksort(Object[] objectArray, int n, int n2, Compare compare) {
        if (n >= n2) {
            return;
        }
        Sort.swap(objectArray, n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (compare.doCompare(objectArray[n4], objectArray[n]) < 0) {
                Sort.swap(objectArray, ++n3, n4);
            }
            ++n4;
        }
        Sort.swap(objectArray, n, n3);
        Sort.quicksort(objectArray, n, n3 - 1, compare);
        Sort.quicksort(objectArray, n3 + 1, n2, compare);
    }

    private static void quicksort(String[] stringArray, int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        Sort.swap(stringArray, n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n4 = n;
        int n5 = n + 1;
        while (n5 <= n2) {
            if (n3 == 0) {
                if (stringArray[n5].compareTo(stringArray[n]) < 0) {
                    Sort.swap(stringArray, ++n4, n5);
                }
            } else if (stringArray[n5].compareTo(stringArray[n]) > 0) {
                Sort.swap(stringArray, ++n4, n5);
            }
            ++n5;
        }
        Sort.swap(stringArray, n, n4);
        Sort.quicksort(stringArray, n, n4 - 1, n3);
        Sort.quicksort(stringArray, n4 + 1, n2, n3);
    }

    private static void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    private static void quicksort(Vector vector, int n, int n2, Compare compare) {
        if (n >= n2) {
            return;
        }
        Sort.swap(vector, n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (compare.doCompare(vector.elementAt(n4), vector.elementAt(n)) < 0) {
                Sort.swap(vector, ++n3, n4);
            }
            ++n4;
        }
        Sort.swap(vector, n, n3);
        Sort.quicksort(vector, n, n3 - 1, compare);
        Sort.quicksort(vector, n3 + 1, n2, compare);
    }

    private static void quicksort(Vector vector, int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        Sort.swap(vector, n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n4 = n;
        int n5 = n + 1;
        while (n5 <= n2) {
            if (n3 == 0) {
                if (((String)vector.elementAt(n5)).compareTo((String)vector.elementAt(n)) < 0) {
                    Sort.swap(vector, ++n4, n5);
                }
            } else if (((String)vector.elementAt(n5)).compareTo((String)vector.elementAt(n)) > 0) {
                Sort.swap(vector, ++n4, n5);
            }
            ++n5;
        }
        Sort.swap(vector, n, n4);
        Sort.quicksort(vector, n, n4 - 1, n3);
        Sort.quicksort(vector, n4 + 1, n2, n3);
    }

    private static void quicksort(QuickVector quickVector, int n, int n2, Compare compare) {
        if (n >= n2) {
            return;
        }
        quickVector.quickSwapElementsAt(n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (compare.doCompare(quickVector.quickElementAt(n4), quickVector.quickElementAt(n)) < 0) {
                quickVector.quickSwapElementsAt(++n3, n4);
            }
            ++n4;
        }
        quickVector.quickSwapElementsAt(n, n3);
        Sort.quicksort(quickVector, n, n3 - 1, compare);
        Sort.quicksort(quickVector, n3 + 1, n2, compare);
    }

    private static void quicksort(QuickVector quickVector, int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        quickVector.quickSwapElementsAt(n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n4 = n;
        int n5 = n + 1;
        while (n5 <= n2) {
            if (n3 == 0) {
                if (((String)quickVector.quickElementAt(n5)).compareTo((String)quickVector.quickElementAt(n)) < 0) {
                    quickVector.quickSwapElementsAt(++n4, n5);
                }
            } else if (((String)quickVector.quickElementAt(n5)).compareTo((String)quickVector.quickElementAt(n)) > 0) {
                quickVector.quickSwapElementsAt(++n4, n5);
            }
            ++n5;
        }
        quickVector.quickSwapElementsAt(n, n4);
        Sort.quicksort(quickVector, n, n4 - 1, n3);
        Sort.quicksort(quickVector, n4 + 1, n2, n3);
    }

    public static void sort(Object[] objectArray, Compare compare) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(objectArray, 0, objectArray.length - 1, compare);
    }

    public static void sort(String[] stringArray, int n) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(stringArray, 0, stringArray.length - 1, n);
    }

    public static void sort(String[] stringArray) {
        Sort.sort(stringArray, 0);
    }

    public static void sort(Vector vector, Compare compare) {
        if (rn == null) {
            rn = new Random();
        }
        if (vector.size() > MAX_ELEMENTS_FOR_COPY) {
            Sort.quicksort(vector, 0, vector.size() - 1, compare);
            return;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Sort.quicksort(objectArray, 0, objectArray.length - 1, compare);
        int n = 0;
        while (n < objectArray.length) {
            vector.setElementAt(objectArray[n], n);
            ++n;
        }
    }

    public static void sort(Vector vector, int n) {
        if (rn == null) {
            rn = new Random();
        }
        if (vector.size() > MAX_ELEMENTS_FOR_COPY) {
            Sort.quicksort(vector, 0, vector.size() - 1, n);
            return;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        Sort.quicksort((String[])objectArray, 0, objectArray.length - 1, n);
        vector.setSize(objectArray.length);
        int n2 = 0;
        while (n2 < objectArray.length) {
            vector.setElementAt(objectArray[n2], n2);
            ++n2;
        }
    }

    public static void sort(Vector vector) {
        Sort.sort(vector, 0);
    }

    public static void sort(QuickVector quickVector, Compare compare) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(quickVector, 0, quickVector.size() - 1, compare);
    }

    public static void sort(QuickVector quickVector, int n) {
        if (rn == null) {
            rn = new Random();
        }
        Sort.quicksort(quickVector, 0, quickVector.size() - 1, n);
    }

    public static void sort(QuickVector quickVector) {
        Sort.sort(quickVector, 0);
    }
}

